@extends('layouts.master')

@section('title', 'Ready to rate | Proxima - Medical Management app')

@section('title-topbar', 'Rate')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- -- datatables plugin -- -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

@endsection



<!-- session successful message -->
@if (Session::has('success'))
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300">{{ Session::get('success') }}</p>
</div>
@endif


<!-- content insert -->
@section('content')
<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.rate_appo.index') }}">Follow
                up | </a>
            <a class="text-gray-300">
                @if ($type_saved === 'saved')
                Saved Notes
                @else
                Notes
                @endif
            </a>
        </span>

        <div class="d-flex justify-content-center">

        </div>
    </div>

    <div class="row">

        <div class="col-12">

            <h5 class="mb-3 text-gray-300"><i class="fas fa-comment-alt"></i>
                @if ($type_saved === 'saved')
                Saved Notes
                @else
                Notes
                @endif
            </h5>

            <div>
                @if (count($rate_notes) > 0)
                @foreach ($rate_notes as $item)
                <div class="row align-items-center shadow b-r-s-cont bg-white overflow-scroll p-2 mb-2">

                    <div class="col-12 col-md-6 col-lg-3 d-flex align-items-center mb-2 mb-md-0">
                        <div class="d-flex">
                            <img class="rounded-circle avatar-m me-3"
                                src="{{ URL::asset('img/useravatar/' . $item->patient->avatar) }}">

                            <div class="">
                                <p class="mb-0 text-xs text-gray-300">
                                    {{ date('d M Y', strtotime($item->start_at)) }} |
                                    {{ $item->branch->name }}
                                </p>

                                <a href="{{ route('sett.invoice.show', $item->id) }}"
                                    class="mb-1 fw-bold text-s text-gray-600">
                                    {{ $item->patient->name }}
                                </a>

                                <p class="mb-0 text-xs text-gray-300"><strong>
                                        {{ $item->patient->phone_number }}
                                    </strong></p>
                            </div>
                        </div>
                    </div>

                    @if ($item->rate->type == 1)
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.service') }} |
                            {{ __('basic.doctors') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">

                            {{ $item->service_item->name }} | @if ($item->doctor)
                            {{ $item->doctor->name }}
                            @else
                            No Doctor
                            @endif
                        </h6>
                    </div>
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.service') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->service == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @endif
                                </div>
                            </div>

                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.doctors') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->doctor == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.reception') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->reception == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.time') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->time == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.cleanliness') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->cleanliness == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>
                    @else
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.service') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            {{ $item->service_item->name }}
                        </h6>
                    </div>
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">
                            {{ __('basic.reason') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            {{ $item->rate->cancel->name }}
                        </h6>
                    </div>
                    @endif

                    @if ($item->rate->note)
                    <div class="col col-md-3 text-center">
                        <a data-bs-toggle="modal" data-bs-target="#patient_note{{ $item->rate->id }}"
                            class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 rate-appointment"><i
                                class="fas fa-comment-alt fa-sm me-1"></i> Note</a>
                    </div>
                    @endif

                    <div class="modal fade" id="patient_note{{ $item->rate->id }}" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i
                                            class="fas fa-comment-alt me-1"></i>
                                        Patient Note</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <!-- Modal content -->
                                <div class="modal-body px-5 py-3">

                                    <div class="row mb-2">

                                        <div class="col-12 mb-2">
                                            <div class="form-control-textarea overflow-auto">
                                                {{ $item->rate->note }}
                                            </div>
                                        </div>

                                    </div>

                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link"
                                            data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <a type="button"
                                            class="btn btn-default btn-link save_note_js @if ($item->rate->saved == 1) text-gray-700 @else main-color @endif"
                                            data-id="{{ $item->rate->id }}" data-status="{{ $item->rate->saved }}">
                                            @if ($item->rate->saved == 1)
                                            <i class="fas fa-archive me-1"></i>
                                            Save Note
                                            @else
                                            <i class="fas fa-check me-1"></i>Saved Note
                                            @endif
                                        </a>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>

                </div>
                @endforeach
                @else
                <div class="text-center text-gray-500 fs-5"><i
                        class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                    <p class="fw-light mb-0">No Saved Notes </p>
                </div>
                @endif

            </div>

            <div class="d-flex mt-4 justify-content-end">
                {{ $rate_notes->appends(request()->input())->links() }}
            </div>

        </div>
    </div>
</div>
@endsection


<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.myselect2-insert-nosearch').select2({
                dropdownParent: $("#send_rate"),
                minimumResultsForSearch: -1
            });

            var logID = 'log',
                log = $('<div id="' + logID + '"></div>');
            $('body').append(log);
            $('[type*="radio"]').change(function() {
                var me = $(this);
                log.html(me.attr('value'));
            });
        });
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js">
</script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "yyyy-mm-dd",
            });
        });

        $(document).ready(function() {
            $(document).on('change', '#calendar-date-input', function() {
                var date = $(this).val();

                var url = "{{ route('sett.ready_rate', ':date') }}";
                url = url.replace(':date', date);

                window.location.href = url;
            });
        })
</script>


<!-- delete confirmation modal -->
<script>
    $('.rate-appointment').click(function(event) {
            var id = $(this).data("id");
            $('#appointment_id_input').val(id);
        })

        //to save patient note
        $('.save_note_js').click(function(event) {
            var id = $(this).data("id");
            var status = $(this).attr("data-status");
            this_outside = $(this);

            if (status == 1) {
                var status_after = 2;
            } else {
                var status_after = 1;
            }

            var url = "{{ route('sett.save_rate_note', ':id') }}";
            url = url.replace(':id', id);

            $.ajax({
                url: url,
                type: "POST",
                data: {
                    '_token': "{{ csrf_token() }}",
                    '_method': "PATCH",
                    'status': status_after,
                },
                success: function(data) {
                    if (data == 1) {
                        this_outside.attr('data-status', status_after);
                        if (status_after == 1) {
                            this_outside.removeClass('main-color')
                            this_outside.addClass('text-gray-700')
                            this_outside.html('<i class = "fas fa-archive me-1"></i>Save Note')
                        } else {
                            this_outside.removeClass('text-gray-700')
                            this_outside.addClass('main-color')
                            this_outside.html('<i class = "fas fa-check me-1"></i>Saved Note')

                        }
                    }
                }

            });

        })
</script>

<script>
    $(document).ready(function() {
            var table = $('#p-lab-table').DataTable({
                lengthChange: true,
                buttons: [{
                    extend: 'csv',
                    split: ['pdf', 'excel'],
                }]
            });
        });
</script>

<!-- -- datatables plugin -- -->
<script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.bootstrap5.min.js"></script>

<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.print.min.js"></script>
<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.colVis.min.js"></script>



@endsection