@extends('layouts.master')

@section('title', 'Follow up | Proxima - Medical Management app')

@section('title-topbar', __('basic.follow up'))

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-center">

        <div class="d-flex justify-content-center mt-2 mt-md-0 ms-auto">

            <a class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1" data-bs-toggle="modal"
                data-bs-target="#new_record"><i class="fas fa-filter fa-sm me-1"></i> Filter</a>

            <!-- Modal for search filtering -->
            <div class="modal fade" id="new_record" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                    <form class="mb-0" action="{{ route('sett.index_cancel_rate') }}" method="GET"
                        style="display: contents">

                        <div class="modal-content b-r-s-cont border-0">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-clipboard me-1"></i>
                                    Search Filter</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>

                            <!-- Modal content -->
                            <div class="modal-body px-5 py-3">

                                <div class="row">

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Specialty
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="specialty" name="specialty">
                                            <option value="">
                                                All
                                            </option>
                                            @foreach ($specialty_cat as $item)
                                            <option value="{{ $item->id }}" @if ($specialty==$item->id) selected @endif
                                                @if ($specialty == $item->id) selected @endif>
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">Branch
                                            <small>(optional)</small></label>
                                        <select
                                            class="myselect2-record-insert myselect2-record-insert-nosearch select2-hidden-accessible"
                                            id="branch" name="branch">
                                            <option value="">
                                                All
                                            </option>
                                            @foreach ($branches as $item)
                                            <option value="{{ $item->id }}" @if ($branch==$item->id) selected @endif
                                                @if ($branch == $item->id) selected @endif>
                                                {{ $item->name }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">From
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="from" type="text" class="form-control hasdatetimepicker"
                                                value="{{ $from }}" placeholder="YYYY/MM">
                                        </div>
                                    </div>

                                    <div class="col-12 mb-2">
                                        <label class="form-label">To
                                            <small>(optional)</small></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                                </div>
                                            </div>
                                            <input name="to" type="text" class="form-control hasdatetimepicker"
                                                value="{{ $to }}" placeholder="YYYY/MM">
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-footer">
                                <div class="left-side">
                                    <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">Never
                                        Mind</button>
                                </div>
                                <div class="divider"></div>
                                <div class="right-side">
                                    <button type="submit" class="btn btn-default btn-link main-color">Search</button>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

            </div>
        </div>

    </div>

    <div class="row mb-3">

        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.rate_appo.index') }}" class="nav-link" id="year_invoice-tab"><i
                        class="fas fa-headset me-1"></i>
                    {{ __('basic.follow up calls') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.index_cancel_rate') }}" class="nav-link active" id="specialty-tab"><i
                        class="fas fa-ban me-1"></i>
                    {{ __('basic.cancellation') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.index_inactive_patient') }}" class="nav-link" id="specialty-tab"><i
                        class="fas fa-bullhorn me-1"></i>
                    {{ __('basic.leads') }}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="{{ route('sett.op_follow_up') }}" class="nav-link" id="specialty-tab"><i
                        class="fas fa-user-md me-1"></i>
                    {{ __('basic.op follow up') }}</a>
            </li>
        </ul>
    </div>

    <div class="row">

        <div class="col-12 col-md-7">
            <div class="card card-input shadow mb-3 pb-3 pt-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-chart-bar me-1"></i>
                        {{ __('basic.cancellation statistics') }}
                    </h6>
                </div>
                <!-- Card Body -->
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-12">
                            <div class="chart-pie px-1">
                                <canvas id="myChart-cancel_cat">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-md-5">

            <div class="col-12 mb-3">
                <div class="card shadow h-100 p-1 ">
                    <div class="card-body p-2 px-5 px-md-4">
                        <p class="text-center text-s fw-bold text-gray-400">Cancellation percentage</p>
                        <div class="row no-gutters align-items-center">
                            <div class="col-9 p-0">
                                <a href="{{ route('sett.cancellation_appointments') }}">
                                    <div class=" mb-0 fw-bold text-gray-700">
                                        <span class="h1">{{ $percentage_cancellation }}</span>
                                        <small>%</small>
                                    </div>
                                    <div class="text-xxs text-gray-400 text-uppercase">

                                    </div>
                                </a>
                            </div>
                            <div class="col-3 text-center p-0 text-white">
                                <i class="fas fa-times h1 text-gray-400"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 mb-3">
                <div class="card shadow h-100 p-1 ">
                    <div class="card-body p-2 px-5 px-md-4">
                        <p class="text-center text-s fw-bold text-gray-400">Finished appointments percentage</p>
                        <div class="row no-gutters align-items-center">
                            <div class="col-9 p-0">
                                <a>
                                    <div class=" mb-0 fw-bold text-gray-700">
                                        <span class="h1">{{ $percentage_done }}</span>
                                        <small>%</small>
                                    </div>
                                    <div class="text-xxs text-gray-400 text-uppercase">

                                    </div>
                                </a>
                            </div>
                            <div class="col-3 text-center p-0 text-white">
                                <i class="fas fas fa-check h1 text-gray-400"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 mb-3">
                <div class="card shadow h-100 p-1 ">
                    <div class="card-body p-2 px-5 px-md-4">
                        <p class="text-center text-s fw-bold text-gray-400">Not accepted appointments percentage</p>
                        <div class="row no-gutters align-items-center">
                            <div class="col-9 p-0">
                                <a>
                                    <div class=" mb-0 fw-bold text-gray-700">
                                        <span class="h1">{{ $percentage_notaccepted }}</span>
                                        <small>%</small>
                                    </div>
                                    <div class="text-xxs text-gray-400 text-uppercase">

                                    </div>
                                </a>
                            </div>
                            <div class="col-3 text-center p-0 text-white">
                                <i class="fas fa-question h1 text-gray-400"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- links -->
            <div class="col-12 mb-4">
                <div class="card shadow h-100 main-color-bg p-1">
                    <div class="card-body d-flex align-self-center p-1 px-2 px-md-3">
                        <div class="row no-gutters align-items-center">
                            <div class="col-5 d-flex align-items-center h-100 p-2 border-right-blue">
                                <a class="text-white" href="{{ route('sett.cancellation_appointments') }}">
                                    Appointments cancellation
                                </a>
                            </div>
                            <div class="col-4 p-2 h-100 d-flex align-items-center border-right-blue">
                                <a class="text-white" href="{{ route('sett.ready_rate') }}">
                                    <div class="h6 text-uppercase mb-0">
                                        {{ __('basic.ready to rate') }}</div>
                                </a>
                            </div>
                            <div class="col-3 text-center p-2 text-white">
                                <a class="text-white" href="{{ route('sett.index_rate_note') }}">
                                    <div class="h6 text-uppercase mb-0 border-bottom-blue py-2 mb-2">
                                        {{ __('basic.notes') }}</div>
                                </a>

                                <a class="text-white" href="{{ route('sett.index_rate_note', 'saved') }}">
                                    <div class="h6 text-uppercase mb-0">
                                        {{ __('basic.saved notes') }}</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-12">
            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-chart-bar me-1"></i>
                        {{ __('basic.cancellation statistics') }}
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body">

                    <div class="row mb-2">

                        <div class="col-12">
                            <div>
                                <div class="text-center small">
                                    <span class="me-2">
                                        <i class="fas fa-circle text-red"></i> {{ __('basic.cancellation') }}
                                    </span>
                                </div>
                                <canvas id="myChart-patient">
                                    <!-- the code and its style is printed from js -->
                                </canvas>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>


    </div>



    @endsection

    <!-- js insert -->
    @section('js')

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {

                $(".myselect2-record-insert").select2({
                    dropdownParent: $("#new_record")
                });

                //hide search
                $('.myselect2-record-insert-nosearch').select2({
                    dropdownParent: $("#new_record"),
                    minimumResultsForSearch: -1
                });

            })
    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
    <script>
        $(function() {
                $('.hasdatetimepicker').datepicker({
                    todayHighlight: true,
                    format: "mm-yyyy",
                    viewMode: "months",
                    minViewMode: "months"
                });
            });
    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    @php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5'];
    @endphp


    <script>
        // Area Chart for cancellation 
            var ctx = document.getElementById("myChart-patient");
            var myLineChart_patient = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [{
                        label: "Cancellation",
                        lineTension: 0.5,
                        backgroundColor: "#CF637F",
                        borderColor: "#CF637F",
                        pointRadius: 3,
                        pointBackgroundColor: "#CF637F",
                        pointBorderColor: "#CF637F",
                        pointHoverRadius: 3,
                        pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                        pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                        pointHitRadius: 10,
                        pointBorderWidth: 2,
                        data: [
                            @foreach ($appointment_cancel_allyear as $item)
                                {{ $item . ',' }}
                            @endforeach
                        ],
                    }, ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });

            // --------- resource chart ---------
            var ctx_recourse = document.getElementById("myChart-cancel_cat");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($cancel_cat as $item)
                            "{{ $item->cancel->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($cancel_cat as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($cancel_cat as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>


    @endsection