@extends('layouts.master')

@section('title', 'Ready to Cancellation appointment | Proxima - Medical Management app')

@section('title-topbar', 'Cancellation')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- -- datatables plugin -- -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">

@endsection



<!-- session successful message -->
@if (Session::has('success'))
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300">{{ Session::get('success') }}</p>
</div>
@endif


<!-- content insert -->
@section('content')
<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.rate_appo.index') }}">Follow
                up | </a>
            <a class="text-gray-300">Ready to rate</a>
        </span>

        <div class="d-flex justify-content-center">
            @if (request()->date !== 'last15')
            <div class="calendar-datepicker me-1">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" class="form-control hasdatetimepicker"
                        placeholder="YYYY/MM/DD" value="{{ request()->date }}" style="width: 133px;">
                </div>
            </div>
            @endif
        </div>
    </div>

    <div class="card shadow mb-3 pb-2">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-star-half-alt me-2"></i> Ready to rate <span
                    class="text-gray-300 fw-normal">
                    @if (request()->date)
                    {{ request()->date }} Cancellation Appointments
                    @else
                    this month Cancellation Appointments
                    @endif
                </span></h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">

                </div>
            </div>
        </div>

        <!-- Card Body -->
        <div class="card-body">
            <div class="table-responsive">
                <table class="table display datatable-modal" id="p-lab-table" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th class="text-xxs">{{ __('basic.name') }}</th>
                            <th class="text-xxs text-center">{{ __('basic.status') }}</th>
                            <th class="text-xxs text-center">{{ __('basic.branch') }}</th>
                            <th class="text-xxs text-center">{{ __('basic.service') }}</th>
                            <th class="text-xxs text-center">{{ __('basic.doctor') }}</th>
                            <th class="text-xxs text-center">{{ __('basic.creator') }}</th>
                            <th class="text-xxs text-center">{{ __('basic.rate') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($appointment_notdone as $item)
                        @if ($item->status == 0)
                        @php
                        $text_color = 'not_accepted-color-btn';
                        $msg = __('patientappo.not accepted');
                        @endphp
                        @elseif ($item->status == 1)
                        @php
                        $text_color = 'main-color-btn';
                        $msg = __('patientappo.accepted');
                        @endphp
                        @elseif ($item->status == 2)
                        @php
                        $text_color = 'active-color-btn';
                        $msg = __('patientappo.arrived');
                        @endphp
                        @elseif ($item->status == 3)
                        @php
                        $text_color = 'prog-color-btn';
                        $msg = __('patientappo.with doctor');
                        @endphp
                        @elseif ($item->status == 4)
                        @php
                        $text_color = 'done-color-btn';
                        $msg = __('patientappo.done appointment');
                        @endphp
                        @elseif ($item->status == 5)
                        @php
                        $text_color = 'pend-color-btn';
                        $msg = __('patientappo.not respond');
                        @endphp
                        @elseif ($item->status == 6)
                        @php
                        $text_color = 'cancel-color-btn';
                        $msg = __('patientappo.canceled');
                        @endphp
                        @endif

                        <tr>
                            <td>
                                <div class="d-flex">
                                    <img class="rounded-circle avatar-m me-3"
                                        src="{{ URL::asset('img/useravatar/' . $item->patient->avatar) }}">

                                    <div class="">
                                        <p class="mb-0 text-xs text-gray-300">
                                            {{ date('d M Y', strtotime($item->start_at)) }}
                                        </p>

                                        <a href="{{ route('sett.patient.show', $item->patient->id) }}"
                                            class="mb-1 fw-bold text-s text-gray-600">
                                            {{ $item->patient->name }}
                                        </a>

                                        <p class="mb-0 text-xs text-gray-300"><strong>
                                                {{ $item->patient->phone_number }}
                                            </strong></p>
                                    </div>
                                </div>
                            </td>
                            <td class="text-center"> <span class="badge rounded-pill {{ $text_color }} badge-padd-l">{{
                                    $msg }}</span>
                            </td>
                            <td class="text-center">
                                {{ $item->branch->name }}
                            </td>
                            <td class="text-center">
                                {{ $item->service_item->name }}
                            </td>
                            <td class="text-center">
                                @if ($item->doctor)
                                {{ $item->doctor->name }}
                                @else
                                No Doctor
                                @endif
                            </td>
                            <td class="text-center">
                                @if ($item->creator)
                                {{ $item->creator->name }}
                                @else
                                Patient
                                @endif
                            </td>

                            <td class="text-center">
                                @php
                                $rate_url = route('patient_auth.land_rate_appo_public', $item->code);
                                @endphp
                                @if ($item->status == 6)
                                <div class="d-flex justify-content-center" style="width: 180px">
                                    <div data-bs-toggle="modal" data-bs-target="#cancel_rate" data-id="{{ $item->id }}"
                                        class="status-col-link clickable-item-pointer cancel-color-btn shadow-sm rate-appointment b-r-l-cont-left p-2 px-3">
                                        <i class="fas fa-star-half-alt fa-sm me-1"></i>
                                        Reason
                                    </div>
                                    <a target="_blank"
                                        href="{{ 'https://wa.me/+02' . $item->patient->phone_number . '?text= اهلا ' . $item->patient->name . ' في عيادات ' . $clinicname . ' عشان رائيك يهمنا لمعرفة سبب الالغاء لتقديم خدمة افضل في المره المقبلة برجاء الدخول علي الرابط التالي لملئ استبيان ' . $rate_url }}"
                                        class="status-col-link cancel-color-btn shadow-sm b-r-l-cont-right p-2 px-3"><i
                                            class="fab fa-whatsapp"></i> WA</a>
                                </div>
                                @else
                                <div class="d-flex justify-content-center" style="width: 180px">
                                    <div data-bs-toggle="modal" data-bs-target="#send_rate" data-id="{{ $item->id }}"
                                        class="status-col-link main-color-btn text-white clickable-item-pointer shadow-sm b-r-l-cont-left rate-appointment p-2 px-3">
                                        <i class="fas fa-star-half-alt fa-sm"></i>
                                        {{ __('basic.rate') }}
                                    </div>

                                    <a target="_blank"
                                        href="https://wa.me/+2{{  $item->patient->phone_number }}?text=
                                 {{ $item->patient->name }} اهلا
                                علشان رايك يهمنا لتقديم خدمة افضل في الزيارات المقبلة. برجاء الدخول علي الرابط التالي لملئ استبيان خاص باخر زيارة  {{ $rate_url }}"
                                        class="status-col-link main-color-btn text-white shadow-sm b-r-l-cont-right p-2 px-3"><i
                                            class="fab fa-whatsapp"></i> WA</a>

                                    {{-- <a target="_blank"
                                        href="{{ 'https://wa.me/+02' . $item->patient->phone_number . '?text= اهلا ' . $item->patient->name . ' في عيادات ' . $clinicname . ' عشان رائيك يهمنا لتقديم خدمة افضل في المره المقبلة برجاء الدخول علي الرابط التالي لملئ استبيان عن اخر زيارة لك ' . $rate_url }}"
                                        class="status-col-link main-color-btn text-white shadow-sm b-r-l-cont-right p-2 px-3"><i
                                            class="fab fa-whatsapp"></i> WA</a> --}}
                                </div>
                                @endif
                            </td>


                        </tr>
                        @endforeach

                        <div class="modal fade" id="send_rate" tabindex="-1" role="dialog"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                                <form class="mb-0" action="{{ route('sett.rate_appo.store') }}" method="POST"
                                    style="display: contents">

                                    @csrf
                                    @method('POST')

                                    <input id="appointment_id_input" name="appointment_id_input" type="hidden" value="">

                                    <input name="rate_type" type="hidden" value="1">

                                    <div class="modal-content b-r-s-cont border-0">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel"><i
                                                    class="fas fa-star-half-alt me-1"></i>
                                                {{ __('basic.rate') }}</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>

                                        <!-- Modal content -->
                                        <div class="modal-body px-5 py-3">

                                            <div class="row mb-2">

                                                <div class="col-12 mb-2 text-center">
                                                    <label class="form-label">{{ __('basic.service') }}
                                                        <small>({{ __('basic.optional') }})</small></label>

                                                    <div class="rating">
                                                        <input id="rate-service-5" type="radio" name="rate_service"
                                                            value="5" /><label for="rate-service-5"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-service-4" type="radio" name="rate_service"
                                                            value="4" /><label for="rate-service-4"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-service-3" type="radio" name="rate_service"
                                                            value="3" /><label for="rate-service-3"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-service-2" type="radio" name="rate_service"
                                                            value="2" /><label for="rate-service-2"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-service-1" type="radio" name="rate_service"
                                                            value="1" /><label for="rate-service-1"><i
                                                                class="fas fa-star"></i></label>
                                                    </div>
                                                    <span id="rate_service" class="error-msg-form"></span>

                                                    @error('rate_service')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-2 text-center">
                                                    <label class="form-label">{{ __('basic.doctors') }}
                                                        <small>({{ __('basic.optional') }})</small></label>

                                                    <div class="rating text-center">
                                                        <input id="rate-doctor-5" type="radio" name="rate_doctor"
                                                            value="5" /><label for="rate-doctor-5"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-doctor-4" type="radio" name="rate_doctor"
                                                            value="4" /><label for="rate-doctor-4"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-doctor-3" type="radio" name="rate_doctor"
                                                            value="3" /><label for="rate-doctor-3"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-doctor-2" type="radio" name="rate_doctor"
                                                            value="2" /><label for="rate-doctor-2"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-doctor-1" type="radio" name="rate_doctor"
                                                            value="1" /><label for="rate-doctor-1"><i
                                                                class="fas fa-star"></i></label>
                                                    </div>
                                                    <span id="rate_doctor" class="error-msg-form"></span>

                                                    @error('rate_doctor')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-2 text-center">
                                                    <label class="form-label">{{ __('basic.reception') }}
                                                        <small>({{ __('basic.optional') }})</small></label>

                                                    <div class="rating text-center">
                                                        <input id="rate-reception-5" type="radio" name="rate_reception"
                                                            value="5" /><label for="rate-reception-5"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-reception-4" type="radio" name="rate_reception"
                                                            value="4" /><label for="rate-reception-4"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-reception-3" type="radio" name="rate_reception"
                                                            value="3" /><label for="rate-reception-3"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-reception-2" type="radio" name="rate_reception"
                                                            value="2" /><label for="rate-reception-2"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-reception-1" type="radio" name="rate_reception"
                                                            value="1" /><label for="rate-reception-1"><i
                                                                class="fas fa-star"></i></label>
                                                    </div>

                                                    <span id="rate_reception" class="error-msg-form"></span>

                                                    @error('rate_reception')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-2 text-center">
                                                    <label class="form-label">{{ __('basic.time') }}
                                                        <small>({{ __('basic.optional') }})</small></label>

                                                    <div class="rating text-center">
                                                        <input id="rate-time-5" type="radio" name="rate_time"
                                                            value="5" /><label for="rate-time-5"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-time-4" type="radio" name="rate_time"
                                                            value="4" /><label for="rate-time-4"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-time-3" type="radio" name="rate_time"
                                                            value="3" /><label for="rate-time-3"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-time-2" type="radio" name="rate_time"
                                                            value="2" /><label for="rate-time-2"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-time-1" type="radio" name="rate_time"
                                                            value="1" /><label for="rate-time-1"><i
                                                                class="fas fa-star"></i></label>
                                                    </div>

                                                    <span id="rate_time" class="error-msg-form"></span>

                                                    @error('rate_time')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-2 text-center">
                                                    <label class="form-label">{{ __('basic.cleanliness') }}
                                                        <small>({{ __('basic.optional') }})</small></label>

                                                    <div class="rating text-center">
                                                        <input id="rate-clean-5" type="radio" name="rate_cleanliness"
                                                            value="5" /><label for="rate-clean-5"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-clean-4" type="radio" name="rate_cleanliness"
                                                            value="4" /><label for="rate-clean-4"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-clean-3" type="radio" name="rate_cleanliness"
                                                            value="3" /><label for="rate-clean-3"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-clean-2" type="radio" name="rate_cleanliness"
                                                            value="2" /><label for="rate-clean-2"><i
                                                                class="fas fa-star"></i></label>
                                                        <input id="rate-clean-1" type="radio" name="rate_cleanliness"
                                                            value="1" /><label for="rate-clean-1"><i
                                                                class="fas fa-star"></i></label>
                                                    </div>

                                                    <span id="rate_cleanliness" class="error-msg-form"></span>

                                                    @error('rate_cleanliness')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label">{{ __('basic.note') }}
                                                        <small>({{ __('basic.optional') }})</small></label>
                                                    <textarea name="rate_note" class="form-control"
                                                        placeholder="Write here your the patient note .." rows="4"
                                                        spellcheck="false"></textarea>

                                                    @error('rate_note')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                            </div>

                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit" class="btn btn-default btn-link main-color">{{
                                                    __('basic.send') }}</button>
                                            </div>
                                        </div>

                                    </div>
                                </form>

                            </div>

                        </div>

                        <div class="modal fade" id="cancel_rate" tabindex="-1" role="dialog"
                            aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                                <form class="mb-0" action="{{ route('sett.rate_appo.store') }}" method="POST"
                                    style="display: contents">

                                    @csrf
                                    @method('POST')

                                    <input id="appointment_id_input_cancel" name="appointment_id_input" type="hidden"
                                        value="">

                                    <input name="rate_type" type="hidden" value="2">

                                    <div class="modal-content b-r-s-cont border-0">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel"><i
                                                    class="fas fa-ban me-1"></i>
                                                {{ __('basic.cancellation reason') }}</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>

                                        <!-- Modal content -->
                                        <div class="modal-body px-5 py-3">

                                            <div class="row mb-2">

                                                <div class="col-12 mb-2">
                                                    <label class="form-label">Reason
                                                        <small>(required)</small></label>
                                                    <select class="myselect2-insert-nosearch select2-hidden-accessible"
                                                        name="reason" required>
                                                        @foreach ($cancel_reasons as $item)
                                                        <option value="{{ $item->id }}">
                                                            {{ $item->name }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="row mb-2">

                                                <div class="col-12 mb-2">
                                                    <label class="form-label">{{ __('basic.note') }}
                                                        <small>({{ __('basic.optional') }})</small></label>
                                                    <textarea name="rate_note" class="form-control"
                                                        placeholder="Write here your the patient note .." rows="4"
                                                        spellcheck="false"></textarea>

                                                    @error('rate_note')
                                                    <span class="error-msg-form">
                                                        {{ $message }}
                                                    </span>
                                                    @enderror
                                                </div>

                                            </div>

                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit" class="btn btn-default btn-link main-color">{{
                                                    __('basic.send') }}</button>
                                            </div>
                                        </div>

                                    </div>
                                </form>

                            </div>

                        </div>


                    </tbody>
                </table>
            </div>
        </div>

    </div>

    @if (request()->date !== 'last15')

    <div class="row p-2">

        <div class="col-12">

            <h5 class="my-3 text-gray-300"><i class="fas fa-star"></i> Rated Appointments</h5>

            <div>
                @foreach ($appointment_done as $item)
                <div class="row align-items-center shadow b-r-s-cont bg-white overflow-scroll p-2 mb-2">

                    <div class="col-12 col-md-6 col-lg-3 d-flex align-items-center mb-2 mb-md-0">
                        <div class="d-flex">
                            <img class="rounded-circle avatar-m me-3"
                                src="{{ URL::asset('img/useravatar/' . $item->patient->avatar) }}">

                            <div class="">
                                <p class="mb-0 text-xs text-gray-300">
                                    {{ date('d M Y', strtotime($item->start_at)) }} |
                                    {{ $item->branch->name }}
                                </p>

                                <a href="{{ route('sett.invoice.show', $item->id) }}"
                                    class="mb-1 fw-bold text-s text-gray-600">
                                    {{ $item->patient->name }}
                                </a>

                                <p class="mb-0 text-xs text-gray-300"><strong>
                                        {{ $item->patient->phone_number }}
                                    </strong></p>
                            </div>
                        </div>
                    </div>

                    @if ($item->rate->type == 1)
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.service') }} |
                            {{ __('basic.doctors') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">

                            {{ $item->service_item->name }} | @if ($item->doctor)
                            {{ $item->doctor->name }}
                            @else
                            No Doctor
                            @endif
                        </h6>
                    </div>
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.service') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->service == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->service == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @else
                                    No rate
                                    @endif
                                </div>
                            </div>

                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.doctors') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->doctor == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->doctor == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @else
                                    No rate
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.reception') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->reception == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->reception == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @else
                                    No rate
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.time') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->time == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->time == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @else
                                    No rate
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>

                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.cleanliness') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            <div>
                                <div class="text-xxs">
                                    @if ($item->rate->cleanliness == 1)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 2)
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star text-red"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 3)
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star text-green-ligh"></i>
                                    <i class="fas fa-star"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 4)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star"></i>
                                    @elseif ($item->rate->cleanliness == 5)
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    <i class="fas fa-star main-color"></i>
                                    @else
                                    No rate
                                    @endif
                                </div>
                            </div>
                        </h6>
                    </div>
                    @else
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.service') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            {{ $item->service_item->name }}
                        </h6>
                    </div>
                    <div class="col col-md-3 text-center">
                        <h6 class="text-gray-300 text-xs mb-1">
                            {{ __('basic.reason') }}</h6>
                        <h6 class="text-s text-gray-500 text-truncate">
                            {{ $item->rate->cancel->name }}
                        </h6>
                    </div>
                    @endif

                    @if ($item->rate->note)
                    <div class="col col-md-3 text-center">
                        <a data-bs-toggle="modal" data-bs-target="#patient_note{{ $item->rate->id }}"
                            class="main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 rate-appointment"><i
                                class="fas fa-comment-alt fa-sm me-1"></i> Note</a>
                    </div>
                    @endif

                    <div class="modal fade" id="patient_note{{ $item->rate->id }}" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i
                                            class="fas fa-comment-alt me-1"></i>
                                        Patient Note</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <!-- Modal content -->
                                <div class="modal-body px-5 py-3">

                                    <div class="row mb-2">

                                        <div class="col-12 mb-2">
                                            <div class="form-control-textarea overflow-auto">
                                                {{ $item->rate->note }}
                                            </div>
                                        </div>

                                    </div>

                                </div>

                                <div class="modal-footer">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-default btn-link"
                                            data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <a type="button"
                                            class="btn btn-default btn-link save_note_js @if ($item->rate->saved == 1) text-gray-700 @else main-color @endif"
                                            data-id="{{ $item->rate->id }}" data-status="{{ $item->rate->saved }}">
                                            @if ($item->rate->saved == 1)
                                            <i class="fas fa-archive me-1"></i>
                                            Save Note
                                            @else
                                            <i class="fas fa-check me-1"></i>Saved Note
                                            @endif
                                        </a>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>

                </div>
                @endforeach
            </div>

            <div class="d-flex mt-4 justify-content-end">
                {{ $appointment_done->appends(request()->input())->links() }}
            </div>

        </div>
    </div>

    @endif
</div>
@endsection


<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.myselect2-insert-nosearch').select2({
                dropdownParent: $("#cancel_rate"),
                minimumResultsForSearch: -1
            });

            var logID = 'log',
                log = $('<div id="' + logID + '"></div>');
            $('body').append(log);
            $('[type*="radio"]').change(function() {
                var me = $(this);
                log.html(me.attr('value'));
            });
        });
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true,
                format: "mm-yyyy",
                viewMode: "months",
                minViewMode: "months"
            });
        });

        $(document).ready(function() {
            $(document).on('change', '#calendar-date-input', function() {
                var date = $(this).val();

                var url = "{{ route('sett.cancellation_appointments', ':date') }}";
                url = url.replace(':date', date);

                window.location.href = url;
            });
        })
</script>


<!-- delete confirmation modal -->
<script>
    $('.rate-appointment').click(function(event) {
            var id = $(this).data("id");
            $('#appointment_id_input').val(id);
            $('#appointment_id_input_cancel').val(id);
        })

        //to save patient note
        $('.save_note_js').click(function(event) {
            var id = $(this).data("id");
            var status = $(this).attr("data-status");
            this_outside = $(this);

            if (status == 1) {
                var status_after = 2;
            } else {
                var status_after = 1;
            }

            var url = "{{ route('sett.save_rate_note', ':id') }}";
            url = url.replace(':id', id);

            $.ajax({
                url: url,
                type: "POST",
                data: {
                    '_token': "{{ csrf_token() }}",
                    '_method': "PATCH",
                    'status': status_after,
                },
                success: function(data) {
                    if (data == 1) {
                        this_outside.attr('data-status', status_after);
                        if (status_after == 1) {
                            this_outside.removeClass('main-color')
                            this_outside.addClass('text-gray-700')
                            this_outside.html('<i class = "fas fa-archive me-1"></i>Save Note')
                        } else {
                            this_outside.removeClass('text-gray-700')
                            this_outside.addClass('main-color')
                            this_outside.html('<i class = "fas fa-check me-1"></i>Saved Note')

                        }
                    }
                }

            });

        })
</script>

<script>
    $(document).ready(function() {
            var table = $('#p-lab-table').DataTable({
                lengthChange: true,
                buttons: [{
                    extend: 'csv',
                    split: ['pdf', 'excel'],
                }]
            });
        });
</script>

<!-- -- datatables plugin -- -->
<script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.11.2/js/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.bootstrap5.min.js"></script>

<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.print.min.js"></script>
<script type="text/javascript" language="javascript"
    src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.colVis.min.js"></script>



@endsection