@extends('layouts.master')

@section('title', 'Statistics | Proxima - Medical Management app')

@section('title-topbar', 'Statistics')


<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">

        <span class="mb-0 me-1">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.appointment.index') }}">{{
                __('basic.appointments') }} | </a>
            <a class="text-gray-300">{{ __('patientappo.appointment statistics') }}</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">
            <div class="cont-branch-calendar me-2">
                <select id="select-specialty-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <option value="all">
                        All
                    </option>
                    @foreach ($specialty_cat as $item)
                    <option value="{{ $item->id }}" @if ($specialty==$item->id) selected @endif>
                        {{ $item->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="cont-branch-calendar">
                <select id="select-branch-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <option value="all">
                        All
                    </option>
                    @foreach ($branches as $item)
                    <option value="{{ $item->id }}" @if ($branch==$item->id) selected @endif>
                        {{ $item->name }}
                    </option>
                    @endforeach
                </select>
            </div>
        </div>

    </div>

    <div class="row">

        <div class="col-12">
            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-chart-bar me-1"></i>
                        {{ __('patientappo.appointment statistics') }}</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body">

                    <ul class="nav nav-tabs mb-5" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="patient-tab" data-bs-toggle="tab"
                                data-bs-target="#patient" type="button" role="tab" aria-controls="patient"
                                aria-selected="true" class="text-gray-500"><i class="fas fa-user me-1"></i>
                                {{ __('patientappo.total appointments') }}</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="country-tab" data-bs-toggle="tab" data-bs-target="#country"
                                type="button" role="tab" aria-controls="country" aria-selected="false"
                                class="main-color"><i class="fas fa-stethoscope me-1"></i>
                                Specialty</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                                type="button" role="tab" aria-controls="branches" aria-selected="false"
                                class="main-color"><i class="fas fa-globe-americas me-1"></i>
                                Branches</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="home-tab" data-bs-toggle="tab" data-bs-target="#home"
                                type="button" role="tab" aria-controls="home" aria-selected="true"
                                class="text-gray-500"><i class="fas fa-user me-1"></i>
                                {{ __('patientappo.doctor creator') }}</button>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">


                        <div class="tab-pane fade show active" id="patient" role="tabpanel" aria-labelledby="patient">

                            <div class="row mb-2 justify-content-center">

                                <div class="col-12 mb-2">
                                    <div>
                                        <canvas id="myChart">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>

                                <div class="col-12 my-2 text-center">

                                    <h6 class="text-gray-400">{{ __('patientappo.total year appointment') }}</h6>
                                    <span class="fs-1">{{ $appointment_total }}<small class="text-gray-300 text-xxxs">
                                            {{ __('basic.appointment') }}</small></span>
                                </div>

                            </div>

                        </div>

                        <div class="tab-pane fade" id="country" role="tabpanel" aria-labelledby="country-tab">


                            <div class="row mb-2">
                                <div class="col-12 col-md-6 border-flex">
                                    <h5 class="text-center text-gray-300">{{ __('patientappo.top speciality appo') }}
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="speciality-chart">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300">
                                        {{ __('patientappo.top speciality appo month') }}
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="speciality-chart_month">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>

                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade" id="branches" role="tabpanel" aria-labelledby="branches-tab">

                            <div class="row mb-2">

                                <div class="col-12 mb-5">
                                    <div>
                                        <canvas id="branches_line">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>

                                <div class="col-12 my-4 text-center">

                                    <div class="row">
                                        <div class="col-12 col-md-6 border-flex mb-2">
                                            <h5 class="text-center text-gray-300">
                                                {{ __('patientappo.top branch appo') }}
                                            </h5>
                                            <div class="chart-pie px-1 pb-3">
                                                <canvas id="branches-chart">
                                                    <!-- the code and its style is printed from js -->
                                                </canvas>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <h5 class="text-center text-gray-300">
                                                {{ __('patientappo.top branch appo month') }}
                                            </h5>
                                            <div class="chart-pie px-1 pb-3">
                                                <canvas id="branches-chart_month">
                                                    <!-- the code and its style is printed from js -->
                                                </canvas>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>


                        </div>

                        <div class="tab-pane fade" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="row">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">{{ __('patientappo.top doctors month') }}
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-doctor_responsible_month">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300">{{ __('patientappo.top creators month') }}
                                    </h5>
                                    <div class="chart-pie px-1">
                                        <canvas id="myChart-creator_month">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row mb-3">
                                <div class="col-12 col-md-6 border-flex mb-3">
                                    <h5 class="text-center text-gray-300">{{ __('patientappo.top doctors') }}
                                    </h5>
                                    <div class="chart-pie px-1 pb-3">
                                        <canvas id="myChart-doctor_responsible">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <h5 class="text-center text-gray-300">{{ __('patientappo.top creators') }}
                                    </h5>
                                    <div class="chart-pie px-1">
                                        <canvas id="myChart-creator">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
        </div>


    </div>



    @endsection

    <!-- js insert -->
    @section('js')

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function() {
                $('.js-example-basic-single').select2();
                //hide search
                $('.select2-no-search').select2({
                    minimumResultsForSearch: -1
                });
            });
    </script>


    <script>
        $(document).ready(function() {

                $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                    var date = $('#select-specialty-calendar').val();
                    var date2 = $('#select-branch-calendar').val();

                    var url = "{{ route('sett.app_allstatcs', [':date', ':date2']) }}";

                    url = url.replace(':date', date).replace(':date2', date2);

                    var url = url;
                    window.location.href = url;
                });

                //--------------------- search engine ajax -------------------

            });
    </script>


    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>
    @php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2'];
    @endphp


    <script>
        // Area Chart for all branches
            var ctx = document.getElementById("myChart");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [{
                        label: "Appointment",
                        lineTension: 0.5,
                        backgroundColor: "#1cc88a",
                        borderColor: "#1cc88a",
                        pointRadius: 3,
                        pointBackgroundColor: "#1cc88a",
                        pointBorderColor: "#1cc88a",
                        pointHoverRadius: 3,
                        pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                        pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                        pointHitRadius: 10,
                        pointBorderWidth: 2,
                        data: [
                            @foreach ($appointment_date as $item)
                                {{ $item . ',' }}
                            @endforeach
                        ],
                    }, ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });

            // Area Chart for each branch
            var ctx = document.getElementById("branches_line");
            var myLineChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
                    datasets: [
                        @php
                            $i = 0;
                        @endphp
                        @foreach ($appointment as $item)
                            {
                                label: "{{ $item->name }}",
                                lineTension: 0.5,
                                backgroundColor: '{{ $chart_color[$i] }}',
                                borderColor: '{{ $chart_color[$i] }}',
                                pointRadius: 3,
                                pointBackgroundColor: '{{ $chart_color[$i] }}',
                                pointBorderColor: '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                                pointHoverRadius: 3,
                                pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                                pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                                pointHitRadius: 10,
                                pointBorderWidth: 2,
                                data: [
                                    @foreach ($item->total as $item4)
                                        {{ $item4 . ',' }}
                                    @endforeach
                                ],
                            },
                        @endforeach

                    ],
                },

                options: {
                    maintainAspectRatio: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        xAxes: [{
                            time: {
                                unit: 'date'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            },
                            ticks: {
                                maxTicksLimit: 7
                            }
                        }],
                        yAxes: [{
                            ticks: {
                                maxTicksLimit: 5,
                                padding: 10,
                                // Include a dollar sign in the ticks
                                callback: function(value, index, values) {
                                    return '$' + number_format(value);
                                }
                            },
                            gridLines: {
                                color: "rgb(234, 236, 244)",
                                zeroLineColor: "rgb(234, 236, 244)",
                                drawBorder: false,
                                borderDash: [2],
                                zeroLineBorderDash: [2]
                            }
                        }],
                    },
                    plugins: {
                        legend: {
                            display: true
                        }
                    },
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        titleMarginBottom: 10,
                        titleFontColor: '#6e707e',
                        titleFontSize: 14,
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        intersect: false,
                        mode: 'index',
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ': $' + number_format(tooltipItem.yLabel);
                            }
                        }
                    }
                }
            });
    </script>

    <script>
        // ---------  doctor responsible chart year ---------
            var ctx_recourse = document.getElementById("myChart-doctor_responsible");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($doctor as $item)
                            "{{ $item->doctor->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($doctor as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($doctor as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- creator chart year ---------
            var ctx_recourse = document.getElementById("myChart-creator");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($creator as $item)
                            "{{ $item->creator->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($creator as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($creator as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- doctor responsible chart month ---------
            var ctx_recourse = document.getElementById("myChart-doctor_responsible_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($doctor_month as $item)
                            "{{ $item->doctor->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($doctor_month as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($doctor_month as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- creator chart month ---------
            var ctx_recourse = document.getElementById("myChart-creator_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'doughnut',
                data: {
                    labels: [
                        @foreach ($creator_month as $item)
                            "{{ $item->creator->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($creator_month as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($creator_month as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>


    <script>
        // --------- specialty chart month ---------
            var ctx_recourse = document.getElementById("speciality-chart");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        @foreach ($specialty_order as $item)
                            "{{ $item->specialty->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($specialty_order as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($specialty_order as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- specialty month chart month ---------
            var ctx_recourse = document.getElementById("speciality-chart_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        @foreach ($specialty_order_month as $item)
                            "{{ $item->specialty->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($specialty_order_month as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($specialty_order_month as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });

            // --------- specialty chart month ---------
            var ctx_recourse = document.getElementById("branches-chart");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        @foreach ($branch_order as $item)
                            "{{ $item->branch->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($branch_order as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($branch_order as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
            // --------- specialty month chart month ---------
            var ctx_recourse = document.getElementById("branches-chart_month");
            var myPieChart2 = new Chart(ctx_recourse, {
                type: 'polarArea',
                data: {
                    labels: [
                        @foreach ($branch_order_month as $item)
                            "{{ $item->branch->name }}",
                        @endforeach
                    ],
                    datasets: [{
                        data: [
                            @foreach ($branch_order_month as $item)
                                {{ $item->total . ',' }}
                            @endforeach
                        ],
                        @php
                            $i = 0;
                        @endphp
                        backgroundColor: [
                            @foreach ($branch_order_month as $item)
                                '{{ $chart_color[$i] }}',
                                @php
                                    $i++;
                                @endphp
                            @endforeach
                        ],
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    tooltips: {
                        backgroundColor: "rgb(255,255,255)",
                        bodyFontColor: "#858796",
                        borderColor: '#dddfeb',
                        borderWidth: 1,
                        xPadding: 15,
                        yPadding: 15,
                        displayColors: false,
                        caretPadding: 10,
                        callbacks: {
                            label: function(tooltipItem) {
                                return tooltipItem.yLabel;
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        colorschemes: {
                            scheme: 'brewer.Paired12'
                        }
                    },
                    cutoutPercentage: 80,
                },
            });
    </script>
    @endsection