@extends('layouts.master')

@section('title', 'With Doctor | Proxima - Medical Management app')

@section('title-topbar', 'Patients Waiting')

<!-- css insert -->
@section('css')
<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<style>
    .select2-container {
        z-index: 99999;
    }
</style>
@endsection

<!-- content insert -->
@section('content')
<div class="container-fluid px-2 mt-3">


    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.appointment.index') }}">{{
                __('basic.appointments') }} |
            </a>
            <a class="text-gray-300">{{ __('basic.patient arrived') }}</a>
        </span>
    </div>

    <div class="row mb-2">
        @if (count($patients) > 0)
        @foreach ($patients as $item)
        <div class="col-12" id="withdoctor-cont-ajax">
            <div class="row align-items-center shadow b-r-s-cont bg-white overflow-scroll p-4 mb-3">

                <div class="col-5 d-flex align-items-center">
                    <img class="rounded-circle avatar-m2 me-3"
                        src="{{ URL::asset('img/useravatar/' . $item->patient->avatar) }}">
                    <div class="">
                        <p class="mb-0 text-xs text-gray-300">{{ __('basic.patient') }}</p>
                        <a href="{{ route('sett.patient.show', $item->patient->id) }}"
                            class="mb-1 fw-bold text-gray-600">
                            {{ $item->patient->name }}
                        </a>
                        <p class="mb-0 text-xs text-gray-400">{{ __('basic.code') }}<strong>
                                {{ $item->patient->code }}
                            </strong></p>
                    </div>
                </div>

                <div class="col text-center">
                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.appointment time') }}</h6>
                    <h6 class="text-s text-gray-400 text-truncate">
                        {{ date('d M Y h:i a', strtotime($item->start_at)) }}
                    </h6>
                </div>

                <div class="col text-center">
                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.service') }}</h6>
                    <h6 class="text-s text-gray-400 text-truncate">
                        @if (count($item->patient->pulses) > 0)
                        <div data-bs-toggle="modal" data-bs-target="#addpulses{{ $item->id }}"
                            class="status-col-link main-color-btn mb-2 text-white clickable-item-pointer shadow-sm b-r-l-cont rate-appointment p-2 px-2">
                            <i class="fas fa-thermometer fa-sm"></i>
                            {{ __('basic.pulses') }}
                        </div>
                        @else
                        No Pulses
                        @endif
                        @if (count($item->patient->sessions) > 0)
                        <div data-bs-toggle="modal" data-bs-target="#addsession{{ $item->id }}"
                            class="status-col-link main-color-btn text-white clickable-item-pointer shadow-sm b-r-l-cont p-2 px-2">
                            <i class="fas fa-syringe fa-sm"></i>
                            {{ __('patientappo.session') }}
                        </div>
                        @endif
                    </h6>

                    <!-- Modal pulses update data -->
                    <div class="modal fade addpulses" id="addpulses{{ $item->id }}" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true" style="overflow:hidden">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i
                                            class="fas fa-thermometer me-1"></i>
                                        Insert Pulses</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <form class="mb-0" action="{{ route('sett.app_withdoctor_service_save') }}"
                                    style="display: contents;" method="POST">
                                    @csrf
                                    @method('PUT')

                                    <!-- Modal content -->
                                    <div class="modal-body px-5 py-3">

                                        @foreach ($item->patient->pulses as $item_p)
                                        <div class="row mb-2 text-start">

                                            @if ($item_p->type == 0)
                                            @php
                                            $text_color = 'active-color-btn';
                                            $msg = __('patientappo.session');
                                            @endphp
                                            @elseif ($item_p->type == 1)
                                            @php
                                            $text_color = 'done-color-btn';
                                            $msg = __('basic.money per pulse');
                                            @endphp
                                            @elseif ($item_p->type == 2)
                                            @php
                                            $text_color = 'prog-color-btn';
                                            $msg = __('basic.session package');
                                            @endphp
                                            @elseif ($item_p->type == 3)
                                            @php
                                            $text_color = 'not_accepted-color-btn';
                                            $msg = __('basic.pulses package');
                                            @endphp
                                            @elseif ($item_p->type == 4)
                                            @php
                                            $text_color = 'pend-color-btn';
                                            $msg = __('basic.free session');
                                            @endphp
                                            @endif

                                            <h6 class="text-gray-300"><i class="fas fa-stethoscope"></i>
                                                @if ($item_p->service_item)
                                                {{ $item_p->service_item->name }}
                                                @else
                                                {{ $item_p->pulse_area->name }}
                                                @endif | <span
                                                    class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg
                                                    }}</span>
                                            </h6>

                                            <div class="col-12 mb-2 text-start">
                                                <label class="form-label"> {{ __('basic.fluence') }}
                                                    <small>({{ __('basic.required') }})</small></label>
                                                <select
                                                    class="select2-no-search select2-hidden-accessible  text-start @error('fluence_update') is-invalid @enderror"
                                                    name="fluence_update[]" required>
                                                    <option @if ($item_p->fluence == 6) selected @endif
                                                        value="6">
                                                        6
                                                    </option>
                                                    <option @if ($item_p->fluence == 7) selected @endif
                                                        value="7">
                                                        7
                                                    </option>
                                                    <option @if ($item_p->fluence == 8) selected @endif
                                                        value="8">
                                                        8
                                                    </option>
                                                    <option @if ($item_p->fluence == 9) selected @endif
                                                        value="9">
                                                        9
                                                    </option>
                                                    <option @if ($item_p->fluence == 10) selected @endif
                                                        value="10">
                                                        10
                                                    </option>
                                                    <option @if ($item_p->fluence == 12) selected @endif
                                                        value="12">
                                                        12
                                                    </option>
                                                    <option @if ($item_p->fluence == 14) selected @endif
                                                        value="14">
                                                        14
                                                    </option>
                                                    <option @if ($item_p->fluence == 16) selected @endif
                                                        value="16">
                                                        16
                                                    </option>
                                                    <option @if ($item_p->fluence == 18) selected @endif
                                                        value="18">
                                                        18
                                                    </option>
                                                    <option @if ($item_p->fluence == 20) selected @endif
                                                        value="20">
                                                        20
                                                    </option>
                                                </select>

                                                <span id="fluence_update_error" class="error-msg-form"></span>

                                                @error('fluence_update')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label">
                                                    {{ __('basic.spot size') }}
                                                    <small>({{ __('basic.required') }})</small></label>

                                                <select
                                                    class="select2-no-search select2-hidden-accessible @error('spot_size') is-invalid @enderror"
                                                    name="spot_size_update[]" required>
                                                    <option @if ($item_p->spot_size == 15) selected @endif
                                                        value="15">
                                                        15
                                                    </option>
                                                    <option @if ($item_p->spot_size == 18) selected @endif
                                                        value="18">
                                                        18
                                                    </option>
                                                    <option @if ($item_p->spot_size == 20) selected @endif
                                                        value="20">
                                                        20
                                                    </option>
                                                    <option @if ($item_p->spot_size == 22) selected @endif
                                                        value="22">
                                                        22
                                                    </option>
                                                    <option @if ($item_p->spot_size == 24) selected @endif
                                                        value="24">
                                                        24
                                                    </option>
                                                </select>

                                                <span id="spot_size_update_error" class="error-msg-form"></span>

                                                @error('spot_size_update')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label">
                                                    {{ __('basic.used pulses') }}
                                                    <small>({{ __('basic.required') }})</small></label>

                                                <input name="used_pulses_update[]" type="number"
                                                    class="form-control @error('used_pulses_update') is-invalid @enderror"
                                                    placeholder="used pulses ..." value="{{ $item_p->used_pulses }}"
                                                    required>

                                                <span id="used_pulses_update_error" class="error-msg-form"></span>

                                                @error('used_pulses_update')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <input name="pulses_id[]" value="{{ $item_p->id }}" type="hidden">

                                            <hr class="my-2">
                                        </div>
                                        @endforeach

                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link"
                                                data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit" class="btn btn-default btn-link main-color">{{
                                                __('basic.update') }}</button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>

                    </div>

                    <!-- Modal pulses update data -->
                    <div class="modal fade addsession" id="addsession{{ $item->id }}" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true" style="overflow:hidden">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i
                                            class="fas fa-thermometer me-1"></i>
                                        Insert Session</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <form class="mb-0" action="{{ route('sett.app_withdoctor_service_save_session') }}"
                                    style="display: contents;" method="POST">
                                    @csrf
                                    @method('PUT')

                                    <!-- Modal content -->
                                    <div class="modal-body px-5 py-3">

                                        @foreach ($item->patient->sessions as $item)
                                        <div class="row mb-2 text-start">

                                            <h6 class="text-gray-300"><i class="fas fa-stethoscope"></i>
                                                {{ $item->service_item->name }}
                                            </h6>

                                            <div class="col-12 mb-2">
                                                <label class="form-label">
                                                    {{ __('basic.status') }}
                                                    <small>({{ __('basic.required') }})</small></label>

                                                <select
                                                    class="select2-no-search select2-hidden-accessible @error('spot_size') is-invalid @enderror"
                                                    name="status[]" required>
                                                    <option @if ($item->status == 0) selected @endif
                                                        value="0">
                                                        not done
                                                    </option>
                                                    <option @if ($item->spot_size == 1) selected @endif
                                                        value="1">
                                                        done
                                                    </option>
                                                </select>

                                                <span id="spot_size_update_error" class="error-msg-form"></span>

                                                @error('spot_size_update')
                                                <span class="error-msg-form">
                                                    {{ $message }}
                                                </span>
                                                @enderror
                                            </div>

                                            <input name="session_id[]" value="{{ $item->id }}" type="hidden">

                                            <hr class="my-2">
                                        </div>
                                        @endforeach

                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link"
                                                data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit" class="btn btn-default btn-link main-color">{{
                                                __('basic.update') }}</button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>

                    </div>

                </div>
                <div class="col text-center">
                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.status') }}</h6>
                    <div class="switch-checkbox">
                        <input class="done_btn" name="withsomeone" type="checkbox" value="{{ $item->id }}"
                            id="{{ $item->id }}"><label for="{{ $item->id }}" class="ms-auto me-auto">Toggle</label>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
        @else
        No patients
        @endif

    </div>

</div>

@endsection

<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });


        //rate insert
        $(document).on('change', '.done_btn', function() {

            var appointment_id = $(this).val();

            var url = "{{ route('sett.app_withdoctor_update', ':id') }}";
            url = url.replace(':id', appointment_id);

            $.ajax({
                url: url,
                type: "POST",
                data: {
                    '_token': "{{ csrf_token() }}",
                    '_method': "PATCH",
                    'status': 4,
                },
                success: function(data) {
                    location.reload();
                }
            });
        });
</script>

@endsection