@extends('layouts.master')

@section('title', 'Show Appointment | Proxima - Medical Management app')

@section('title-topbar', 'Show Appointment')

<!-- css insert -->
@section('css')

@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-center justify-content-md-between mb-3 flex-wrap">
        <span class="mb-0 me-2">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">{{ __('basic.dashboard') }}
                |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.appointment.index') }}">{{
                __('basic.appointments') }}
                | </a>
            <a class="text-gray-300">{{ __('basic.appointment') }}</a>
        </span>
        <div class="d-flex justify-content-center mt-2 mt-md-0">
            @if ($appointment->meet_join_url)
            @php
            $patient_ur_wa = $appointment->meet_join_url;
            @endphp
            <a target="_blank" href="{{ $appointment->meet_join_url }}"
                class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                    class="fas fa-video me-1"></i> Start Video</a>
            @else
            @php
            $patient_ur_wa = route('patient_auth.land_show_pat_appointment_public', $appointment->code);
            @endphp
            @endif

            <a target="_blank"
                href="{{ 'https://wa.me/+2' . $appointment->patient->phone_number . '?text= اهلا' . $appointment->patient->name . ' معاك ' . $appointment->creator->name . ' من عيادات ' . $clinicname . '. تم تاكيد حجزك علي العنوان التالي ' . $appointment->branch->address}}"
                class=" main-color-bg text-white btn btn-sm shadow-sm b-r-l-cont p-2 px-4 me-1"><i
                    class="fab fa-whatsapp me-1"></i> WhatsApp</a>
        </div>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-calendar me-2"></i> {{ __('basic.appointment') }}
            </h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                    aria-labelledby="dropdownMenuLink">
                    <a class="dropdown-item" href="{{ route('sett.appointment.edit', $appointment->id) }}"><i
                            class="fas fa-pen me-1"></i>
                        Edit</a>
                    @if ($appointment->meet_start_url)
                    <a class="dropdown-item copy_clipboard clickable-item-pointer"
                        data-url="{{ $appointment->meet_join_url }}"><i class="fas fa-video me-1"></i>
                        Copy URL Joing online appointment</a>
                    @endif
                </div>
            </div>
        </div>

        <!-- Card Body -->
        <div class="card-body px-3">

            <!-- <div class="text-end px-lg-5"> <a href="#" class="d-none bg-white d-sm-inline-block btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i class="fas fa-download fa-sm text-gray-300 me-1"></i> Print</a> </div> -->

            <div class="row d-flex justify-content-around align-items-center my-2 px-1 px-md-5">

                <div class="col-8 col-md-4 d-flex align-items-center mb-3 mb-md-0">
                    <img id="avatar_final_info" class="rounded-circle avatar-m me-3"
                        src="{{ URL::asset('img/useravatar/' . $appointment->patient->avatar) }}">
                    <div class="">
                        <p class=" mb-0 text-xs text-gray-300">
                            {{ __('basic.patient') }}</p>
                        <a href="{{ route('sett.patient.show', $appointment->patient->id) }}" id="name_final_info"
                            class="mb-1 fw-bold text-gray-600 fs-6">
                            {{ $appointment->patient->name }}
                        </a>
                        <p id="number_final_info" class="mb-0 text-xs text-gray-400">
                            {{ $appointment->patient->phone_number }}</p>
                    </div>
                </div>

                <div class="col-4 col-md-2">
                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.branch') }}</h6>
                    <p id="branch_final_info" class="text-gray-600 text-s fw-bold">
                        {{ $appointment->branch->name }}</p>
                </div>

                <div class="col-4 col-md-2">
                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.address') }}</h6>
                    <p id="addre_final_info" class="text-gray-600 text-s fw-bold">
                        {{ $appointment->branch->address }}</p>
                </div>

                <div class="col-4 col-md-2">
                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.creator') }}</h6>
                    <p id="addre_final_info" class="text-gray-600 text-s fw-bold">
                        {{ $appointment->creator->name }}</p>
                </div>

                <div class="col-4 col-md-2">
                    <div class="visible-print text-center">
                        {!! QrCode::color(68, 95,
                        129)->size(60)->style('round')->eye('circle')->generate($appointment->code) !!}
                        <p class="mt-1 mb-0 text-xs fw-bold text-gray-300">{{ $appointment->code }}</p>
                    </div>
                </div>
            </div>

            <hr>

            <div class="px-2 px-lg-5 mt-4">

                <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                    <div class="me-2">
                        <i class="fas fa-stethoscope me-2 text-gray-400"></i>
                        <span id="service_final_info">
                            {{ $appointment->service_item->name }}
                        </span>
                    </div>
                    <div id="service_price_final_info" class="text-center">
                        @if ($appointment->invoice_item)
                        {{ $appointment->invoice_item->price }} <small class="text-gray-300 text-xxxs">
                            {{ __('basic.egp') }}</small>
                        @else
                        No fees
                        @endif
                    </div>
                </div>


                <div class="d-flex justify-content-between align-items-center px-lg-5 mb-3">
                    <div class="me-2">
                        <i class="fas fa-percent me-2 text-gray-400"></i> {{ __('basic.discount') }}
                    </div>
                    <div id="discount_amount_place" class="text-center text-decoration-line-through">
                        @if ($appointment->invoice_item)
                        @if (!empty($invoice->invoice_item->invoice->discount))
                        {{ $appointment->invoice_item->invoice->discount }} <small class="text-gray-300 text-xxxs">
                            {{ __('basic.egp') }}</small>
                        @else
                        0
                        @endif
                        @else
                        No fees
                        @endif
                    </div>
                </div>

                <div class="d-flex justify-content-between align-items-center px-lg-5 mb-4">
                    <div class="me-2 fw-bold">
                        <i class="fas fa-dollar-sign me-2"></i> {{ __('basic.total price') }}
                    </div>
                    <div id="price_total_final_info" class="fw-bold text-center">

                        @if ($appointment->invoice_item)
                        {{ $appointment->invoice_item->invoice->final_price }} <small class="text-gray-300 text-xxxs">
                            {{ __('basic.egp') }}</small>
                        @else
                        No fees
                        @endif
                    </div>
                </div>

                <div class="row mb-2 px-lg-5">
                    <div class="mb-3">
                        <label class="form-label text-gray-300">{{ __('basic.note') }}</label>
                        <div class="form-control-textarea overflow-auto">{{ $appointment->note }}
                        </div>
                    </div>
                </div>

                @error('appointment_note')
                <span class="error-msg-form">
                    {{ $message }}
                </span>
                @enderror

                <div class="row align-items-center main-color-bg text-white px-lg-5 b-r-s-cont px-4 py-4">
                    <div class="col-12 col-md text-blue-300 mb-2 mb-md-0">
                        {{ __('patientappo.come before 15 msg') }}
                    </div>
                    <div class="col-12 col-md text-center">

                        <h6 class="text-xs mb-1 text-blue-300">{{ __('basic.appointment time') }}</h6>
                        <p id="date_final_info" class="text-l fs-4 fw-bold mb-0">
                            {{ date('h:i a', strtotime($appointment->start_at)) . ' to ' . date('h:i a',
                            strtotime($appointment->end_at)) }}
                        </p>
                        <p id="time_final_info" class="text-s text-blue-200">
                            {{ date('d M Y', strtotime($appointment->start_at)) }}</p>
                    </div>

                </div>

            </div>

        </div>

    </div>
</div>

@endsection

<!-- js insert -->
@section('js')

<script>
    //copy online appointment url
        $(document).on('click', '.copy_clipboard', function() {
            var copyText = $(this).data('url');

            var textarea = document.createElement("textarea");
            textarea.textContent = copyText;
            textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
            document.body.appendChild(textarea);
            textarea.select();
            document.execCommand("copy");

            document.body.removeChild(textarea);
        });
</script>

@endsection