@extends('layouts.master')

@section('title', 'Edit Appointment | Proxima - Medical Management app')

@section('title-topbar', 'Edit Appointment')

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">
        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.home') }}">Dashboard |</a>
            <a class="link-cust-text text-gray-200 fw-light" href="{{ route('sett.appointment.index') }}">Appointment
                | </a>
            <a class="text-gray-300">Edit Appointment</a>
        </span>
    </div>

    <div class="card card-input shadow mb-3 pb-3">
        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-calendar me-2"></i> Edit appointment</h6>
        </div>

        <!-- Card Body -->
        <div class="card-body px-3">

            @foreach ($errors->all() as $error)
            <div class="text-red"><i class="fas fa-exclamation me-1"></i> {{ $error }}</div>
            @endforeach

            <div class="multi-setps-form-calander col-12">

                <form id="myform" method="POST" action="{{ route('sett.appointment.update', $appointment->id) }}"
                    enctype="multipart/form-data">

                    @csrf
                    @method('PUT')

                    <!-- content -->

                    <div class="cont_tap " id="clinics">

                        <div class="row justify-content-center mb-4">
                            <h5 class="text-center text-gray-400 mb-4">Choose your the nearest clinic and the wanted
                                date?
                            </h5>

                            <div class="row justify-content-center">

                                <div class="col ps-lg-5 pe-5">

                                    <div class="my-4">
                                        <label class="form-label">{{ __('basic.specialty') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select id="specialty_selc_form"
                                            class="js-example-basic-single select2-no-search select2-hidden-accessible @error('specialty_id') is-invalid @enderror"
                                            name="specialty_id" required>
                                            @foreach ($specialties as $iteam)
                                            <option @if ($iteam->id == $appointment->specialty_id) selected @endif
                                                value="{{ $iteam->id }}"
                                                data-specialty_name="{{ $iteam->name }}">
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        @error('specialty_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="my-4">
                                        <label class="form-label">Branch <small>(required)</small></label>
                                        <select id="branches_selc_form"
                                            class="js-example-basic-single select2-no-search select2-hidden-accessible @error('branch_id') is-invalid @enderror"
                                            name="branch_id" required>
                                            @foreach ($branches as $iteam)
                                            <option value="{{ $iteam->id }}" @if ($iteam->id == $appointment->branch_id)
                                                selected @endif>
                                                {{ $iteam->name }}
                                            </option>
                                            @endforeach
                                        </select>

                                        @error('branch_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>


                                    <div class="my-3">
                                        <label class="form-label">{{ __('basic.unit') }}
                                            <small>({{ __('basic.required') }})</small></label>
                                        <select id="units_selc_form"
                                            class="js-example-basic-single select2-no-search select2-hidden-accessible @error('unit_id') is-invalid @enderror"
                                            name="unit_id" required>
                                            <option disabled>- Select Branch First -</option>
                                        </select>

                                        @error('unit_id')
                                        <span class="error-msg-form">
                                            {{ $message }}
                                        </span>
                                        @enderror
                                    </div>

                                    <div class="mt-5 d-flex justify-content-lg-between">

                                        <div class="">
                                            Will you bring someone with you?
                                        </div>

                                        <div class="
                                                switch-checkbox">
                                            <input name="withsomeone" type="checkbox" value="1" id="switch"><label
                                                for="switch">Toggle</label>
                                        </div>

                                    </div>


                                </div>

                                <!-- calander -->
                                <div
                                    class="col position-relative px-0 ps-md-4 justify-content-sm-center calander-left-border text-center">


                                    <div class="calander_cont mx-auto position-relative">

                                        <div id="show_slots"
                                            class='text-center calendar_datapicker_timeslots px-2 py-2'>asd
                                            <!-- show timeslots ajax content -->
                                        </div>

                                        <div id="calander_cont">
                                            <!-- calander ajax content -->
                                        </div>
                                    </div>

                                    <!-- showing waiting during ajax performance -->
                                    <div id="waiting" class="w-100 h-100 text-center"
                                        style="position: absolute; top:0px; left:0px;z-index:999999; background-color: #ffffffba;">
                                        <div class="spinner-grow text-primary" role="status"
                                            style="position: relative; top: 50%; transform: translateY(-50%);">
                                            <span class="sr-only">Loading...</span>
                                        </div>
                                    </div>

                                    <input type="hidden" name="calander_date_day" id="calander_date_day"
                                        value="{{ date('Y-m-d', strtotime($appointment->start_at)) }}" required>
                                    <input type="hidden" name="calander_date_start" id="calander_date_start"
                                        value="{{ date('h:i a', strtotime($appointment->start_at)) }}">
                                    <input type="hidden" name="calander_date_end" id="calander_date_end"
                                        value="{{ date('h:i a', strtotime($appointment->end_at)) }}">

                                    @error('calander_date_day')
                                    <span class="error-msg-form text-center">
                                        <p>{{ $message }}</p>
                                    </span>
                                    @enderror
                                </div>

                            </div>


                        </div>

                        <div class="d-flex justify-content-end mt-3">
                            <input type="submit" class="next-form-steps btn btn-primary action-button-next"
                                value="Send" />
                        </div>
                    </div>
                </form>
            </div>

        </div>

    </div>
</div>

@endsection

<!-- js insert -->
@section('js')

<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
</script>

<!-- validate jquery -->
<script src="https://fastly.jsdelivr.net/npm/jquery-validation@1.19.3/dist/jquery.validate.min.js"
    type="text/javascript">
</script>
<script>
    //Rules for the Validator plugin
        var $validator = $('#myform').validate({

            //ignore: [], //to enable vlidation for hidden inputs
            //ignore: ['#calander_date_daya'],
            onkeyup: false,
            ignore: ":hidden:not(#calander_date_day)", //select for enable hidden input

            rules: {
                first_name: {
                    minlength: 3,
                    maxlength: 30,
                },
                second_name: {
                    minlength: 3,
                    maxlength: 60,
                },
                mother_name: {
                    minlength: 7,
                    maxlength: 60,
                },
                email: {
                    email: true,
                },
                password: {
                    minlength: 7,
                    maxlength: 100,
                },
                password_confirmation: {
                    minlength: 7,
                    maxlength: 100,
                    equalTo: '#password',
                },
                appointment_note: {
                    maxlength: 255,
                },
            },
            messages: {
                email: {
                    required: "We need your email address to contact you",
                    email: "Your email address must be in the format of name@domain.com"
                },
                password_confirmation: {
                    equalTo: "Password does not match",
                }
            },
            //for inserting erros for some inputs that makes posation problem such as selector 2 and bt datapicker
            errorPlacement: function(error, element) {
                switch (element.attr("name")) {
                    case 'role':
                        error.insertAfter($("#role-js-error-valid"));
                        break;
                    case 'first_branch_id':
                        error.insertAfter($("#first_branch_id-js-error-valid"));
                        break;

                    default:
                        error.insertAfter(element);
                }


            },
        });
</script>

<script>
    fetchServices_cat();

        function fetchServices_cat(specialty = $('#specialty_selc_form').val(), branch = $('#branches_selc_form').val()) {

            var url = "{{ route('sett.app_fetch_servicecat_ajax', [':date', ':date2']) }}";
            url = url.replace(':date', specialty).replace(':date2', branch);

            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $('#services').empty();
                    $.each(data, function(key, value) {
                        $('#services').append('<option value="' +
                            value.id + '" data-price="' + value.price + '" data-name="' + value
                            .name + '">' + value.name + ' - ' + value.price +
                            ' {{ __('basic.egp') }}</option>');
                    });
                }
            });
        }


        //for showing loading icon until the ajax is done
        $(document).ajaxStart(function() {
            $("#waiting, #waiting2").show();
        });

        $(document).ajaxStop(function() {
            $("#waiting, #waiting2").hide();
        });

        //insert passwrod depends on the username
        $('input[name="first_name"]').keyup(function(e) {
            e.preventDefault();

            first_name = $(this).val();
            new_password = 'prox' + first_name;
            $('input[name="password"]').val(new_password);
            $('input[name="password_confirmation"]').val(new_password);
        })


        fetchCity();

        //for country and cities ajax inputs
        function fetchCity(countryID = $('select[name="country_id"]').val()) {

            var url = "{{ route('sett.createcityajax', ':id') }}";
            url = url.replace(':id', countryID);

            if (countryID) {
                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('select[name="city_id"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="city_id"]').append('<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            } else {
                $('select[name="city_id"]').empty();
            }
        }

        $('select[name="country_id"]').on('change', function(e) {
            var country_id = $(this).val();
            fetchCity(country_id)
        });
</script>


<script>
    //--------------------- calander appointment ajax -------------------

        //default calander ajax
        $(document).ready(function() {

            fetchCalander();

            function fetchCalander(month = {{ date('m') }}, year = {{ date('Y') }}) {
                var specialty_selc = $('#specialty_selc_form').val();
                var branch_id = $('#branches_selc_form').val();
                var unit_id = $('#units_selc_form').val();

                console.log(unit_id);
                var url =
                    "{{ route('sett.appcalander_appointment_ajax', [':month', ':year', ':specialty_id', ':branch_id', ':unit_id']) }}";
                url = url.replace(':month', month).replace(':year', year).replace(':specialty_id', specialty_selc)
                    .replace(':branch_id', branch_id).replace(':unit_id', unit_id);

                $.ajax({
                    url: url,
                    type: "GET",
                    success: function(data) {
                        $("#calander_cont").html(data);
                    }
                });
            }

            //to get unit depnds on branch selected
            fetchUnit();

            function fetchUnit(branch = $('#branches_selc_form').val()) {

                var url = "{{ route('sett.app_fetch_unit_ajax', [':date']) }}";
                url = url.replace(':date', branch);

                $.ajax({
                    url: url,
                    type: "GET",
                    dataType: "json",
                    success: function(data) {
                        $('#units_selc_form').empty();
                        $.each(data, function(key, value) {

                            if (value.id == {{ $appointment->unit_id }}) {
                                var selected_unit = "selected";
                            } else {
                                var selected_unit = " ";
                            }

                            $('#units_selc_form').append('<option ' + selected_unit +
                                ' value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                        $('#units_selc_form').append(
                            '<option value="0"> Witing List</option>');
                        fetchCalander()
                    }
                });
            }



            //reinsert calander when specialty selector is changed (#specialty_selc_form)
            $(document).on('change', '#specialty_selc_form', function() {
                var specialty_id = $('#specialty_selc_form').val();
                var branch_id = $('#branches_selc_form').val();

                $('.calendar_datapicker_timeslots').hide();

                fetchServices_cat(specialty_id, branch_id);
                fetchCalander()
            });

            //reinsert calander when branch selector is changed (#branches_selc_form)
            $(document).on('change', '#branches_selc_form', function() {
                var specialty_id = $('#specialty_selc_form').val();
                var branch_id = $('#branches_selc_form').val();

                $('.calendar_datapicker_timeslots').hide();

                fetchUnit(branch_id)
                fetchServices_cat(specialty_id, branch_id);
                fetchCalander()
            });

            $(document).on('change', '#units_selc_form', function() {
                fetchCalander()
            });

            //reinsert the calander when the month arrows are clicked
            $(document).on('click', '#change_month', function() {
                var month = $(this).data('month');
                var year = $(this).data('year');
                fetchCalander(month, year)
            });
        });

        $(document).on('click', '.show_slots', function() {

            var today_date = $(this).data('timeslots');
            var specialty_selc = $('#specialty_selc_form').val();
            var branches_selc = $('#branches_selc_form').val();
            var unit_id = $('#units_selc_form').val();

            var show_slots_div = $(this).next('.calendar_datapicker_timeslots');

            var url =
                "{{ route('sett.appcalander_show_slots_ajax', [':datetoday', ':specialty_id', ':branch_id', ':unit_id']) }}";
            url = url.replace(':datetoday', today_date).replace(':specialty_id', specialty_selc)
                .replace(':branch_id', branches_selc).replace(':unit_id', unit_id);

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    show_slots_div.html(data);
                }
            });

            show_slots_div.hide();
            show_slots_div.show().css({
                    'opacity': 0,
                    'bottom': '-21%'
                })
                .animate({
                    'opacity': '1',
                    'bottom': '5px'
                }, 400);

        });


        $(document).on('click', '.click_day_calendar-close', function() {
            $('.calendar_datapicker_timeslots').hide();
        })


        // ----------------- timeslots -----------------
        //-- to show the available timeslots for given day
        //when (#available_day_ajax) is clicked in calander days, (data-timeslots attribute) will be taken which containing the give date
        //it will be send to timeslots.php to selecet the booked date from db then check the availability and excute timeslot fun
        $(document).on('click', '.available_day_ajax-selector', function() {
            //to reomove first classes booked and add booked to the selected day in calander
            $('.available_day_ajax_selected').removeClass('selected_day_calander');
            $('.calendar_booking_time_div').removeClass('selected_day_calander');
            $('.td_calander ').removeClass('selected_main_day_calander');
            $(this).parent().parent().parent().parent().closest('div').addClass("selected_main_day_calander")
        });

        $(document).ready(function() {

            $(document).on('mouseover click', '.available_day_ajax-selector', function() {

                if ($("a.firstClick").length > 0 && $("a.secondClick").length > 0) {
                    if (event.type === "click") {
                        $('.available_day_ajax-selector').removeClass("selected_day_calander");
                        $('.available_day_ajax-selector').removeClass("reserved");
                        $('.available_day_ajax-selector').removeClass("firstClick");
                        $('.available_day_ajax-selector').removeClass("secondClick");
                    }
                }

                if ($("a.firstClick").length > 0 && $("a.secondClick").length == 0) {
                    if (event.type === "mouseover") {
                        $('.available_day_ajax-selector').removeClass("selected_day_calander");
                        var tds = $('a.available_day_ajax-selector');
                        var firstClick = $(".firstClick");
                        var firstClickIndex = tds.index(firstClick);
                        var currentIndex = tds.index(this);

                        tds.filter(function() {
                            var idx = tds.index(this);
                            return idx >= firstClickIndex && idx <= currentIndex;
                        }).addClass("selected_day_calander")

                    }
                    if (event.type === "click") {
                        $(this).addClass("secondClick");
                        $('.selected_day_calander').addClass('reserved');

                        $end = $(this).data("end");
                        $('#calander_date_end').val($end);
                    }
                } else {
                    if (event.type === "click") {
                        $(this).addClass("firstClick");

                        $day = $(this).data("day");
                        $start = $(this).data("start");
                        $('#calander_date_day').val($day);
                        $('#calander_date_start').val($start);
                        $('#calander_date_end').val('');
                    }
                }

            });

        });
</script>

@endsection