<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Treatment extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'treatment_cat_id',
        'appointment_id',
        'patient_id',
        'sessions',
        'sessions_done',
        'start',
        'end',
        'status',
    ];

    public function treatment_cat()
    {
        return $this->belongsTo(Treatment_cat::class, 'treatment_cat_id', 'id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }


    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

}