<?php

namespace App\Models\Patient;

use App\Models\Branch\Branch;
use App\Models\Invoice\Service_cost_material;
use App\Models\Patient\Dental\Dent_main_cat;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Patient\Specialty_cat;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service_item extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = [
        'id',
        'specialty_id',
        'branch_id',
        'service_inv_cat_id',
        'dent_main_cat_id',
        'name',
        'price',
        'pulses',
        'package',
        'package_items_number', //number of the session will be taken in package
        'doctor_comm',
    ];

    public $timestamps = false;

    public function specialty()
    {
        return $this->belongsTo(Specialty_cat::class, 'specialty_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function service_inv_cat()
    {
        return $this->belongsTo(Service_inv_cat::class, 'service_inv_cat_id', 'id');
    }

    public function dent_main_cat()
    {
        return $this->belongsTo(Dent_main_cat::class, 'dent_main_cat_id', 'id');
    }

    public function service_item(){
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }

    public function costs()
    {
        return $this->hasMany(Service_cost_material::class, 'service_item_id', 'id')->where('type','=', 1);
    }

    public function materials()
    {
        return $this->hasMany(Service_cost_material::class, 'service_item_id', 'id')->where('type','=', 2);
    }
}
