<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prescription extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'code',
        'appointment_id',
        'patient_id',
        'date',
        'note',
        'patient_id',
    ];


    public function medicines()
    {
        return $this->hasMany(Medicine::class, 'prescription_id', 'id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }


    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }
}