<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Lab;
use App\Models\Branch\Operation;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Patient_wallet;
use App\Models\location\City;
use App\Models\location\Country;
use App\Models\Patient\Dental\Pat_bs_den_chart;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Patient extends Authenticatable
{
    use HasFactory;

    protected $fillable = [
        'id',
        'type',
        'recommendation', //(1- Normal, 2- recommended, 3- not recommended)
        'wallet',
        'balance',
        'ask_for_main_id',
        'ask_for_id',
        'new_id',
        'new_branch_id',
        'code',
        'email',
        'password',
        'first_branch_id',
        'first_name',
        'second_name',
        'mother_name',
        'avatar',
        'birthday',
        'gendar',
        'blood_type',
        'height',
        'weight',
        'heart_rate',
        'bl_pressure',
        'country_id',
        'city_id',
        'phone_number',
        'sec_phone_number',
        'insurance',
        'from_recourse_id',
        'note',
        'creator_id',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'first_branch_id', 'id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id', 'id');
    }

    public function recourse()
    {
        return $this->belongsTo(From_recourse::class, 'from_recourse_id', 'id');
    }

    public function ask_for_main()
    {
        return $this->belongsTo(Ask_for_main_cat::class, 'ask_for_main_id', 'id');
    }

    public function ask_for()
    {
        return $this->belongsTo(Ask_for_cat::class, 'ask_for_id', 'id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'creator_id', 'id');
    }

    // ------------- one to many relations -------------


    public function lead_notes()
    {
        return $this->hasMany(Lead_pat_note::class, 'patient_id', 'id');
    }

    public function appointments()
    {
        return $this->hasMany(Appointment::class, 'patient_id', 'id');
    }

    public function diseases()
    {
        return $this->hasMany(Disease::class, 'patient_id', 'id');
    }


    public function disease_draws()
    {
        return $this->hasMany(Disease_draw::class, 'patient_id', 'id');
    }

    public function examinations()
    {
        return $this->hasMany(Pat_examination::class, 'patient_id', 'id');
    }

    public function eyeglasses()
    {
        return $this->hasMany(Eyeglasses_prescription::class, 'patient_id', 'id');
    }

    public function all_investigation()
    {
        return $this->hasMany(Pat_investigation::class, 'patient_id', 'id');
    }

    public function investigation()
    {
        return $this->hasMany(Pat_investigation::class, 'patient_id', 'id')->where('cat', 1);
    }

    public function investigation_lab()
    {
        return $this->hasMany(Pat_investigation::class, 'patient_id', 'id')->where('cat', 2);
    }


    public function treatments()
    {
        return $this->hasMany(Treatment::class, 'patient_id', 'id');
    }

    public function sessions()
    {
        return $this->hasMany(Session_pat::class, 'patient_id', 'id');
    }

    public function dental_basic_chart()
    {
        return $this->hasMany(Pat_bs_den_chart::class, 'patient_id', 'id');
    }

    public function pulses()
    {
        return $this->hasMany(Pulse::class, 'patient_id', 'id');
    }

    public function package()
    {
        return $this->hasMany(Service_package::class, 'patient_id', 'id');
    }

    public function prescriptions()
    {
        return $this->hasMany(Prescription::class, 'patient_id', 'id');
    }

    public function labs()
    {
        return $this->hasMany(Lab::class, 'patient_id', 'id');
    }

    public function operations()
    {
        return $this->hasMany(Operation::class, 'patient_id', 'id');
    }

    public function wallet_reco()
    {
        return $this->hasMany(Patient_wallet::class, 'patient_id', 'id');
    }


    public function attachments()
    {
        return $this->hasMany(Patient_img::class, 'patient_id', 'id');
    }

    public function invoices()
    {
        return $this->morphMany(Invoice::class, 'receivable');
    }

    // --------------------


    public function age()
    {
        return Carbon::parse($this->attributes['birthday'])->age;
    }
}
