<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pat_investigation extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'cat', //1- radiology, 2- lab
        'type', //1- body,2-tagmel,3-ramad
        'appointment_id',
        'patient_id',
        'date',
        'note',
    ];


    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function items()
    {
        return $this->hasMany(Pat_investigation_item::class, 'pat_investigation_id', 'id');
    }
}
