<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Disease_draw extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'type',
        'pat_examination_id',
        'calendable_id',
        'calendable_type',
        'patient_id',
        'front',
        'back',
        'face',
        'teeth',
        'note',
    ];

    public $timestamps = false;


    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'calendable_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function calendable()
    {
        return $this->morphTo();
    }
}
