<?php

namespace App\Models\Patient\Dental;

use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pat_bs_den_chart extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'patient_id',
        'doctor_id',
        'dent_main_cat_id',
        'services_cat_id',
        'tooth',
        'surface',
        'created_at',
        'updated_at',
    ];
    
    public function dent_main_cat()
    {
        return $this->belongsTo(Dent_main_cat::class, 'dent_main_cat_id', 'id');
    }

    public function service_item(){
        return $this->belongsTo(Service_item::class, 'services_cat_id', 'id');
    }
    
    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }
    
    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id', 'id');
    }

    
}