<?php

namespace App\Models\Invoice;

use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Invoice\cost\Cost_cat;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service_cost_material extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'type', //1- cost, 2- material
        'service_item_id', 
        'inventory_id',
        'cost_cat_id',
        'qty',
        'price',
    ];

    public $timestamps = false;

    public function service()
    {
        return $this->belongsTo(Service_item::class, 'service_item_id', 'id');
    }

    public function inventory()
    {
        return $this->belongsTo(Inventory_item::class, 'inventory_id', 'id');
    }

    public function cost()
    {
        return $this->belongsTo(Cost_cat::class, 'cost_cat_id', 'id');
    }
}