<?php

namespace App\Models\Invoice;

use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice_material extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'invoice_id',
        'invoice_item_id',
        'inventory_id',
        'qty',
        'price',
    ];

    public $timestamps = false;

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id');
    }

    public function invoice_item()
    {
        return $this->belongsTo(Invoice_item::class, 'invoice_item_id', 'id');
    }

    public function inventory()
    {
        return $this->belongsTo(Inventory_item::class, 'inventory_id', 'id');
    }

}