<?php

namespace App\Models\Invoice;

use App\Models\Branch\Branch;
use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'code',
        'type', // (income = 0, expenses = 1)
        'status', //(not paid = 0, installment or deposit =1 ,paid = 2, 3= refund)
        'operation', //not operation = 0, operation = 1
        'target', //1-old, 2-new page, 3-new friend, 4- offer, 5-upgrade, 6-other, 7-other_2
        'service_inv_cat_id',
        'specialty_id',
        'branch_id',
        'receivable_id',
        'receivable_type',
        'items_price',
        'coupon_id',
        'discount',
        'final_price',
        'total_paid',
        'tax',
        'total_cost',
        'note',
        'paid_date',
        'refund_id',
        'attached_pic',
    ];

    /*
        -------------- Relationships --------------
     */

    public function service_inv_cat()
    {
        return $this->belongsTo(Service_inv_cat::class, 'service_inv_cat_id', 'id');
    }

    public function specialty()
    {
        return $this->belongsTo(Specialty_cat::class, 'specialty_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }


    public function coupon()
    {
        return $this->belongsTo(Coupon::class, 'coupon_id', 'id');
    }

    public function receivable()
    {
        return $this->morphTo();
    }

    public function invoice_items()
    {
        return $this->hasMany(Invoice_item::class);
    }

    public function costs()
    {
        return $this->hasMany(Invoice_cost_material::class, 'invoice_id', 'id')->where('type', '=', 1);
    }

    public function materials()
    {
        return $this->hasMany(Invoice_cost_material::class, 'invoice_id', 'id')->where('type', '=', 2);
    }

    public function worker()
    {
        return $this->belongsTo(User::class, 'responsible_worker', 'id');
    }

    public function payment()
    {
        return $this->hasMany(Payment::class, 'invoice_id', 'id');
    }

    public function getSumPaymentAttribute()
    {
        return $this->payment()->where('type', '!=', 2)->sum('amount');
    }

    public function getTaxPercentageAttribute()
    {


        return $this->tax;
    }
}
