<?php

namespace App\Models\Invoice;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Coupon extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'code',
        'type',
        'value',
        'percent_off',
        'status', //(deactivateed = 0 and active = 1)
    ];
    
    public function findBycode($code)
    {
        return self::where('code', $code)->first();
    }


    public function discount($total)
    {
        if ($this->type == 'fixed') {
            return $this->value;
        }
        elseif ($this->type == 'percent') {
            return ($this->percent_off / 100) * $total;
        }
        else{
            return 0;
        }
    }


}