<?php

namespace App\Models\Branch;

use App\Models\Patient\Patient;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Op_follow_up extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'op_id',
        'patient_id',
        'responsible_id',
        'short_term_responsible_id',
        'day_1',
        'day_3',
        'day_5',
        'long_term_responsible_id',
        'week_1',
        'week_2',
        'month_1',
        'month_2',
        'month_3',
        'month_6',
        'note',
    ];
    
    public $timestamps = false;

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function opration()
    {
        return $this->belongsTo(Operation::class, 'op_id', 'id');
    }
    
    public function doctor()
    {
        return $this->belongsTo(User::class, 'responsible_id', 'id');
    }

    public function doctor_short()
    {
        return $this->belongsTo(User::class, 'short_term_responsible_id', 'id');
    }

    public function doctor_long()
    {
        return $this->belongsTo(Patient::class, 'long_term_responsible_id', 'id');
    }
}