<?php

namespace App\Models\Branch\Inventory;

use App\Models\Branch\Branch;
use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Specialty_cat;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Inventory_item extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'id',
        'code',
        'service_inv_cat_id',
        'specialty_id',
        'branch_id',
        'name',
        'price',
        'place',
        'current_quantity',
        'quantity_notify',
    ];

    public $timestamps = false;

    public function specialty()
    {
        return $this->belongsTo(Specialty_cat::class, 'specialty_id', 'id');
    }

    public function service_inv_cat()
    {
        return $this->belongsTo(Service_inv_cat::class, 'service_inv_cat_id', 'id');
    }

    public function records()
    {
        return $this->hasMany(Inventory_item_record::class, 'item_id', 'id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

}
