<?php

namespace App\Http\Controllers;

use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\location\Country;
use App\Models\Patient\From_recourse;
use App\Models\Patient\Medicine;
use App\Models\Patient\Patient;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Mpdf\Mpdf;
use Mpdf\Tag\Input;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
use Image;
use DNS1D;
use DNS2D;


class PublicController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    //print 

    public function patient_print_pre($id, $prescription_id = null)
    {

        if ($prescription_id) {
            $patient = Patient::with(['prescriptions' => function ($q) use ($prescription_id) {
                $q->where('code', $prescription_id)
                    ->with('medicines');
            }])
                ->where('code', $id)
                ->first();
        } else {
            $patient = Patient::with(['prescriptions' => function ($q) {
                $q->orderBy('id', 'desc')
                    ->with('medicines')
                    ->first();
            }])
                ->where('code', $id)
                ->first();
        }

        if (!$patient) {
            return abort(404);
        }

        $booking_url = route('pat_patient_print_pre', $id);
        $qrcode = base64_encode(QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($booking_url));

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        // instantiate and use the dompdf class

        $html = view('patient.print_pre', compact('patient', 'qrcode', 'booking_url'))->render();

        $mpdf = new mPDF();

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
        <img src="data:image/png;base64,' . DNS2D::getBarcodePNG($booking_url, 'QRCODE') . '" height="80"
        width="80" />
            <p class="mt-1 mb-0 text-s fw-bold2">النسخة الالكترونية</p>
        </div>
        </div>
        </div>
        ', 'O');


        if ($patient->new_id) {
            $new_id = explode('-', $patient->new_id);
            $new_id = $new_id[1];
        } else {
            $new_id = 0;
        }

        $mpdf->SetHTMLFooter('
        <div><img src="data:image/png;base64,' . DNS1D::getBarcodePNG($new_id, 'C39') . '" height="70"width="70" /><br /></div>
        <div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();
    }

    public function patient_print_pre_no_frame($id, $prescription_id = null)
    {

        if ($prescription_id) {
            $patient = Patient::with(['prescriptions' => function ($q) use ($prescription_id) {
                $q->where('code', $prescription_id)
                    ->with('medicines');
            }])
                ->where('code', $id)
                ->first();
        } else {
            $patient = Patient::with(['prescriptions' => function ($q) {
                $q->orderBy('id', 'desc')
                    ->with('medicines')
                    ->first();
            }])
                ->where('code', $id)
                ->first();
        }

        if (!$patient) {
            return abort(404);
        }

        $booking_url = route('pat_patient_print_pre', $id);
        $qrcode = base64_encode(QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($booking_url));

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        // instantiate and use the dompdf class

        $html = view('patient.print_pre', compact('patient', 'qrcode', 'booking_url'))->render();

        $mpdf = new mPDF([
            'mode' => 'utf-8',
            //'format' => 'A4-L' //'format' => [190, 236]
            'format' => 'A5',
        ]);


        if ($patient->new_id) {
            $new_id = explode('-', $patient->new_id);
            $new_id = $new_id[1];
        } else {
            $new_id = 0;
        }

        $mpdf->SetHTMLFooter('
        <div><img src="data:image/png;base64,' . DNS1D::getBarcodePNG($new_id, 'C39') . '" height="70"width="70" /><br /></div>
        <div class"text-center" style="padding-bottom: 4rem;"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 40,
            'margin-left' => 10,
            'margin-right' => 10,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();
    }

    //print
    public function eyeglasses_prescription_print($id, $eye_glass_id = null)
    {

        if ($eye_glass_id) {
            $patient = Patient::with(['eyeglasses' => function ($q) use ($eye_glass_id) {
                $q->where('code', $eye_glass_id);
            }])
                ->where('code', $id)
                ->first();
        } else {
            $patient = Patient::with(['eyeglasses' => function ($q) {
                $q->orderBy('id', 'desc')->first();
            }])
                ->where('code', $id)
                ->first();
        }

        if (!$patient) {
            return abort(404);
        }

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');


        $booking_url = route('eyeglasses_prescription_print', $id);
        $qrcode = base64_encode(QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($booking_url));

        // instantiate and use the dompdf class

        $html = view('patient.print_eyeglasses_prescription', compact('patient', 'qrcode', 'booking_url'))->render();

        $mpdf = new mPDF();

        $mpdf->SetHTMLHeader('<div class="header">
        <div class="row">
        <div class="col-xs-9 m-0 ps-3">
            <img src="' . $logo . '">
        </div>
        <div class="col-xs-2 text-center m-0 ps-3">
            <img src="data:image/svg;base64,' . $qrcode . '">
            <p class="mt-1 mb-0 text-s fw-bold2">' . $patient->code . '</p>
        </div>
        </div>
        </div>
        ', 'O');


        if ($patient->new_id) {
            $new_id = explode('-', $patient->new_id);
            $new_id = $new_id[1];
        } else {
            $new_id = 0;
        }

        $mpdf->SetHTMLFooter('
        <div><img src="data:image/png;base64,' . DNS1D::getBarcodePNG($new_id, 'C39') . '" height="70"width="70" /><br /></div>
        <div class"text-center" style="padding-bottom: 4rem;"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 17,
        ]);
        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }


    //print with no frame
    public function eyeglasses_presc_print_no_frame($id, $eye_glass_id = null)
    {

        if ($eye_glass_id) {
            $patient = Patient::with(['eyeglasses' => function ($q) use ($eye_glass_id) {
                $q->where('code', $eye_glass_id);
            }])
                ->where('code', $id)
                ->first();
        } else {
            $patient = Patient::with(['eyeglasses' => function ($q) {
                $q->orderBy('id', 'desc')->first();
            }])
                ->where('code', $id)
                ->first();
        }

        if (!$patient) {
            return abort(404);
        }

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        $booking_url = route('eyeglasses_prescription_print', $id);
        $qrcode = base64_encode(QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($booking_url));

        // instantiate and use the dompdf class

        $html = view('patient.print_eyeglasses_prescription', compact('patient', 'qrcode', 'booking_url'))->render();

        $mpdf = new mPDF([
            'mode' => 'utf-8',
            //'format' => 'A4-L' //'format' => [190, 236]
            'format' => 'A4',
        ]);

        if ($patient->new_id) {
            $new_id = explode('-', $patient->new_id);
            $new_id = $new_id[1];
        } else {
            $new_id = 0;
        }

        $mpdf->SetHTMLFooter('
        <div><img src="data:image/png;base64,' . DNS1D::getBarcodePNG($new_id, 'C39') . '" height="70"width="70" /><br /></div>
        <div class"text-center"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 43,
            'margin-bottom' => 40,
            'margin-left' => 10,
            'margin-right' => 10,
        ]);

        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }



    //print with no frame
    public function eyeglasses_presc_print_no_frame_a5($id, $eye_glass_id = null)
    {

        if ($eye_glass_id) {
            $patient = Patient::with(['eyeglasses' => function ($q) use ($eye_glass_id) {
                $q->where('code', $eye_glass_id);
            }])
                ->where('code', $id)
                ->first();
        } else {
            $patient = Patient::with(['eyeglasses' => function ($q) {
                $q->orderBy('id', 'desc')->first();
            }])
                ->where('code', $id)
                ->first();
        }

        if (!$patient) {
            return abort(404);
        }

        $logo = public_path('img/dashboard/system/') . prox_sett('logo');

        $booking_url = route('eyeglasses_prescription_print', $id);
        $qrcode = base64_encode(QrCode::color(68, 95, 129)->size(80)->style('round')->eye('circle')->generate($booking_url));

        // instantiate and use the dompdf class

        $html = view('patient.print_eyeglasses_prescription', compact('patient', 'qrcode', 'booking_url'))->render();

        $mpdf = new mPDF([
            'mode' => 'utf-8',
            //'format' => 'A4-L' //'format' => [190, 236]
            'format' => 'A5',
        ]);


        if ($patient->new_id) {
            $new_id = explode('-', $patient->new_id);
            $new_id = $new_id[1];
        } else {
            $new_id = 0;
        }

        $mpdf->SetHTMLFooter('
        <div><img src="data:image/png;base64,' . DNS1D::getBarcodePNG($new_id, 'C39') . '" height="70"width="70" /><br /></div>
        <div class"text-center" style="padding-bottom: 4rem;"> Page {PAGENO} <span class="text-s">Copyright © 2021 Proxima</span> | {DATE j-m-Y}</div>');

        $mpdf->AddPageByArray([
            'margin-top' => 38,
            'margin-bottom' => 40,
            'margin-left' => 8,
            'margin-right' => 8,
        ]);

        $mpdf->WriteHTML($html);
        $mpdf->output();

        // Output the generated PDF to Browser
        //return $mpdf->stream();

    }
}
