<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Branch\Appointment;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_cost_material;
use App\Models\Invoice\Invoice_item;
use App\Models\Invoice\Invoice_material;
use App\Models\Invoice\Patient_wallet;
use App\Models\Patient\Medicine;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use App\Models\Patient\Session_pat;
use App\Models\Patient\Treatment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class SessionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'session_cat_service' => ['required', 'exists:service_items,id'],
            'session_status' => ['required', Rule::in(['0', '1'])],
            'related_treatment_id' => ['nullable', 'exists:treatments,id'],
            'last_appointment_id' => ['required', 'exists:appointments,id'],
            'patient_id' => ['required', 'exists:patients,id'],
            'session_date' => ['required'],
        ]);

        //sessions
        $session_cat_service_id = $request->input('session_cat_service');
        $related_treatment_id = $request->input('related_treatment_id');
        $appo_branch = Appointment::select('branch_id')->find($request->input('last_appointment_id'));

        //if the session is not done (new), create session with invoice
        if ($request->input('session_status') == 0) {

            if ($request->input('session_cat_invoice') === 'new') {
                $service_inv_cat = Service_item::where('id', $session_cat_service_id[0])->where('deactivate', 0)->first();

                $invoice = Invoice::create([
                    'code' => "IN" . $this->generateRandomString(6),
                    'service_inv_cat_id' => $service_inv_cat->service_inv_cat_id,
                    'specialty_id' => Auth::user()->specialty_id,
                    'receivable_id' => $request->input('patient_id'),
                    'receivable_type' => "App\Models\Patient\Patient",
                    'branch_id' => $appo_branch->branch_id,
                    'items_price' => 0,
                    'final_price' => 0,
                ]);
                $invoice_id = $invoice->id;
            } else {
                $invoice_id = $request->input('session_cat_invoice');
            }

            $final_price = 0;
            $total_cost = 0;

            foreach ($session_cat_service_id as $item) {

                $service_price = Service_item::select('id', 'price', 'service_inv_cat_id', 'doctor_comm')->where('id', $item)
                    ->where('deactivate', 0)->first();

                $doctor_comm = $service_price->doctor_comm / 100 * $service_price->price;

                //create sessions for patient
                $session = Session_pat::create([
                    'services_cat_id' => $item,
                    'appointment_id' => $request->input('last_appointment_id'),
                    'doctor_id' => $request->input('doc_session'),
                    'patient_id' => $request->input('patient_id'),
                    'treatment_id' => $related_treatment_id,
                    'status' => 0,
                    'date' => $request->input('session_date'),
                ]);

                if ($request->input('session_cat_invoice') !== 'wallet') {
                    $invoice_item = Invoice_item::create([
                        'invoice_id' => $invoice_id,
                        'itemable_id' => $session->id,
                        'itemable_type' => "App\Models\Patient\Session_pat",
                        'categorizable_id' => $item,
                        'categorizable_type' => "App\Models\Patient\Service_item",
                        'price' => $service_price->price,
                        'sold_price' => $service_price->price,
                        'doctor_id' => $request->input('doc_session'),
                        'doctor_comm' => $doctor_comm,
                    ]);
                }

                $final_price += $service_price->price;
                $total_cost += $doctor_comm;

                if (!empty($related_treatment_id)) {
                    $treatment_update = Treatment::find($related_treatment_id);
                    $treatment_update->sessions_done = +1;
                    $treatment_update->save();
                }

                if ($request->input('session_cat_invoice') === 'wallet') {
                    $patient = Patient::select('wallet')->find($request->input('patient_id'));
                    $wallet_reco = Patient_wallet::create([
                        'type' => 1,
                        'branch_id' => $appo_branch->branch_id,
                        'patient_id' => $request->input('patient_id'),
                        'service_item_id' => $item,
                        'balance_before_tran' =>  $patient->wallet,
                        'amount' => $service_price->price,
                        'date' => $request->input('session_date'),
                        'note' => $request->input('invoice_note'),
                    ]);
                }

                //for insert costs to invoice
                if (count($service_price->costs) > 0) {

                    foreach ($service_price->costs as $item) {
                        $invoice_cost = Invoice_cost_material::create([
                            'type' => 1,
                            'invoice_id' => $invoice_id,
                            'invoice_item_id' => $invoice_item->id,
                            'cost_cat_id' => $item->cost_cat_id,
                            'price' => $item->price,
                        ]);

                        $total_cost += $item->price;
                    }
                }

                //for insert materials to invoice
                if (count($service_price->materials) > 0) {

                    foreach ($service_price->materials as $item) {
                        $inventory = Inventory_item::select('price')->find($item->inventory_id);
                        $inventory_price = $item->qty * $inventory->price;
                        $invoice_material = Invoice_cost_material::create([
                            'type' => 2,
                            'invoice_id' => $invoice_id,
                            'invoice_item_id' => $invoice_item->id,
                            'inventory_id' => $item->inventory_id,
                            'qty' => $item->qty,
                            'price' => $inventory->price,
                        ]);

                        $total_cost += $inventory_price;
                    }
                }
            }

            if ($request->input('session_cat_invoice') === 'wallet') {
                $wallet = Patient::find($request->input('patient_id'));
                $wallet->decrement('wallet', $final_price);
                $wallet->save();
            }

            if ($request->input('session_cat_invoice') !== 'wallet') {
                //update invoice after inserting its items and fetch total price
                if ($request->input('session_cat_invoice') === 'new') {
                    $invoice = Invoice::find($invoice_id);
                    $invoice->items_price = $final_price;
                    $invoice->final_price = $final_price;
                    $invoice->total_cost = $total_cost;
                    $invoice->discount = null;
                    $invoice->note = $request->input('invoice_note');
                    $invoice->save();
                } else {
                    $invoice = Invoice::find($invoice_id);
                    $invoice->increment('items_price', $final_price);
                    $invoice->increment('final_price', $final_price);
                    $invoice->increment('total_cost', $total_cost);
                    $invoice->note = $invoice->note . ' ' . $request->input('invoice_note');
                    $invoice->save();
                }
            }
        }
        //for old sessions
        else {
            foreach ($session_cat_service_id as $item) {
                //create sessions for patient
                $session = Session_pat::create([
                    'services_cat_id' => $item,
                    'appointment_id' => $request->input('last_appointment_id'),
                    'doc_session' => $request->input('doc_session'),
                    'patient_id' => $request->input('patient_id'),
                    'treatment_id' => $related_treatment_id,
                    'status' => 0,
                    'date' => $request->input('session_date'),
                ]);

                if (!empty($related_treatment_id)) {
                    $treatment_update = Treatment::find($related_treatment_id);
                    $treatment_update->sessions_done = +1;
                    $treatment_update->save();
                }
            }
        }

        //if the session not done
        if ($request->input('session_status') !== '1') {
        }

        session()->flash('success', 'The session has been created successfully');
        return redirect()->back();
    }

    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'session_id_update' => ['required', 'exists:session_pats,id'],
            'status_session_update' => ['required'],
            'related_treatment_id_update' => ['required', 'exists:treatments,id'],
        ]);


        $session = Session_pat::find($request->input('session_id_update'));

        $session->treatment_id = $request->input('related_treatment_id_update');
        $session->status = $request->input('status_session_update');

        $session->save();

        session()->flash('success', 'The session has been updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('session_id_delete');

        $session = Session_pat::with(['invoice_item' => function ($q) {
            $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type',)
                ->with(['invoice' => function ($q) {
                    $q->select('id', 'status');
                }]);
        }])
            ->find($id);

        $invoice_items = Invoice_item::where('invoice_id', $session->invoice_item->invoice->id)->count();

        if ($session->status == 0) {
            Session_pat::find($id)->delete();
        } else {
            //if there is only session in the invoice (no other items)
            if ($invoice_items == 1) {
                if (!empty($status)) {
                    Invoice_item::find($status->invoice_item->id)->delete();
                    Invoice::find($status->invoice_item->invoice->id)->delete();
                    Session_pat::find($id)->delete();
                    session()->flash('success', 'The session has been deleted');
                    return redirect()->back();
                } else {
                    session()->flash('error_delete', 'The session can not before, it is paid');
                    return redirect()->back();
                }
            } else {
                session()->flash('error_delete', 'there are other items in invoice');
                return redirect()->back();
            }
        }

        session()->flash('success', 'The session has been deleted');
        return redirect()->back();
    }
}
