<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Branch\Branch;
use App\Models\Patient\Pulses_machine as PatientPulses_machine;
use Illuminate\Http\Request;

class Pulses_machine extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $item = PatientPulses_machine::
            with(['branch' => function ($q) {
            $q->select('id', 'name');}])
        ->get();
        return view('cats/pulses_machine.index', compact('item'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $branch = Branch::all();

        return view('cats/pulses_machine.create', compact('branch'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'branch_id' => 'required|exists:branches,id',
            'name' => 'required|unique:pulses_machines,name',
        ]);
        
        $item = PatientPulses_machine::create([  
            'branch_id' => $request->input('branch_id'),
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.pulses_machine.index')
            ->with('success', 'The item has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $item = PatientPulses_machine::find($id);
        return view('cats/pulses_machine.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $pulses = PatientPulses_machine::find($id);
        $pulses->name = $request->input('name');
        $pulses->save();

        return redirect()->route('sett.pulses_machine.index')
            ->with('success', 'Item has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}