<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\Dental\Dent_main_cat as DentalDent_main_cat;
use App\Models\Patient\Treatment_cat as PatientTreatment_cat;
use Illuminate\Http\Request;

class Dent_main_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $items = DentalDent_main_cat::all();
        return view('cats/dentmaincat.index', compact('items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/dentmaincat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:dent_main_cats,name',
        ]);
        
        $treatment = DentalDent_main_cat::create([  
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.dentmaincat.index')
            ->with('success', 'Treatment has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $item = DentalDent_main_cat::find($id);
        return view('cats/dentmaincat.edit', compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $treatment = DentalDent_main_cat::find($id);
        $treatment->name = $request->input('name');
        $treatment->save();

        return redirect()->route('sett.dentmaincat.index')
            ->with('success', 'The item has updated successfully');
            
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}