<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\Ask_for_cat as PatientAsk_for_cat;
use App\Models\Patient\Cancel_reason_cat;
use Illuminate\Http\Request;

class Cancel_reason extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $cancel_reason = Cancel_reason_cat::all();
        return view('cats/cancelreasoncat.index', compact('cancel_reason'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/cancelreasoncat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:cancel_reason_cats,name',
        ]);
        
        $cancel_reason = Cancel_reason_cat::create([  
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.cancelreasoncat.index')
            ->with('success', 'The item has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $cancel_reason = Cancel_reason_cat::find($id);
        return view('cats/cancelreasoncat.edit', compact('cancel_reason'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $cancel_reason = Cancel_reason_cat::find($id);
        $cancel_reason->name = $request->input('name');
        $cancel_reason->save();

        return redirect()->route('sett.cancelreasoncat.index')
            ->with('success', 'Item has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}