<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\Ask_for_main_cat as PatientAsk_for_main_cat;
use Illuminate\Http\Request;

class Ask_for_main_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        $askfor = PatientAsk_for_main_cat::get();
        return view('cats/askformaincat.index', compact('askfor'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/askformaincat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:ask_for_cats,name',
        ]);
        
        $examination = PatientAsk_for_main_cat::create([  
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.askformaincat.index')
            ->with('success', 'The item has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $askfor = PatientAsk_for_main_cat::find($id);
        return view('cats/askformaincat.edit', compact('askfor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $askfor = PatientAsk_for_main_cat::find($id);
        $askfor->name = $request->input('name');
        $askfor->save();

        return redirect()->route('sett.askformaincat.index')
            ->with('success', 'Item has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}