<?php

namespace App\Http\Controllers\Patient\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\Ask_for_cat as PatientAsk_for_cat;
use App\Models\Patient\Ask_for_main_cat;
use Illuminate\Http\Request;

class Ask_for_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $askfor = PatientAsk_for_cat::with(['ask_for_main_cat' => function ($q) {
            $q->select('id','name');}])
        ->get();

        return view('cats/askforcat.index', compact('askfor'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $main_cat = Ask_for_main_cat::all();
        return view('cats/askforcat.create', compact('main_cat'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'ask_for_main_cat_id' => 'required|exists:ask_for_main_cats,id',
            'name' => 'required|unique:ask_for_cats,name',
        ]);
        
        $examination = PatientAsk_for_cat::create([  
            'ask_for_main_cat_id' => $request->input('ask_for_main_cat_id'),
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.askforcat.index')
            ->with('success', 'The item has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){

        $askfor = PatientAsk_for_cat::find($id);
        $main_cat = Ask_for_main_cat::all();

        return view('cats/askforcat.edit', compact('askfor', 'main_cat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'ask_for_main_cat_id' => 'required|exists:ask_for_main_cats,id',
            'name' => 'required',
        ]);

        $askfor = PatientAsk_for_cat::find($id);
        $askfor->ask_for_main_cat_id = $request->input('ask_for_main_cat_id');
        $askfor->name = $request->input('name');
        $askfor->save();

        return redirect()->route('sett.askforcat.index')
            ->with('success', 'Item has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}