<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\Http\Requests\PatientRequest;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Op_during;
use App\Models\Branch\Op_follow_up;
use App\Models\Branch\Op_img;
use App\Models\Branch\Oper_placecat;
use App\Models\Branch\Operation;
use App\Models\Invoice\Coupon;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_item;
use App\Models\location\City;
use App\Models\location\Country;
use App\Models\Patient\From_recourse;
use App\Models\Patient\Patient;
use App\Models\Patient\Service_item;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use Carbon\Carbon;
use DateInterval;
use DateTime;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use Illuminate\Validation\Rule;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\File;
use Image;

class OperationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $specialties = Specialty_cat::all();
        $oper_place = Oper_placecat::select('id', 'name')->get();

        return view('branch/operation.index', compact('specialties', 'oper_place'));
    }


    //week calender
    public function weekly_calender($yearin, $weekin)
    {

        $dt = new DateTime();

        if (request()->yearin == 'null' && request()->weekin == 'null') {
            $year = $dt->format('o');
            $week = $dt->format('W');
        } else {
            $year = $yearin;
            $week = $weekin;
        }

        return weeklyCalendar($year, $week);
    }


    //time slots
    public function weekly_calender_date_operation($year, $month, $day, $specialty, $branch, $order)
    {

        $year = request()->year;
        $month = request()->month;
        $day = request()->day;
        $branch = request()->branch;
        $order = request()->order;

        $current_day = $year . '-' . $month . '-' . $day;

        $result = '';

        //time slots
        $result .= '<div id="fetch-date-calendar-branch" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" data-day_name="' . date('l', strtotime($current_day)) . '" >';

        $appointment = Operation::select('id', 'patient_id', 'status', 'services_cat_id', 'start_at')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->orderBy('start_at', 'ASC');

        if ($specialty !== 'all') {
            $appointment = $appointment->Where('specialty_id', $specialty);
        }

        if ($branch !== 'all') {
            $appointment = $appointment->Where('oper_place_id', $branch);
        }

        if ($order == 'date') {
            $appointment = $appointment->whereDate('start_at', $current_day);
            $appointment = $appointment->where('status', '!=', 0);
        } else {
            $appointment = $appointment->whereDate('start_at', $current_day);
            $appointment = $appointment->where('status', 0);
        }

        $appointment = $appointment->get();



        //appointments
        if (count($appointment) > 0) {

            foreach ($appointment as $item) {

                $result .= '<div class="row">';

                //slots
                $result .= '<div class="col-12 col-lg-2 align-self-center">';
                $result .= '<p class="text-xs text-gray-300">' . date('h:i A', strtotime($item->start_at)) . '</p>';
                $result .= '</div>';

                //appointment slots
                $result .= '<div class="col">';

                if ($item->status == 0) {
                    $statuscolor = 'timeslots_appointment_not_accepted';
                    $status_msg = __('patientappo.not scheduled');
                } elseif ($item->status == 1) {
                    $statuscolor = 'timeslots_appointment_accepted';
                    $status_msg = __('patientappo.scheduled');
                } elseif ($item->status == 2) {
                    $statuscolor = 'timeslots_appointment_arrived';
                    $status_msg = __('patientappo.accepted');
                } elseif ($item->status == 3) {
                    $statuscolor = 'timeslots_appointment_done';
                    $status_msg = __('patientappo.done');
                } elseif ($item->status == 4) {
                    $statuscolor = 'timeslots_appointment-not-respond';
                    $status_msg =  __('patientappo.not respond');
                } elseif ($item->status == 5) {
                    $statuscolor = 'timeslots_appointment_with_doctor';
                    $status_msg = __('patientappo.postponed');
                } elseif ($item->status == 6) {
                    $statuscolor = 'timeslots_appointment_canceled';
                    $status_msg = __('patientappo.canceled');
                }

                $result .= '<div class="div d-flex">';

                $result .= '<div id="weekly_calendar_fetch_pat" class=" ' . $statuscolor . ' d-flex text-center mb-3 align-items-center b-r-s-cont w-100 clickable-item-pointer justify-content-between" data-id="' . $item->id . '" data-status="' . $item->status . '" data-name="' . $item->patient->name .
                    '" data-avatar="' . $item->patient->avatar . '" data-phone_number="' . $item->patient->phone_number . '" data-year="' . $year . '" data-month="' . $month . '" data-day="' . $day . '" >';

                $result .= '<div class="d-flex align-items-center ">';
                $result .= '<img class="rounded-circle avatar-small me-2" src="' . URL::asset('img/useravatar/' . $item->patient->avatar) . '">';
                $result .= '<div class="text-start">';
                $result .= '<h6 class="text-xxs mb-0 fw-normal">' . $item->service_item->name . '</h6>';
                $result .= '<h6 class="text-s mb-1 fw-normal ">' . $item->patient->name . '</h6>';
                $result .= '</div></div>';

                $result .= '<h6 class="text-xs text-end mb-0 fw-normal ">' . $status_msg . '</h6>';
                $result .= '</div>';

                $result .= '</div>';
                $result .= '</div>';

                $result .= '</div>';
            }
        } else {
            $result .= '<div class="row">';
            $result .= '<div class="timeslots_appointment_show justify-content-center px-4 py-2 d-flex mb-3 align-items-center b-r-s-cont pt-0 pt-md-0">';
            $result .= '<a href="' . route('sett.appointment.create') . '" class="text-s mb-0 fw-normal text-gray-700">
                    <div class="text-center">
                        <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-1"></i>
                        <p class="fw-light mb-0 fs-5 text-gray-400">' . __("basic.no bookings")  . '</p>
                    </div>
                </a>';
            $result .= '</div>';
            $result .= '</div>';
        }

        $result .= '</div>';


        return $result;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $oper_place = Oper_placecat::all();
        $branches = Branch::all();
        $countries = Country::orderByRaw('RAND()')->get();
        $from_recourses = From_recourse::all();
        $specialties = Specialty_cat::all();

        return view('branch/operation.create', compact('oper_place', 'branches', 'countries', 'from_recourses', 'specialties'));
    }

    //fetch servcies besed on speicilty
    public function fetch_servicecat_ajax_operation($search_query)
    {
        $service = Service_item::where('service_inv_cat_id', 5)
        ->where('specialty_id', $search_query)
        ->where('deactivate', 0)->get();
        return $service;
    }

    public function calander_show_slots_ajax_op($datetoday, $specialty_id, $op_place_id)
    {

        $duration = prox_sett('timeslotduration');
        $cleanup = prox_sett('timeslotcleanup');
        $start = prox_sett('timeslotstart');
        $end = prox_sett('timeslotend');

        return showSlots_operation($duration, $cleanup, $start, $end, $datetoday, $specialty_id, $op_place_id);
    }

    //select the calander data and funcation via ajax in create operation
    public function calander_appointment_ajax_operation($month, $year, $specialty_id, $oper_place_id)
    {

        if (isset(request()->month) && isset(request()->year)) {
            $month = request()->month;
            $year = request()->year;
        } else {
            $dateComponents = getdate();
            $month = $dateComponents['mon'];
            $year = $dateComponents['year'];
        }

        $duration = prox_sett('timeslotduration');
        $cleanup = prox_sett('timeslotcleanup');
        $start = prox_sett('timeslotstart');
        $end = prox_sett('timeslotend');

        if (prox_sett('timeslotweekends') !== "null") {
            $weekends = unserialize(prox_sett('timeslotweekends'));
        } else {
            $weekends = array();
        }

        return build_calendar_operation($month, $year, $specialty_id, $oper_place_id, $duration, $cleanup, $start, $end, $weekends);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(PatientRequest $request)
    {
        // the valdiation is in (app/requests/PatientRequest)

        $patient_id = $request->input('search_patient_id');

        $calander_date_day = $request->input('calander_date_day');

        $calander_date_start = date("H:i", strtotime($request->input('calander_date_start')));

        if ($request->input('calander_date_end')) {
            $calander_date_end = date("H:i", strtotime($request->input('calander_date_end')));
        } else {
            $duration = prox_sett('timeslotduration');
            $cleanup = prox_sett('timeslotcleanup');
            $calander_date_start_end =  $duration + $cleanup;
            $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end);
            $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end)->format("H:i");
        }

        $start_at = $calander_date_day . ' ' . $calander_date_start;
        $end_at = $calander_date_day . ' ' . $calander_date_end;

        $service_id = $request->input('service_id');
        $branch_id = $request->input('branch_id');
        $coupon_id = $request->input('coupon_id');

        $service_price = Service_item::select('id', 'name', 'service_inv_cat_id', 'price')
            ->where('deactivate', 0)
            ->where('id', $service_id)->first();


        if (!empty($coupon_id)) {
            $coupon = Coupon::find($coupon_id);
            $discount_amount = $coupon->discount($service_price->price);
            $final_price = $service_price->price - $discount_amount;
        } else {
            $discount_amount = null;
            $final_price = $service_price->price;
        }

        //if the patietn exist already
        if (!empty($patient_id)) {

            $appointment = Operation::create([
                'specialty_id' => $request->input('specialty_id'),
                'branch_id' => $branch_id,
                'oper_place_id' => $request->input('oper_place_id'),
                'patient_id' => $patient_id,
                'services_cat_id' => $service_id,
                'start_at' => $start_at,
                'end_at' => $end_at,
                'note' => $request->input('appointment_note'),
                'creator_id' => Auth::id(),
            ]);


            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'service_inv_cat_id' => $service_price->service_inv_cat_id,
                'specialty_id' => $request->input('specialty_id'),
                'receivable_id' => $patient_id,
                'receivable_type' => "App\Models\Patient\Patient",
                'branch_id' => $branch_id,
                'items_price' => $service_price->price,
                'coupon_id' => $coupon_id,
                'discount' => $discount_amount,
                'final_price' => $final_price,
            ]);

            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'itemable_id' => $appointment->id,
                'itemable_type' => "App\Models\Branch\Operation",
                'categorizable_id' => $service_id,
                'categorizable_type' => "App\Models\Patient\Service_item",
                'price' => $service_price->price,
                'sold_price' => $service_price->price,
            ]);
        }
        //if create a new user
        else {

            //insert img
            if ($request->hasFile('avatar')) {
                $file_extension = request()->avatar->getClientOriginalExtension();
                $file_name = $request->input('first_name') . time() . '.' . $file_extension;
                $path = 'img/useravatar';
                $request->avatar->move($path, $file_name);
            } else {
                $file_name = 'default-pp.png';
            }

            $patient_branch_id = $request->input('first_branch_id');
            $new_serial_number = serial_number('patient');
            $new_serial_number_branch = serial_number('patient', $patient_branch_id);
            $code_branch = Branch::select('id', 'code')->find($patient_branch_id);

            $patient = Patient::create([
                'type' => 1,
                'new_id' => $new_serial_number,
                'new_branch_id' => $new_serial_number_branch,
                'code' => $code_branch->code . "-" . $this->generateRandomString(6),
                'email' => $request->input('email'),
                'password' => bcrypt($request->input('password')),
                'first_branch_id' => $patient_branch_id,
                'first_name' => $request->input('first_name'),
                'second_name' => $request->input('second_name'),
                'mother_name' => $request->input('mother_name'),
                'avatar' => $file_name,
                'birthday' => $request->input('birthday'),
                'gendar' => $request->input('gendar'),
                'country_id' => $request->input('country_id'),
                'city_id' => $request->input('city_id'),
                'phone_number' => $request->input('phone_number'),
                'sec_phone_number' => $request->input('sec_phone_number'),
                'insurance' => $request->input('insurance'),
                'from_recourse_id' => $request->input('from_recourse_id'),
                'creator_id' => Auth::id(),
            ]);

            $appointment = Operation::create([
                'specialty_id' => $request->input('specialty_id'),
                'branch_id' => $branch_id,
                'oper_place_id' => $request->input('oper_place_id'),
                'patient_id' => $patient->id,
                'services_cat_id' => $service_id,
                'start_at' => $start_at,
                'end_at' => $end_at,
                'note' => $request->input('appointment_note'),
                'creator_id' => Auth::id(),
            ]);


            $invoice = Invoice::create([
                'code' => "IN" . $this->generateRandomString(6),
                'service_inv_cat_id' => $service_price->service_inv_cat_id,
                'specialty_id' => $request->input('specialty_id'),
                'receivable_id' => $patient->id,
                'receivable_type' => "App\Models\Patient\Patient",
                'branch_id' => $branch_id,
                'items_price' => $service_price->price,
                'coupon_id' => $coupon_id,
                'discount' => $discount_amount,
                'final_price' => $final_price,
            ]);

            $invoice_item = Invoice_item::create([
                'invoice_id' => $invoice->id,
                'itemable_id' => $appointment->id,
                'itemable_type' => "App\Models\Branch\Operation",
                'categorizable_id' => $service_id,
                'categorizable_type' => "App\Models\Patient\Service_item",
                'price' => $service_price->price,
                'sold_price' => $service_price->price,
            ]);
        }

        session()->flash('success', 'The operation has been created successfully');
        return redirect()->route('sett.operation.show', $appointment->id);
    }


    public function operation_patient_add(Request $request)
    {

        $this->validate($request, [
            'oper_cat_serv_id' => ['required', 'exists:service_items,id'],
            'last_appointment_id' => ['required', 'exists:appointments,id'],
            'patient_id' => ['required', 'exists:patients,id'],
            'operation_before_img' => ['image', 'mimes:jpeg,jpg,png', 'max:700'],
            'price_invoice_operation' => ['required', 'numeric'],
        ]);

        $branch_id = Appointment::select('branch_id')->find($request->input('last_appointment_id'));

        $xray_file = $request->file('operation_before_img');

        if ($request->hasFile('operation_before_img')) {

            $file_extension = $request->file('operation_before_img')->getClientOriginalExtension();

            $file_name = "OPBE" . time() . '.' . $file_extension;

            $path = public_path('img/operationbefaft/' . $file_name);

            Image::make($request->operation_before_img)
                ->resize(800, null, function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->save($path, 60);
        } else {
            $file_name = "";
        }

        $operation = Operation::create([
            'specialty_id' => Auth::user()->specialty_id,
            'branch_id' => $branch_id->branch_id,
            'oper_place_id' => $request->input('oper_place_id'),
            'appointment_id' => $request->input('last_appointment_id'),
            'patient_id' => $request->input('patient_id'),
            'services_cat_id' => $request->input('oper_cat_serv_id'),
            'start_at' => $request->input('operation_start'),
            'note' => $request->input('note_operation'),
            'creator_id' => Auth::id(),
            'before_oper' => $file_name,
        ]);


        $service_inv_cat = Service_item::select('id', 'service_inv_cat_id')
            ->where('deactivate', 0)
            ->where('id', $request->input('oper_cat_serv_id'))
            ->first();

        $invoice = Invoice::create([
            'code' => "IN" . $this->generateRandomString(6),
            'operation' => 1,
            'service_inv_cat_id' => $service_inv_cat->service_inv_cat_id,
            'specialty_id' => Auth::user()->specialty_id,
            'receivable_id' => $request->input('patient_id'),
            'receivable_type' => "App\Models\Patient\Patient",
            'branch_id' => $branch_id->branch_id,
            'price' => $request->input('price_invoice_operation'),
            'final_price' => $request->input('price_invoice_operation'),
            'note' => $request->input('invoice_note_operation'),
        ]);


        $invoice_item = Invoice_item::create([
            'invoice_id' => $invoice->id,
            'itemable_id' => $operation->id,
            'itemable_type' => "App\Models\Branch\Operation",
            'categorizable_id' => $request->input('oper_cat_serv_id'),
            'categorizable_type' => "App\Models\Patient\Service_item",
            'price' => $request->input('price_invoice_operation'),
            'sold_price' => $request->input('price_invoice_operation'),
        ]);

        session()->flash('success', 'The Operation has been created successfully');
        return redirect()->back();
    }


    public function operation_patient_add_gallery(Request $request)
    {

        $this->validate($request, [
            'op_ga_type' => ['required'],
            'gallery-op-id' => ['required', 'exists:operations,id'],
            'patient_id' => ['required', 'exists:patients,id'],
            'op_imgs' => ['required'],
            'op_imgs.*' => ['image', 'mimes:jpeg,jpg,png,heic,heif', 'max:15000'],
        ]);

        $op_imgs = $request->file('op_imgs');

        foreach ($op_imgs as $key => $img_form) {

            $file_extension = $img_form->getClientOriginalExtension();


            $file_name = "OPIMG" . $key . time() . '.' . $file_extension;

            $path = public_path('img/opgallery/' . $file_name);

            Image::make($img_form)
                ->resize(800, null, function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->save($path, 60);

            $operation = Op_img::create([
                'op_id' => $request->input('gallery-op-id'),
                'patient_id' => $request->input('patient_id'),
                'oper_place_id' => $request->input('oper_place_id'),
                'type' => $request->input('op_ga_type'),
                'img' => $file_name,
            ]);
        }

        session()->flash('success', 'The Images has been added successfully');
        return redirect()->back();
    }

    public function operation_gallery($id)
    {

        $gallery = Operation::find($id);
        return view('branch/operation.gallery_show', compact('gallery'));
    }

    public function operation_patient_during_op(Request $request)
    {

        $operation = Op_during::create([
            'op_id' => $request->input('during-op-id'),
            'patient_id' => $request->input('patient_id'),
            'dorsum_hump_reduction_bony' => $request->input('dorsum_hump_reduction_bony'),
            'dorsum_hump_reduction_septal' => $request->input('dorsum_hump_reduction_septal'),
            'dorsum_hump_reduction_cartilaginous' => $request->input('dorsum_hump_reduction_cartilaginous'),
            'dorsum_augmentation' => $request->input('dorsum_augmentation'),
            'dorsum_caudal_resection' => $request->input('dorsum_caudal_resection'),
            'septum_excision_except' => $request->input('septum_excision_except'),
            'septum_total_excision_reconstruction' => $request->input('septum_total_excision_reconstruction'),
            'septum_reconstruction' => $request->input('septum_reconstruction'),
            'septum_fixation_spine' => $request->input('septum_fixation_spine'),
            'septum_fixation_nasal_bones' => $request->input('septum_fixation_nasal_bones'),
            'septum_scoring' => $request->input('septum_scoring'),
            'osteotomies_med_oblique' => $request->input('osteotomies_med_oblique'),
            'osteotomies_lateral' => $request->input('osteotomies_lateral'),
            'osteotomies_multiple' => $request->input('osteotomies_multiple'),
            'osteotomies_bone_carving' => $request->input('osteotomies_bone_carving'),
            'upper_lats_on_lay_grafts' => $request->input('upper_lats_on_lay_grafts'),
            'upper_lats_total_reconstruction' => $request->input('upper_lats_total_reconstruction'),
            'upper_lats_spreader_grafts' => $request->input('upper_lats_spreader_grafts'),
            'upper_lats_spreader_flaps' => $request->input('upper_lats_spreader_flaps'),
            'tip_plasty_hemidomal_suture' => $request->input('tip_plasty_hemidomal_suture'),
            'tip_plasty_tip_defining_suture' => $request->input('tip_plasty_tip_defining_suture'),
            'tip_plasty_tip_equalizing_suture' => $request->input('tip_plasty_tip_equalizing_suture'),
            'tip_plasty_other_sutures' => $request->input('tip_plasty_other_sutures'),
            'cap_graft_non_crushed_cartilage' => $request->input('cap_graft_non_crushed_cartilage'),
            'cap_graft_crushed_cartilage' => $request->input('cap_graft_crushed_cartilage'),
            'cap_graft_soft_tissue_cartilage' => $request->input('cap_graft_soft_tissue_cartilage'),
            'tip_plasty_shield_graft' => $request->input('tip_plasty_shield_graft'),
            'tip_plasty_columellar_strut' => $request->input('tip_plasty_columellar_strut'),
            'tools_rose_head_drill' => $request->input('tools_rose_head_drill'),
            'tools_burr_head_drill' => $request->input('tools_burr_head_drill'),
            'tools_piezotome' => $request->input('tools_piezotome'),
            'tools_hammer_chisel' => $request->input('tools_hammer_chisel'),
            'dorsal_graft' => $request->input('dorsal_graft'),
            'conceal_cartilage_graft' => $request->input('conceal_cartilage_graft'),
            'costal_cartilage_graft' => $request->input('costal_cartilage_graft'),
            'temporal_fascial_graft' => $request->input('temporal_fascial_graft'),
            'op_type' => $request->input('op_type'),
            'tools_raspier' => $request->input('tools_raspier'),
            'nostril_reduction' => $request->input('nostril_reduction'),
            'other_steps' => $request->input('other_steps'),
            'other_operations' => $request->input('other_operations'),
            'cephalic_resection_lat_crus_cartilage' => $request->input('cephalic_resection_lat_crus_cartilage'),
            'op_duration' => $request->input('op_duration'),
            'skin_type' => $request->input('skin_type'),
            'other_facial_problems' => $request->input('other_facial_problems'),
            'length' => $request->input('length'),
            'dorsal_width' => $request->input('dorsal_width'),
            'rotation' => $request->input('rotation'),
            'tip_projection' => $request->input('tip_projection'),
            'alar_base' => $request->input('alar_base'),
            'other_note' => $request->input('other_note'),
        ]);

        session()->flash('success', 'The Images has been added successfully');
        return redirect()->back();
    }

    public function operation_patient_during_op_upd(Request $request)
    {

        $op_id = $request->input('op_id');

        $operation = Op_during::find($op_id);

        $operation->dorsum_hump_reduction_bony = $request->get('dorsum_hump_reduction_bony');
        $operation->dorsum_hump_reduction_septal = $request->input('dorsum_hump_reduction_septal');
        $operation->dorsum_hump_reduction_cartilaginous = $request->input('dorsum_hump_reduction_cartilaginous');
        $operation->dorsum_augmentation = $request->input('dorsum_augmentation');
        $operation->dorsum_caudal_resection = $request->input('dorsum_caudal_resection');
        $operation->septum_excision_except = $request->input('septum_excision_except');
        $operation->septum_total_excision_reconstruction = $request->input('septum_total_excision_reconstruction');
        $operation->septum_reconstruction = $request->input('septum_reconstruction');
        $operation->septum_fixation_spine = $request->input('septum_fixation_spine');
        $operation->septum_fixation_nasal_bones = $request->input('septum_fixation_nasal_bones');
        $operation->septum_scoring = $request->input('septum_scoring');
        $operation->osteotomies_med_oblique = $request->input('osteotomies_med_oblique');
        $operation->osteotomies_lateral = $request->input('osteotomies_lateral');
        $operation->osteotomies_multiple = $request->input('osteotomies_multiple');
        $operation->osteotomies_bone_carving = $request->input('osteotomies_bone_carving');
        $operation->upper_lats_on_lay_grafts = $request->input('upper_lats_on_lay_grafts');
        $operation->upper_lats_total_reconstruction = $request->input('upper_lats_total_reconstruction');
        $operation->upper_lats_spreader_grafts = $request->input('upper_lats_spreader_grafts');
        $operation->upper_lats_spreader_flaps = $request->input('upper_lats_spreader_flaps');
        $operation->tip_plasty_hemidomal_suture = $request->input('tip_plasty_hemidomal_suture');
        $operation->tip_plasty_tip_defining_suture = $request->input('tip_plasty_tip_defining_suture');
        $operation->tip_plasty_tip_equalizing_suture = $request->input('tip_plasty_tip_equalizing_suture');
        $operation->tip_plasty_other_sutures = $request->input('tip_plasty_other_sutures');
        $operation->cap_graft_non_crushed_cartilage = $request->input('cap_graft_non_crushed_cartilage');
        $operation->cap_graft_crushed_cartilage = $request->input('cap_graft_crushed_cartilage');
        $operation->cap_graft_soft_tissue_cartilage = $request->input('cap_graft_soft_tissue_cartilage');
        $operation->tip_plasty_shield_graft = $request->input('tip_plasty_shield_graft');
        $operation->tip_plasty_columellar_strut = $request->input('tip_plasty_columellar_strut');
        $operation->tools_rose_head_drill = $request->input('tools_rose_head_drill');
        $operation->tools_burr_head_drill = $request->input('tools_burr_head_drill');
        $operation->tools_piezotome = $request->input('tools_piezotome');
        $operation->tools_hammer_chisel = $request->input('tools_hammer_chisel');
        $operation->dorsal_graft = $request->input('dorsal_graft');
        $operation->conceal_cartilage_graft = $request->input('conceal_cartilage_graft');
        $operation->costal_cartilage_graft = $request->input('costal_cartilage_graft');
        $operation->temporal_fascial_graft = $request->input('temporal_fascial_graft');
        $operation->op_type = $request->input('op_type');
        $operation->tools_raspier = $request->input('tools_raspier');
        $operation->nostril_reduction = $request->input('nostril_reduction');
        $operation->other_steps = $request->input('other_steps');
        $operation->other_operations = $request->input('other_operations');
        $operation->cephalic_resection_lat_crus_cartilage = $request->input('cephalic_resection_lat_crus_cartilage');
        $operation->op_duration = $request->input('op_duration');
        $operation->skin_type = $request->input('skin_type');
        $operation->other_facial_problems = $request->input('other_facial_problems');
        $operation->length = $request->input('length');
        $operation->dorsal_width = $request->input('dorsal_width');
        $operation->rotation = $request->input('rotation');
        $operation->tip_projection = $request->input('tip_projection');
        $operation->alar_base = $request->input('alar_base');
        $operation->other_note = $request->input('other_note');
        $operation->save();


        session()->flash('success', 'The Operation has been updated successfully');
        return redirect()->back();
    }


    public function operation_patient_past_note(Request $request)
    {

        $op_id = $request->input('op_id');

        $operation = Operation::find($op_id);

        $operation->note_after_op = $request->get('note_after_op');

        $operation->save();
        session()->flash('success', 'The Operation has been updated successfully');
        return redirect()->back();
    }

    public function operation_patient_delete_gallery(Request $request)
    {

        $id = $request->input('opertion_id_op_delete');

        $opimg = Op_img::find($id);

        $imagePath = public_path('img/opgallery/' . $opimg->img);

        if (File::exists($imagePath)) {
            File::delete($imagePath);
        }

        $opimg = $opimg->delete();

        session()->flash('success', 'The Image has been deleted successfully');
        return redirect()->back();
    }


    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    //get the appointment info from the timeslot
    public function appointment_info_ajax_operation($id)
    {

        $appointment = Operation::select('id', 'patient_id', 'doctor_id', 'services_cat_id', 'creator_id', 'status', 'start_at', 'note')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status', 'discount', 'final_price');
                    }]);
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->where('id', $id)
            ->first();

        $doctors = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'doctor');
                }
            )->get();

        $day_name = date('l', strtotime($appointment->start_at));
        $day_month = date('d', strtotime($appointment->start_at));

        $start = date('h:i a', strtotime($appointment->start_at));
        $end = date('h:i a', strtotime($appointment->end_at));

        return compact('appointment', 'doctors', 'day_name', 'day_month', 'start', 'end');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $appointment = Operation::select('id', 'patient_id', 'branch_id', 'oper_place_id', 'doctor_id', 'services_cat_id', 'creator_id', 'status', 'start_at', 'note')
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name', 'address');
            }])
            ->with(['place' => function ($q) {
                $q->select('id', 'name', 'address');
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type', 'price')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'final_price');
                    }]);
            }])
            ->with(['service_item' => function ($q) {
                $q->withTrashed()->select('id', 'name');
            }])
            ->find($id);

        return view('branch/operation.show', compact('appointment'));
    }

    public function monthly_calendar_data_operation($year, $month, $specialty, $branch)
    {
        return monthly_calendar_operation($month, $year, $specialty, $branch);
    }

    public function allstatcs($specialty = "all", $branch = "all")
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $appointment_all = Appointment::select(
            DB::raw('count(id) as counts'),
            DB::raw("DATE_FORMAT(created_at,'%m') as monthKey")
        )
            ->whereYear('created_at', date('Y'))
            ->groupBy('monthKey')
            ->orderBy('created_at', 'ASC');

        if ($specialty !== "all") {
            $appointment_all = $appointment_all->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $appointment_all = $appointment_all->where('branch_id', $branch);
        }

        $appointment_all = $appointment_all->get();


        $appointment_date = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($appointment_all as $order) {
            $appointment_date[$order->monthKey - 1] = $order->counts;
        }

        // ----------------------

        $branches_name = Branch::whereHas('appointment')->get();
        $appointment = new Collection();

        foreach ($branches_name as $item) {
            $query = Appointment::select(
                'branch_id',
                DB::raw('count(branch_id) as counts'),
                DB::raw("DATE_FORMAT(created_at,'%m') as monthKey")
            )
                ->with(['branch' => function ($q) {
                    $q->select('id', 'name');
                }])
                ->whereYear('created_at', date('Y'))
                ->where('branch_id', $item->id)
                ->groupBy('monthKey')
                ->orderBy('created_at', 'ASC');

            $query = $query->get();

            $appointment_date = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
            foreach ($query as $order) {
                $appointment_date[$order->monthKey - 1] = $order->counts;
            }

            //$branch_name = $query[0]->branch->name;
            $appointment->push((object)[
                'name' => $query[0]->branch->name,
                'total' => $appointment_date
            ]);
        }

        // ----------------------

        $appointment_total = Appointment::whereYear('created_at', date('Y'));

        if ($specialty !== "all") {
            $appointment_total = $appointment_total->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $appointment_total = $appointment_total->where('branch_id', $branch);
        }

        $appointment_total = $appointment_total->count();

        // ----------------------

        $specialty_order = Appointment::select('specialty_id', DB::raw('count(*) as total'))
            ->groupBy('specialty_id')
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_order = $specialty_order->where('branch_id', $branch);
        }

        $specialty_order = $specialty_order->get();
        //--
        $specialty_order_month = Appointment::select('specialty_id', DB::raw('count(*) as total'))
            ->groupBy('specialty_id')
            ->with(['specialty' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereMonth('created_at', date('m'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($branch !== "all") {
            $specialty_order_month = $specialty_order_month->where('branch_id', $branch);
        }

        $specialty_order_month = $specialty_order_month->get();

        // ----------------------

        $branch_order = Appointment::select('branch_id', DB::raw('count(*) as total'))
            ->groupBy('branch_id')
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_order = $branch_order->where('specialty_id', $specialty);
        }

        $branch_order = $branch_order->get();
        //---
        $branch_order_month = Appointment::select('branch_id', DB::raw('count(*) as total'))
            ->groupBy('branch_id')
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereMonth('created_at', date('m'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $branch_order_month = $branch_order_month->where('specialty_id', $specialty);
        }

        $branch_order_month = $branch_order_month->get();


        // ----------------------

        $creator = Appointment::select('creator_id', DB::raw('count(*) as total'))
            ->groupBy('creator_id')
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('creator_id')
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $creator = $creator->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $creator = $creator->where('branch_id', $branch);
        }

        $creator = $creator->get();

        // ----------------------

        $doctor = Appointment::select('doctor_id', DB::raw('count(*) as total'))
            ->groupBy('doctor_id')
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('doctor_id')
            ->whereYear('created_at', date('Y'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $doctor = $doctor->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $doctor = $doctor->where('branch_id', $branch);
        }

        $doctor = $doctor->get();

        // ----------------------

        $creator_month = Appointment::select('creator_id', DB::raw('count(*) as total'))
            ->groupBy('creator_id')
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('creator_id')
            ->whereMonth('created_at', date('m'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $creator_month = $creator_month->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $creator_month = $creator_month->where('branch_id', $branch);
        }

        $creator_month = $creator_month->get();

        // ----------------------

        $doctor_month = Appointment::select('doctor_id', DB::raw('count(*) as total'))
            ->groupBy('doctor_id')
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereNotNull('doctor_id')
            ->whereMonth('created_at', date('m'))
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty !== "all") {
            $doctor_month = $doctor_month->where('specialty_id', $specialty);
        }

        if ($branch !== "all") {
            $doctor_month = $doctor_month->where('branch_id', $branch);
        }

        $doctor_month = $doctor_month->get();

        // ----------------------

        return view('branch/appointment/allstatcs', compact('appointment_date', 'appointment', 'appointment_total', 'specialty_order', 'specialty_order_month', 'branch_order', 'branch_order_month', 'specialty_cat', 'specialty', 'branches', 'branch', 'creator', 'doctor', 'creator_month', 'doctor_month'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $appointment = Operation::select('id', 'specialty_id', 'branch_id', 'oper_place_id', 'services_cat_id', 'start_at')->find($id);
        $specialties = Specialty_cat::all();
        $operation_places = Oper_placecat::select('id', 'name')->get();
        $branches = Branch::select('id', 'name')->get();
        $services = Service_item::where('service_inv_cat_id', 5)->where('deactivate', 0)->get();

        return view('branch/operation.edit', compact('appointment', 'specialties', 'operation_places', 'branches', 'services'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'service_id' => ['required', 'exists:service_items,id'],
            'branch_id' => ['required', 'exists:branches,id'],
            'oper_place_id' => ['required', 'exists:oper_placecats,id'],
        ]);


        $operation = Operation::find($id);
        $invoice_id = $operation->invoice_item->invoice->id;
        $invoice_item_id = $operation->invoice_item->id;

        $invoice_status = $operation->invoice_item->invoice->status;

        if ($invoice_status == 0) {

            $branch_id = $request->input('branch_id');
            $service_id = $request->input('service_id');
            $oper_place_id = $request->input('oper_place_id');

            if ($branch_id != $operation->branch_id) {
                $operation->branch_id = $request->input('branch_id');
                $invoice = Invoice::find($invoice_id);
                $invoice->branch_id = $request->input('branch_id');
                $invoice->save();
            }

            if ($service_id != $operation->services_cat_id) {

                $operation->services_cat_id = $request->input('service_id');

                $services = Service_item::select('id', 'price')->where('deactivate', 0)->find($service_id);

                $invoice_item = Invoice_item::find($invoice_item_id);
                $invoice_item->categorizable_id = $services->id;
                $invoice_item->price = $services->price;
                $invoice_item->save();

                $invoice_price = Invoice::find($invoice_id);
                $invoice_price->branch_id = $request->input('branch_id');
                $invoice_price->final_price = $services->price;
                $invoice_price->save();
            }

            $calander_date_day = $request->input('calander_date_day');

            $calander_date_start = date("H:i", strtotime($request->input('calander_date_start')));

            if ($request->input('calander_date_end')) {
                $calander_date_end = date("H:i", strtotime($request->input('calander_date_end')));
            } else {
                $duration = prox_sett('timeslotduration');
                $cleanup = prox_sett('timeslotcleanup');
                $calander_date_start_end =  $duration + $cleanup;
                $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end);
                $calander_date_end = Carbon::parse($calander_date_start)->addMinutes($calander_date_start_end)->format("H:i");
            }

            $start_at = $calander_date_day . ' ' . $calander_date_start;
            $end_at = $calander_date_day . ' ' . $calander_date_end;

            $operation->specialty_id = $request->input('specialty_id');
            $operation->oper_place_id = $oper_place_id;
            $operation->start_at = $start_at;
            $operation->end_at = $end_at;
            $operation->status = 1;
            $operation->save();
        }

        session()->flash('success', 'The operation has been edited successfully');
        return redirect()->route('sett.operation.index');
    }

    public function operation_patient_edit(Request $request)
    {

        $this->validate($request, [
            'operation_id_update' => ['required', 'exists:operations,id'],
            'oper_status_up' => ['required'],
            'note_operation_up' => ['max:255'],
        ]);

        $operation = Operation::find($request->input('operation_id_update'));

        $operation->note = $request->input('note_operation_up');
        $operation->status = $request->input('oper_status_up');
        $operation->improvement_rate = $request->input('operation_improvment_up');
        $operation->save();

        session()->flash('success', 'The operation has been edited successfully');
        return redirect()->back();
    }

    //update from operation info in calendar
    public function update_status_doctor_operation(Request $request, $appointment_id)
    {

        $this->validate($request, [
            'status' => ['required', Rule::in(['0', '1', '2', '3', '4', '5'])],
            'doctor' => ['nullable', 'exists:users,id'],
        ]);

        $appointment = Operation::find($appointment_id);
        $appointment->status = $request->input('status');
        $appointment->doctor_id = $request->input('doctor');
        $appointment->note = $request->input('note');
        $appointment->save();

        if ($appointment) {
            return response()->json([
                'querystatue' => true,
            ]);
        } else {
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $this->validate($request, [
            'opertion_id_delete' => ['required', 'exists:operations,id'],
        ]);

        $id = $request->input('opertion_id_delete');
        $operation_id = Operation::find($id);
        $invoice_id = $operation_id->invoice_item->invoice->id;
        $invoice_status = $operation_id->invoice_item->invoice->status;

        if ($invoice_status == 0) {
            //delete before img
            $imagePath = public_path('img/operationbefaft/' . $operation_id->before_oper);
            if (File::exists($imagePath)) {
                File::delete($imagePath);
            }
            $operation = Operation::find($id)->delete();
            Invoice::find($invoice_id)->delete();

            Invoice_item::where('invoice_id', $invoice_id)->delete();
        }
        session()->flash('success', 'The operation has been deleted');
        return redirect()->back();
    }




    //------ Operation follow up ------

    public function op_follow_up(Request $request)
    {


        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        $operation_not = Operation::doesnthave('follow_up')
            ->paginate(10);

        return view('branch/operation.op_follow_up', compact('specialty_cat', 'branches', 'specialty', 'branch', 'from', 'to', 'operation_not'));
    }

    public function op_follow_up_inprog(Request $request)
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        $op = Operation::has('follow_up')
            ->paginate(10);

        return view('branch/operation.op_follow_up_inprog', compact('specialty_cat', 'branches', 'specialty', 'branch', 'from', 'to', 'op'));
    }

    public function op_follow_up_today(Request $request)
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        $operation_today = Operation::whereHas('follow_up', function ($q) use ($specialty) {
            $q->whereNull('month_6');
        })
            ->paginate(10);

        return view('branch/operation.op_follow_up_today', compact('specialty_cat', 'branches', 'specialty', 'branch', 'from', 'to', 'operation_today'));
    }

    public function op_follow_up_done(Request $request)
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        $op = Operation::whereHas('follow_up', function ($q) use ($specialty) {
            $q->whereNotNull('month_6');
        })
            ->paginate(10);

        return view('branch/operation.op_follow_up_done', compact('specialty_cat', 'branches', 'specialty', 'branch', 'from', 'to', 'op'));
    }

    public function op_follow_up_file_insert($id)
    {
        $op = Operation::find($id);
        return view('branch/operation.op_follow_up_create', compact('op', 'id'));
    }

    public function op_follow_up_file_store(Request $request, $id)
    {

        $op = Op_follow_up::create([
            'op_id' => $id,
            'day_1' => date('Y-m-d'),
            'patient_id' => $request->input('patient_id'),
            'responsible_id' => $request->input('resp_id'),
        ]);

        return redirect()->route('sett.op_follow_up_show', $op->op_id);
    }

    public function op_follow_up_show($id)
    {

        $op = Operation::whereHas('follow_up', function ($q) use ($id) {
            $q->whereNull('month_6');
        })
            ->findOrFail($id);

        return view('branch/operation.op_follow_up_show', compact('op', 'id'));
    }

    public function op_follow_up_file_update(Request $request, $id)
    {

        $op = Op_follow_up::find($id);
        $op->day_3 = $request->input('day_3');
        $op->week_1 = $request->input('week_1');
        $op->week_2 = $request->input('week_2');
        $op->month_1 = $request->input('month_1');
        $op->month_2 = $request->input('month_2');
        $op->month_3 = $request->input('month_3');
        $op->month_6 = $request->input('month_6');
        $op->note = $request->input('note');
        $op->save();

        return redirect()->back()->with('success', 'The rate has been created successfully');
    }
}
