<?php

namespace App\Http\Controllers\Branch\Cats;

use App\Http\Controllers\Controller;
use App\Models\Invoice\Expenses_item as InvoiceExpenses_item;
use App\Models\Invoice\Invoice;
use App\Models\Patient\Service_inv_cat;
use App\Models\Patient\Specialty_cat;
use Illuminate\Http\Request;

class Expenses_item extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $debt = InvoiceExpenses_item::with(['specialty' => function ($q) {
            $q->select('id', 'name');}])
            ->with(['service_inv_cat' => function ($q) {
                $q->select('id', 'name');}])
        ->get();
        
        return view('cats/expenses_item.index', compact('debt'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $specialty = Specialty_cat::all();
        $service = Service_inv_cat::all();

        return view('cats/expenses_item.create', compact('specialty', 'service'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'specialty_id' => 'required|exists:specialty_cats,id',
            'service_inv_cat' => 'required|exists:service_inv_cats,id',
            'name' => 'required|unique:expenses_items,name',
            'price' => 'required|numeric',
        ]);

        $debt = InvoiceExpenses_item::create([  
            'specialty_id' => $request->input('specialty_id'),
            'service_inv_cat_id' => $request->input('service_inv_cat'),
            'name' => $request->input('name'),
            'price' => $request->input('price'),
        ]);

        return redirect()->route('sett.expenses_item.index')
            ->with('success', 'Cat has been created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $debt = InvoiceExpenses_item::find($id);
        $specialty = Specialty_cat::all();
        $service_inv_cat = Service_inv_cat::all();

        return view('cats/expenses_item.edit', compact('debt', 'specialty', 'service_inv_cat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'price' => 'required|numeric',
        ]);

        $service = InvoiceExpenses_item::find($id);
        $service->name = $request->input('name');
        $service->price = $request->input('price');
        $service->save();

        return redirect()->route('sett.expenses_item.index')
            ->with('success', 'Cat has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
          
        $status = Invoice::where('service_inv_cat_id', $request->input('id_delete'))
        ->first();

        if(empty($status)){
            InvoiceExpenses_item::find($request->input('id_delete'))->delete();


            session()->flash('success', 'The item has been deleted');
            return redirect()->route('sett.expenses_item.index');
        }else{
            session()->flash('error_delete', 'The item has been used before');
            return redirect()->route('sett.expenses_item.index');
        }
    }
}