<?php

namespace App\Http\Controllers\Branch\Appointment;

use App\Http\Controllers\Branch\Appointment\Rate_appointment as BranchAppointmentRate_appointment;
use App\Http\Controllers\Controller;
use App\Models\Branch\Appointment;
use App\Models\Branch\Appointment\Rate_appointment as AppointmentRate_appointment;
use App\Models\Branch\Branch;
use App\Models\Patient\Cancel_reason_cat;
use App\Models\Patient\Lead_pat_note;
use App\Models\Patient\Patient;
use App\Models\Patient\Specialty_cat;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class Rate_appointment extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        $rate_year = new Collection();

        $rate_year_cats = AppointmentRate_appointment::select(
            DB::raw("DATE_FORMAT(appointment_date,'%m') as monthKey"),
            DB::raw('round(AVG(service),1) as service'),
            DB::raw('round(AVG(doctor),1) as doctor'),
            DB::raw('round(AVG(reception),1) as reception'),
            DB::raw('round(AVG(time),1) as time'),
            DB::raw('round(AVG(cleanliness),1) as cleanliness'),
        )
            ->where('type', 1)
            ->whereYear('appointment_date', date('Y'))
            ->groupBy('monthKey');

        if ($specialty) {
            $rate_year_cats = $rate_year_cats->whereHas('appointment', function ($query) use ($specialty) {
                return $query->where('specialty_id', $specialty);
            });
        }

        if ($branch) {
            $rate_year_cats = $rate_year_cats->whereHas('appointment', function ($query) use ($branch) {
                return $query->where('branch_id', $branch);
            });
        }

        $rate_year_cats = $rate_year_cats->get();

        $data_rate_service = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        $data_rate_doctor = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        $data_rate_reception = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        $data_rate_time = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        $data_rate_cleanliness = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

        foreach ($rate_year_cats as $order) {
            if ($order->service) {
                $data_rate_service[$order->monthKey - 1] = $order->service;
            } else {
                $data_rate_service[$order->monthKey - 1] = 0;
            }

            if ($order->doctor) {
                $data_rate_doctor[$order->monthKey - 1] = $order->doctor;
            } else {
                $data_rate_doctor[$order->monthKey - 1] = 0;
            }

            if ($order->reception) {
                $data_rate_reception[$order->monthKey - 1] = $order->reception;
            } else {
                $data_rate_reception[$order->monthKey - 1] = 0;
            }

            if ($order->time) {
                $data_rate_time[$order->monthKey - 1] = $order->time;
            } else {
                $data_rate_time[$order->monthKey - 1] = 0;
            }

            if ($order->cleanliness) {
                $data_rate_cleanliness[$order->monthKey - 1] = $order->cleanliness;
            } else {
                $data_rate_cleanliness[$order->monthKey - 1] = 0;
            }
        }

        $rate_year->push((object)[
            'name' => 'Service',
            'avg' => $data_rate_service
        ]);

        $rate_year->push((object)[
            'name' => 'Doctor',
            'avg' => $data_rate_doctor
        ]);

        $rate_year->push((object)[
            'name' => 'Reception',
            'avg' => $data_rate_reception
        ]);

        $rate_year->push((object)[
            'name' => 'Time',
            'avg' => $data_rate_time
        ]);

        $rate_year->push((object)[
            'name' => 'Cleanliness',
            'avg' => $data_rate_cleanliness
        ]);

        $rate_total = AppointmentRate_appointment::select(
            DB::raw('round(AVG(service),1) as service'),
            DB::raw('round(AVG(doctor),1) as doctor'),
            DB::raw('round(AVG(reception),1) as reception'),
            DB::raw('round(AVG(time),1) as time'),
            DB::raw('round(AVG(cleanliness),1) as cleanliness'),
        )
            ->where('type', 1);

        if ($specialty) {
            $rate_total = $rate_total->whereHas('appointment', function ($query) use ($specialty) {
                return $query->where('specialty_id', $specialty);
            });
        }

        if ($branch) {
            $rate_total = $rate_total->whereHas('appointment', function ($query) use ($branch) {
                return $query->where('branch_id', $branch);
            });
        }

        if ($from) {
            $rate_total = $rate_total->whereBetween('appointment_date', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $rate_total = $rate_total->whereYear('appointment_date', date('Y'));
        }

        $rate_total = $rate_total->get();


        $not_rated_appo_number = Appointment::whereIn('status', [2, 3, 4, 6])
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->doesnthave('rate')
            ->with(['rate' => function ($q) {
                $q->select('id', 'appointment_id', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'created_at');
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereBetween('start_at', [Carbon::now()->subDays(15), Carbon::now()->subDays(2)])
            ->count();

        return view('branch/rate_appointment.index', compact('specialty_cat', 'branches',  'specialty', 'rate_year', 'branch', 'from', 'to', 'rate_total', 'not_rated_appo_number'));
    }

    //----- cancellation
    public function index_cancel_rate(Request $request)
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        //----- cancellation during year
        $cancel_year = Appointment::select(
            DB::raw('count(id) as counts'),
            DB::raw("DATE_FORMAT(start_at,'%m') as monthKey")
        )
            ->whereYear('start_at', date('Y'))
            ->where('status', 6)
            ->groupBy('monthKey')
            ->orderBy('start_at', 'ASC');

        if ($specialty) {
            $cancel_year = $cancel_year->where('specialty_id', $specialty);
        }

        if ($branch) {
            $cancel_year = $cancel_year->where('branch_id', $branch);
        }

        if ($from) {
            $cancel_year = $cancel_year->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $cancel_year = $cancel_year->whereYear('start_at', date('Y'));
        }

        $cancel_year = $cancel_year->get();


        $appointment_cancel_allyear = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($cancel_year as $order) {
            $appointment_cancel_allyear[$order->monthKey - 1] = $order->counts;
        }

        //---- cancellation cat

        $cancel_cat = AppointmentRate_appointment::select('cancel_cat_id', DB::raw('count(*) as total'))
            ->groupBy('cancel_cat_id')
            ->where('type', 2)
            ->whereYear('appointment_date', date('Y'))
            ->with(['cancel' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty) {
            $cancel_cat = $cancel_cat->whereHas('appointment', function ($query) use ($specialty) {
                return $query->where('specialty_id', $specialty);
            });
        }

        if ($branch) {
            $cancel_cat = $cancel_cat->whereHas('appointment', function ($query) use ($branch) {
                return $query->where('branch_id', $branch);
            });
        }

        if ($from) {
            $cancel_cat = $cancel_cat->whereBetween('appointment_date', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $cancel_cat = $cancel_cat->whereYear('appointment_date', date('Y'));
        }

        $cancel_cat = $cancel_cat->get();

        //--

        $total_cancel_appo = Appointment::where('status', 6)
            ->whereYear('start_at', date('Y'));

        if ($specialty) {
            $total_cancel_appo = $total_cancel_appo->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_cancel_appo = $total_cancel_appo->where('branch_id', $branch);
        }

        if ($from) {
            $total_cancel_appo = $total_cancel_appo->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_cancel_appo = $total_cancel_appo->whereYear('start_at', date('Y'));
        }

        $total_cancel_appo = $total_cancel_appo->count();

        $total_done_appo = Appointment::whereIn('status', [2, 3, 4])
            ->whereYear('start_at', date('Y'));

        if ($specialty) {
            $total_done_appo = $total_done_appo->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_done_appo = $total_done_appo->where('branch_id', $branch);
        }

        if ($from) {
            $total_done_appo = $total_done_appo->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_done_appo = $total_done_appo->whereYear('start_at', date('Y'));
        }

        $total_done_appo = $total_done_appo->count();

        $total_notaccepted_appo = Appointment::where('status', 0)
            ->whereYear('start_at', date('Y'));

        if ($specialty) {
            $total_notaccepted_appo = $total_notaccepted_appo->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_notaccepted_appo = $total_notaccepted_appo->where('branch_id', $branch);
        }

        if ($from) {
            $total_notaccepted_appo = $total_notaccepted_appo->whereBetween('start_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_notaccepted_appo = $total_notaccepted_appo->whereYear('start_at', date('Y'));
        }

        $total_notaccepted_appo = $total_notaccepted_appo->count();

        $total_appo = Appointment::count();
        $percentage_cancellation = round($total_cancel_appo / $total_appo * 100, 1);
        $percentage_done = round($total_done_appo / $total_appo * 100, 1);
        $percentage_notaccepted = round($total_notaccepted_appo / $total_appo * 100, 1);

        return view('branch/rate_appointment.index_cancel', compact('specialty_cat', 'branches',  'specialty', 'branch', 'from', 'to', 'appointment_cancel_allyear', 'cancel_cat', 'percentage_cancellation', 'percentage_done', 'percentage_notaccepted'));
    }

    //----- cancellation
    public function index_inactive_patient(Request $request)
    {

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        //----- cancellation during year
        $patient_year = Patient::select(
            DB::raw('count(id) as counts'),
            DB::raw("DATE_FORMAT(created_at,'%m') as monthKey")
        )
            ->whereYear('created_at', date('Y'))
            ->where('type', '!=', 1)
            ->groupBy('monthKey')
            ->orderBy('created_at', 'ASC');

        if ($specialty) {
            $patient_year = $patient_year->where('specialty_id', $specialty);
        }

        if ($branch) {
            $patient_year = $patient_year->where('first_branch_id', $branch);
        }

        if ($from) {
            $patient_year = $patient_year->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $patient_year = $patient_year->whereYear('created_at', date('Y'));
        }

        $patient_year = $patient_year->get();

        $patient_year_allyear = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
        foreach ($patient_year as $order) {
            $patient_year_allyear[$order->monthKey - 1] = $order->counts;
        }

        //---- ask for cat

        $ask_for = Patient::select('ask_for_id', DB::raw('count(*) as total'))
            ->groupBy('ask_for_id')
            ->where('type', '!=', 1)
            ->whereNotNull('ask_for_id')
            ->whereYear('created_at', date('Y'))
            ->with(['ask_for' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty) {
            $ask_for = $ask_for->whereHas('appointment', function ($query) use ($specialty) {
                return $query->where('specialty_id', $specialty);
            });
        }

        if ($branch) {
            $ask_for = $ask_for->where('first_branch_id', $branch);
        }

        if ($from) {
            $ask_for = $ask_for->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $ask_for = $ask_for->whereYear('created_at', date('Y'));
        }

        $ask_for = $ask_for->get();

        //---- resources for cat

        $resources = Patient::select('from_recourse_id', DB::raw('count(*) as total'))
            ->groupBy('from_recourse_id')
            ->where('type', '!=', 1)
            ->whereYear('created_at', date('Y'))
            ->with(['recourse' => function ($q) {
                $q->select('id', 'name');
            }])
            ->limit(11)
            ->orderBy('total', 'DESC');

        if ($specialty) {
            $resources = $resources->whereHas('appointment', function ($query) use ($specialty) {
                return $query->where('specialty_id', $specialty);
            });
        }

        if ($branch) {
            $resources = $resources->where('first_branch_id', $branch);
        }

        if ($from) {
            $resources = $resources->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $resources = $resources->whereYear('created_at', date('Y'));
        }

        $resources = $resources->get();

        //---- total inactive ptients

        $total_inactive_patients = Patient::where('type', '!=', 1)
            ->whereYear('created_at', date('Y'));

        if ($specialty) {
            $total_inactive_patients = $total_inactive_patients->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_inactive_patients = $total_inactive_patients->where('first_branch_id', $branch);
        }

        if ($from) {
            $total_inactive_patients = $total_inactive_patients->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_inactive_patients = $total_inactive_patients->whereYear('created_at', date('Y'));
        }

        $total_inactive_patients = $total_inactive_patients->count();

        //---- total leads ptients no action

        $total_leads_patients_noaction = Patient::where('type', 2)
            ->whereYear('created_at', date('Y'));

        if ($specialty) {
            $total_leads_patients_noaction = $total_leads_patients_noaction->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_leads_patients_noaction = $total_leads_patients_noaction->where('first_branch_id', $branch);
        }

        if ($from) {
            $total_leads_patients_noaction = $total_leads_patients_noaction->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_leads_patients_noaction = $total_leads_patients_noaction->whereYear('created_at', date('Y'));
        }

        $total_leads_patients_noaction = $total_leads_patients_noaction->count();

        //---- total leads interested ptients

        $total_leads_patients_interested = Patient::where('type', 3)
            ->whereYear('created_at', date('Y'));

        if ($specialty) {
            $total_leads_patients_interested = $total_leads_patients_interested->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_leads_patients_interested = $total_leads_patients_interested->where('first_branch_id', $branch);
        }

        if ($from) {
            $total_leads_patients_interested = $total_leads_patients_interested->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_leads_patients_interested = $total_leads_patients_interested->whereYear('created_at', date('Y'));
        }

        $total_leads_patients_interested = $total_leads_patients_interested->count();

        //---- total leads not interested ptients

        $total_leads_patients_notinterested = Patient::where('type', 4)
            ->whereYear('created_at', date('Y'));

        if ($specialty) {
            $total_leads_patients_notinterested = $total_leads_patients_notinterested->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_leads_patients_notinterested = $total_leads_patients_notinterested->where('first_branch_id', $branch);
        }

        if ($from) {
            $total_leads_patients_notinterested = $total_leads_patients_notinterested->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_leads_patients_notinterested = $total_leads_patients_notinterested->whereYear('created_at', date('Y'));
        }

        $total_leads_patients_notinterested = $total_leads_patients_notinterested->count();

        //---- total active patients


        $total_active_patients = Patient::where('type', 1)
            ->whereYear('created_at', date('Y'));

        if ($specialty) {
            $total_active_patients = $total_active_patients->where('specialty_id', $specialty);
        }

        if ($branch) {
            $total_active_patients = $total_active_patients->where('first_branch_id', $branch);
        }

        if ($from) {
            $total_active_patients = $total_active_patients->whereBetween('created_at', [
                Carbon::createFromFormat('m-Y', $from)->startOfMonth(), //2022-10-01 00:00:00.0
                Carbon::createFromFormat('m-Y', $to)->endOfMonth() // 2022-10-31 23:59:59.999999
            ]);
        } else {
            $total_active_patients = $total_active_patients->whereYear('created_at', date('Y'));
        }

        $total_active_patients = $total_active_patients->count();


        return view('branch/rate_appointment.index_inactive_patient', compact('specialty_cat', 'branches',  'specialty', 'branch', 'from', 'to', 'patient_year_allyear', 'ask_for', 'resources', 'total_inactive_patients', 'total_active_patients', 'total_leads_patients_noaction', 'total_leads_patients_interested', 'total_leads_patients_notinterested'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/branchcat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'appointment_id_input' => 'required|exists:appointments,id',
            'note' => 'max:255',
        ]);

        $appointment = Appointment::select('id', 'start_at')->find($request->input('appointment_id_input'));

        if ($request->input('rate_type') == 1) {
            $rate = AppointmentRate_appointment::create([
                'appointment_id' => $request->input('appointment_id_input'),
                'type' => 1,
                'service' => $request->input('rate_service'),
                'doctor' => $request->input('rate_doctor'),
                'reception' => $request->input('rate_reception'),
                'time' => $request->input('rate_time'),
                'cleanliness' => $request->input('rate_cleanliness'),
                'note' => $request->input('rate_note'),
                'appointment_date' => $appointment->start_at,
            ]);
        } else {
            $rate = AppointmentRate_appointment::create([
                'appointment_id' => $request->input('appointment_id_input'),
                'type' => 2,
                'cancel_cat_id' => $request->input('reason'),
                'note' => $request->input('rate_note'),
                'appointment_date' => $appointment->start_at,
            ]);
        }

        return redirect()->back()->with('success', 'The rate has been created successfully');
    }


    public function save_rate_note(Request $request, $id)
    {

        $rate = AppointmentRate_appointment::find($id);
        $rate->saved = $request->input('status');
        $rate->save();

        if ($rate) {
            $status = 1;
        } else {
            $status = 0;
        }

        return $status;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function ready_rate(Request $request, $date = null)
    {


        if ($date) {
            $date = $date;
        } else {
            $date = Carbon::now()->subDays(2);
        }

        $specialty = $request->input('specialty');
        $branch = $request->input('branch');
        $doctor = $request->input('doctor_serc');

        if (!empty($request->input('from'))) {
            $from = $request->input('from');
        } else {
            $from = '';
        }
        if (!empty($request->input('to'))) {
            $to = $request->input('to');
        } else {
            $to = $request->input('from');
        }

        $appointment_notdone = Appointment::whereIn('status', [2, 3, 4, 6])
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->doesnthave('rate')
            ->with(['rate' => function ($q) {
                $q->select('id', 'appointment_id', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'created_at');
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('start_at', 'DESC');

        if ($specialty !== null && $specialty !== "all") {
            $appointment_notdone = $appointment_notdone->where('specialty_id', $specialty);
        }

        if ($branch !== null && $branch !== "all") {
            $appointment_notdone = $appointment_notdone->where('branch_id', $branch);
        }

        if ($doctor !== null && $doctor !== "all") {
            $appointment_notdone = $appointment_notdone->where('doctor_id', $doctor);
        }


        //if there is a paramter with "last15" show the recored with now to 15 days ago
        if ($date === 'last15') {
            $appointment_notdone = $appointment_notdone->whereBetween('start_at', [
                Carbon::now()->subDays(15),
                Carbon::now()->subDays(2)
            ]);
        } else {

            if (!empty($from)) {
                $appointment_notdone = $appointment_notdone->whereBetween('start_at', [
                    $from, $to
                ]);
            } else {
                $appointment_notdone = $appointment_notdone->whereBetween('start_at', [
                    Carbon::now()->subDays(15), Carbon::now()->subDays(2)
                ]);
            }
        }

        $appointment_notdone = $appointment_notdone->get();

        //hide done appointment when there is last15 parameter which means fetch not rated appointments
        if ($date !== 'last15') {
            $appointment_done = Appointment::whereDate('start_at', $date)
                ->with(['patient' => function ($q) {
                    $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                }])
                ->with(['doctor' => function ($q) {
                    $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                }])
                ->with(['creator' => function ($q) {
                    $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
                }])
                ->has('rate')
                ->with(['rate' => function ($q) {
                    $q->select('id', 'appointment_id', 'type', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'cancel_cat_id', 'note', 'saved', 'created_at')
                        ->with(['cancel' => function ($q) {
                            $q->select('id', 'name');
                        }]);
                }])
                ->with(['branch' => function ($q) {
                    $q->select('id', 'name');
                }]);

            if ($specialty !== null && $specialty !== "all") {
                $appointment_notdone = $appointment_notdone->where('specialty_id', $specialty);
            }
            if ($branch !== null && $branch !== "all") {
                $appointment_notdone = $appointment_notdone->where('branch_id', $branch);
            }

            if ($doctor !== null && $doctor !== "all") {
                $appointment_done = $appointment_done->where('doctor_id', $doctor);
            }

            $appointment_done = $appointment_done->paginate(10);
        } else {
            $appointment_done = "";
        }

        $cancel_reasons = Cancel_reason_cat::all();

        $clinicname = prox_sett('clinicname');

        $specialty_cat = Specialty_cat::all();
        $branches = Branch::all();

        $doctors = User::select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'))
            ->whereHas(
                'roles',
                function ($q) {
                    $q->where('name', 'doctor');
                }
            )->get();

        return view('branch/rate_appointment.ready_rate_show', compact('appointment_notdone', 'appointment_done', 'cancel_reasons', 'clinicname', 'specialty_cat', 'branches', 'doctors', 'specialty', 'branch', 'doctor', 'from', 'to'));
    }


    public function cancellation_appointments($date = null)
    {

        if ($date) {
            $month_year_explode = explode('-', $date);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        } else {
            $year = date('Y');
            $month = date('m');
        }

        $appointment_notdone = Appointment::where('status', 6)
            ->whereYear('start_at', '=', $year)
            ->whereMonth('start_at', '=', $month)
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->doesnthave('rate')
            ->with(['rate' => function ($q) {
                $q->select('id', 'appointment_id', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'created_at');
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('start_at', 'DESC');

        if (Auth::user()->branch_id !== 0) {
            $appointment_notdone = $appointment_notdone->where('branch_id', Auth::user()->branch_id);
        }

        $appointment_notdone = $appointment_notdone->get();

        //hide done appointment when there is last15 parameter which means fetch not rated appointments
        $appointment_done = Appointment::whereYear('start_at', '=', $year)
            ->whereMonth('start_at', '=', $month)
            ->where('status', 6)
            ->with(['patient' => function ($q) {
                $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->has('rate')
            ->with(['rate' => function ($q) {
                $q->select('id', 'appointment_id', 'type', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'cancel_cat_id', 'note', 'saved', 'created_at')
                    ->with(['cancel' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }]);

        if (Auth::user()->branch_id !== 0) {
            $appointment_done = $appointment_done->where('branch_id', Auth::user()->branch_id);
        }
        $appointment_done = $appointment_done->paginate(10);


        $cancel_reasons = Cancel_reason_cat::all();

        $clinicname = prox_sett('clinicname');

        return view('branch/rate_appointment.cancellation_appointments', compact('appointment_notdone', 'appointment_done', 'cancel_reasons', 'clinicname'));
    }


    public function index_rate_note($type_saved = null)
    {

        //to get all notes, and saved notes

        $rate_notes = Appointment::with(['patient' => function ($q) {
            $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
        }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])

            ->with(['rate' => function ($q) {
                $q->select('id', 'appointment_id', 'type', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'cancel_cat_id', 'note', 'saved', 'created_at')
                    ->with(['cancel' => function ($q) {
                        $q->select('id', 'name');
                    }]);
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->orderBy('start_at', 'DESC');

        if (Auth::user()->branch_id !== 0) {
            $rate_notes = $rate_notes->where('branch_id', Auth::user()->branch_id);
        }

        if ($type_saved === 'saved') {
            $rate_notes = $rate_notes->whereHas('rate', function ($query) {
                return $query->where('saved', 2);
            });
        } else {
            $rate_notes = $rate_notes->whereHas('rate', function ($query) {
                return $query->whereNotNull('note');
            });
        }

        $rate_notes = $rate_notes->paginate(10);

        return view('branch/rate_appointment.ready_rate_notes', compact('rate_notes', 'type_saved'));
    }

    public function bad_rate(Request $request,$type)
    {

        $bad_rate = Appointment::with(['patient' => function ($q) {
            $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
        }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['rate' => function ($q) {
                $q->select('id', 'appointment_id', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'note', 'saved', 'created_at');
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->whereYear('start_at', date('Y'))
            ->whereIn('status', [2, 3, 4])
            ;

        if (Auth::user()->branch_id !== 0) {
            $bad_rate = $bad_rate->where('branch_id', Auth::user()->branch_id);
        }

        if ($type === 'service') {
            $bad_rate = $bad_rate->whereHas('rate', function ($query) {
                return $query->where('service', '<', 3);
            });
        }

        if ($type === 'doctor') {
            $bad_rate = $bad_rate->whereHas('rate', function ($query) {
                return $query->where('doctor', '<', 3);
            });
        }

        if ($type === 'reception') {
            $bad_rate = $bad_rate->whereHas('rate', function ($query) {
                return $query->where('reception', '<', 3);
            });
        }

        if ($type === 'time') {
            $bad_rate = $bad_rate->whereHas('rate', function ($query) {
                return $query->where('time', '<', 3);
            });
        }

        if ($type === 'cleanliness') {
            $bad_rate = $bad_rate->whereHas('rate', function ($query) {
                return $query->where('cleanliness', '<', 3);
            });
        }
        $orderDirection =  '';
        if ($request->input('order') == 'desc') {
            $orderDirection =  'DESC'; # code...
        }elseif($request->input('order') == 'asc'){
            $orderDirection =  'ASC';
        }
        else{
            $orderDirection =  'DESC';
        }
        $bad_rate = $bad_rate->orderBy(
            AppointmentRate_appointment::select($type)->whereColumn('rate_appointments.appointment_id','appointments.id')->limit(1), $orderDirection
        );

        $bad_rate = $bad_rate->paginate(10);

        return view('branch/rate_appointment.bad_rate', compact('bad_rate'));
    }

    public function app_not_have_rate()
    {

        $rate_notes = Appointment::with(['patient' => function ($q) {
            $q->select('id', 'phone_number', 'avatar', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
        }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['creator' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->whereHas('rate', function ($query) {
                return $query->where('saved', 2);
            })
            ->with(['rate' => function ($q) {
                $q->select('id', 'appointment_id', 'service', 'doctor', 'reception', 'time', 'cleanliness', 'note', 'saved', 'created_at');
            }])
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }]);

        if (Auth::user()->branch_id !== 0) {
            $rate_notes = $rate_notes->where('branch_id', Auth::user()->branch_id);
        }

        $rate_notes = $rate_notes->paginate(10);


        return view('branch/rate_appointment.ready_rate_notes', compact('rate_notes'));
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $branch = Branch::find($id);
        return view('cats/branchcat.edit', compact('branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'address' => 'required',
        ]);

        $branch = Branch::find($id);
        $branch->name = $request->input('name');
        $branch->address = $request->input('address');
        $branch->save();

        return redirect()->route('sett.branchcat.index')
            ->with('success', 'Branch has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function add_lead_note(Request $request, $patient_id)
    {
        $note = Lead_pat_note::create([
            'worker_id' => Auth::id(),
            'patient_id' => $patient_id,
            'note' => $request->input('note'),
            'status' => $request->input('status'),
            'date' => $request->input('date'),
        ]);

        $patient = Patient::find($patient_id);
        $patient->type = $request->input('status');
        $patient->save();

        return redirect()->back()->with('success', 'The rate has been created successfully');
    }
}
