<!---------- Lab results --------->
<div class="col-12">
    <div class="card shadow mb-4">

        <div id="dental_chart_modal" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#dental_chart_modal" data-bs-slide-to="0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#dental_chart_modal" data-bs-slide-to="1"
                    aria-label="Slide 2"></button>
            </div>

            <div class="carousel-inner">

                <!-- Current treatments -->
                <div class="carousel-item active">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('basic.basic') }}</span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#dental_chart_modal" data-bs-slide-to="1" aria-label="Slide 2">
                                {{ __('basic.action') }}</span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#adddxـray">{{ __('patientappo.new lab') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body overflow-scroll align-items-center text-center position-relative px-3">

                        <div class="dental_chart d-flex align-items-center h-100" id="dental_chart">
                            <div class="d-flex flex-column">

                                <div class="d-flex text-center justify-content-evenly mb-1" id="chart_upper_teeth">

                                    @php
                                        $loop_index = 9;
                                    @endphp

                                    @for ($i = 1; $i < 17; $i++)
                                        @if ($i <= 8)
                                            @php
                                                $loop_index -= 1;
                                                $code_loop = 'ul' . $loop_index;
                                            @endphp
                                        @else
                                            @if ($i == 9)
                                                @php
                                                    $loop_index = 0;
                                                @endphp
                                            @endif
                                            @php
                                                $loop_index += 1;
                                                $code_loop = 'ur' . $loop_index;
                                            @endphp
                                        @endif

                                        <div class="chart-upper tooth click_tooth"
                                            data-tooth_code="{{ $code_loop }}">
                                            <div class="upper-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/tooth_t.svg') }}"
                                                    alt="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/hover_tooth_t.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/tooth_implement.svg') }}"
                                                    class="treatment_tooth implantation  @if (in_array('all_teeth', $basic_chart_implantation)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_implantation)) active_dent_db @elseif (in_array($code_loop, $basic_chart_implantation)) active_dent_db @endif"
                                                    alt="">
                                            </div>
                                            <div class="upperview-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/tooth_b.svg') }}"
                                                    alt="" srcset="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/hover_tooth_d.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/nerve_stuffing.svg') }}"
                                                    class="treatment_tooth nerve_stuffing @if (in_array('all_teeth', $basic_chart_nerve_stuffing)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_nerve_stuffing)) active_dent_db @elseif (in_array($code_loop, $basic_chart_nerve_stuffing)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/cosmetic_filler.svg') }}"
                                                    class="treatment_tooth cosmetic_filler @if (in_array('all_teeth', $basic_chart_cosmetic_filler)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_cosmetic_filler)) active_dent_db @elseif (in_array($code_loop, $basic_chart_cosmetic_filler)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/caries.svg') }}"
                                                    class="treatment_tooth caries @if (in_array('all_teeth', $basic_chart_cosmetic_filler)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_caries)) active_dent_db @elseif (in_array($code_loop, $basic_chart_caries)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/missing.svg') }}"
                                                    class="treatment_tooth missing @if (in_array('all_teeth', $basic_chart_missing)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_missing)) active_dent_db @elseif (in_array($code_loop, $basic_chart_missing)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/crown_bridge.svg') }}"
                                                    class="treatment_tooth crown_bridge @if (in_array('all_teeth', $basic_chart_crown_bridge)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_crown_bridge)) active_dent_db @elseif (in_array($code_loop, $basic_chart_crown_bridge)) active_dent_db @endif"
                                                    alt="">
                                            </div>
                                            <div class="dental_chart-num text-gray-400">
                                                {{ $loop_index }}
                                            </div>
                                        </div>
                                    @endfor

                                    <!-- select all upper tooth -->
                                    <div class="d-flex align-items-center justify-content-center">
                                        <button class="btn upper click_tooth" data-tooth_code="upper_jaw">
                                            <img src="{{ URL::asset('img/dental_chart/click_all.svg') }}"
                                                class="w-100" alt="">
                                        </button>
                                    </div>
                                </div>

                                <div class="chartLowerTeeth d-flex text-center justify-content-evenly mt-0 mb-3"
                                    id="chart_lower_teeth">

                                    @php
                                        $loop_index = 9;
                                    @endphp

                                    @for ($i = 1; $i < 17; $i++)
                                        @if ($i <= 8)
                                            @php
                                                $loop_index -= 1;
                                                $code_loop = 'll' . $loop_index;
                                            @endphp
                                        @else
                                            @if ($i == 9)
                                                @php
                                                    $loop_index = 0;
                                                @endphp
                                            @endif
                                            @php
                                                $loop_index += 1;
                                                $code_loop = 'lr' . $loop_index;
                                            @endphp
                                        @endif

                                        <div class="chart-lower tooth click_tooth"
                                            data-tooth_code="{{ $code_loop }}">

                                            <div class="dental_chart-num text-gray-400">
                                                {{ $loop_index }}
                                            </div>

                                            <div class="lowerview-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/tooth_b.svg') }}"
                                                    alt="" srcset="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/hover_tooth_d.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/nerve_stuffing.svg') }}"
                                                    class="treatment_tooth nerve_stuffing @if (in_array('all_teeth', $basic_chart_nerve_stuffing)) active_dent_db @elseif (in_array('lower_jaw', $basic_chart_nerve_stuffing)) active_dent_db @elseif (in_array($code_loop, $basic_chart_nerve_stuffing)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/cosmetic_filler.svg') }}"
                                                    class="treatment_tooth cosmetic_filler @if (in_array('all_teeth', $basic_chart_cosmetic_filler)) active_dent_db @elseif (in_array('lower_jaw', $basic_chart_cosmetic_filler)) active_dent_db @elseif (in_array($code_loop, $basic_chart_cosmetic_filler)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/caries.svg') }}"
                                                    class="treatment_tooth caries @if (in_array('all_teeth', $basic_chart_cosmetic_filler)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_caries)) active_dent_db @elseif (in_array($code_loop, $basic_chart_caries)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/missing.svg') }}"
                                                    class="treatment_tooth missing @if (in_array('all_teeth', $basic_chart_missing)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_missing)) active_dent_db @elseif (in_array($code_loop, $basic_chart_missing)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/crown_bridge.svg') }}"
                                                    class="treatment_tooth crown_bridge @if (in_array('all_teeth', $basic_chart_crown_bridge)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_crown_bridge)) active_dent_db @elseif (in_array($code_loop, $basic_chart_crown_bridge)) active_dent_db @endif"
                                                    alt="">
                                            </div>
                                            <div class="lower-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/tooth_t.svg') }}"
                                                    alt="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/hover_tooth_t.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/tooth_implement.svg') }}"
                                                    class="treatment_tooth implantation @if (in_array('all_teeth', $basic_chart_implantation)) active_dent_db @elseif (in_array('lower_jaw', $basic_chart_implantation)) active_dent_db @elseif (in_array($code_loop, $basic_chart_implantation)) active_dent_db @endif"
                                                    alt="">
                                            </div>

                                        </div>
                                    @endfor

                                    <div class="d-flex align-items-center justify-content-center">
                                        <button class="btn lower click_tooth" data-tooth_code="lower_jaw">
                                            <img src="{{ URL::asset('img/dental_chart/click_all.svg') }}"
                                                class="w-100" alt="">
                                        </button>
                                    </div>

                                </div>
                            </div>

                            <div class="d-flex align-items-center justify-content-center">
                                <button class="btn all click_tooth" data-tooth_code="all_teeth"><img
                                        src="{{ URL::asset('img/dental_chart/click_all.svg') }}"
                                        alt=""></button>
                            </div>
                        </div>

                        {{-- teeth info --}}
                        <table class="table table-borderless mt-4">
                            <thead>
                                <tr class="text-gray-300 text-xxs">
                                    <th scope="col">Tooth</th>
                                    <th scope="col">Surface</th>
                                    <th scope="col">Procedure</th>
                                    <th scope="col">Doctor</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Manage</th>
                                </tr>
                            </thead>
                            <tbody id="table_basic_dental" class="table-light">
                                @foreach ($patient->dental_basic_chart as $item)
                                    <tr id="dental_bas_{{ $item->id }}">

                                        <td class="text-uppercase">
                                            <i class="fas fa-tooth"></i> {{ $item->tooth }}
                                        </td>
                                        <td>
                                            @foreach (json_decode($item->surface, true) as $value)
                                                {{ $value }},
                                            @endforeach
                                        </td>
                                        <td>
                                            {{ $item->service_item->name }}
                                        </td>
                                        <td>
                                            {{ $item->doctor->first_name }}
                                        </td>
                                        <td>
                                            {{ date('d M Y', strtotime($item->created_at)) }}
                                        </td>
                                        <td><span class="text-red me-2 delete_basic_tooth"
                                                data-id="{{ $item->id }}" data-code="{{ $item->tooth }}"
                                                data-main_cat="{{ $item->dent_main_cat->name }}"><i
                                                    class="fas fa-trash clickable-item-pointer"></i></span>
                                            <span class="text-gray-300 clickable-item-pointer me-2 show_dental_note"
                                                data-note="{{ $item->note }}"><i class="fas fa-pen"></i>
                                                Note</span>
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>

                    </div>

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#lab_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>
                </div>

                <!----------- operation comperation start content ----------->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('basic.action') }}</span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#dental_chart_modal" data-bs-slide-to="0" aria-label="Slide 1">
                                {{ __('basic.basic') }}</span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_operation">{{ __('patientappo.new operation') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    <div class="card-body overflow-scroll align-items-center text-center position-relative">

                        <div class="dental_chart d-flex align-items-center h-100" id="dental_chart_a">
                            <div class="d-flex flex-column">

                                <div class="d-flex text-center justify-content-evenly mb-1" id="chart_upper_teeth_a">

                                    @php
                                        $loop_index = 9;
                                    @endphp

                                    @for ($i = 1; $i < 17; $i++)
                                        @if ($i <= 8)
                                            @php
                                                $loop_index -= 1;
                                                $code_loop = 'ul' . $loop_index;
                                            @endphp
                                        @else
                                            @if ($i == 9)
                                                @php
                                                    $loop_index = 0;
                                                @endphp
                                            @endif
                                            @php
                                                $loop_index += 1;
                                                $code_loop = 'ur' . $loop_index;
                                            @endphp
                                        @endif

                                        <div class="chart-upper tooth click_tooth_a"
                                            data-tooth_code_a="{{ $code_loop }}">
                                            <div class="upper-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/tooth_t.svg') }}"
                                                    alt="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/hover_tooth_t.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/tooth_implement.svg') }}"
                                                    class="treatment_tooth implantation  @if (in_array('all_teeth', $basic_chart_implantation_a)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_implantation_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_implantation_a)) active_dent_db @endif"
                                                    alt="">
                                            </div>
                                            <div class="upperview-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/tooth_b.svg') }}"
                                                    alt="" srcset="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/hover_tooth_d.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/nerve_stuffing.svg') }}"
                                                    class="treatment_tooth nerve_stuffing @if (in_array('all_teeth', $basic_chart_nerve_stuffing_a)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_nerve_stuffing_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_nerve_stuffing_a)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/cosmetic_filler.svg') }}"
                                                    class="treatment_tooth cosmetic_filler @if (in_array('all_teeth', $basic_chart_cosmetic_filler_a)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_cosmetic_filler_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_cosmetic_filler_a)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/caries.svg') }}"
                                                    class="treatment_tooth caries @if (in_array('all_teeth', $basic_chart_cosmetic_filler_a)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_caries_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_caries_a)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/missing.svg') }}"
                                                    class="treatment_tooth missing @if (in_array('all_teeth', $basic_chart_missing_a)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_missing_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_missing_a)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/upper/' . $code_loop . '/crown_bridge.svg') }}"
                                                    class="treatment_tooth crown_bridge @if (in_array('all_teeth', $basic_chart_crown_bridge_a)) active_dent_db @elseif (in_array('upper_jaw', $basic_chart_crown_bridge_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_crown_bridge_a)) active_dent_db @endif"
                                                    alt="">
                                            </div>
                                            <div class="dental_chart-num text-gray-400">
                                                {{ $loop_index }}
                                            </div>
                                        </div>
                                    @endfor

                                    <!-- select all upper tooth -->
                                    <div class="d-flex align-items-center justify-content-center">
                                        <button class="btn upper click_tooth_a" data-tooth_code_a="upper_jaw">
                                            <img src="{{ URL::asset('img/dental_chart/click_all.svg') }}"
                                                class="w-100" alt="">
                                        </button>
                                    </div>
                                </div>

                                <div class="chartLowerTeeth d-flex text-center justify-content-evenly mt-0 mb-3"
                                    id="chart_lower_teeth_a">

                                    @php
                                        $loop_index = 9;
                                    @endphp

                                    @for ($i = 1; $i < 17; $i++)
                                        @if ($i <= 8)
                                            @php
                                                $loop_index -= 1;
                                                $code_loop = 'll' . $loop_index;
                                            @endphp
                                        @else
                                            @if ($i == 9)
                                                @php
                                                    $loop_index = 0;
                                                @endphp
                                            @endif
                                            @php
                                                $loop_index += 1;
                                                $code_loop = 'lr' . $loop_index;
                                            @endphp
                                        @endif

                                        <div class="chart-lower tooth click_tooth_a"
                                            data-tooth_code_a="{{ $code_loop }}">

                                            <div class="dental_chart-num text-gray-400">
                                                {{ $loop_index }}
                                            </div>

                                            <div class="lowerview-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/tooth_b.svg') }}"
                                                    alt="" srcset="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/hover_tooth_d.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/nerve_stuffing.svg') }}"
                                                    class="treatment_tooth nerve_stuffing @if (in_array('all_teeth', $basic_chart_nerve_stuffing_a)) active_dent_db @elseif (in_array('lower_jaw', $basic_chart_nerve_stuffing_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_nerve_stuffing_a)) active_dent_db @endif"
                                                    alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/cosmetic_filler.svg') }}"
                                                    class="treatment_tooth cosmetic_filler @if (in_array('all_teeth', $basic_chart_cosmetic_filler_a)) active_dent_db @elseif (in_array('lower_jaw', $basic_chart_cosmetic_filler_a)) active_dent_db @elseif (in_array($code_loop, $basic_chart_cosmetic_filler_a)) active_dent_db @endif"
                                                    alt="">
                                            </div>
                                            <div class="lower-img">
                                                {{-- basic tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/tooth_t.svg') }}"
                                                    alt="">
                                                {{-- treatment tooth --}}
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/hover_tooth_t.svg') }}"
                                                    class="treatment_tooth hover_tooth" alt="">
                                                <img src="{{ URL::asset('img/dental_chart/lower/' . $code_loop . '/tooth_implement.svg') }}"
                                                    class="treatment_tooth implantation @if (in_array('all_teeth', $basic_chart_implantation_a)) active_dent_db @elseif (in_array('lower_jaw', $basic_chart_implantation)) active_dent_db @elseif (in_array($code_loop, $basic_chart_implantation)) active_dent_db @endif"
                                                    alt="">
                                            </div>

                                        </div>
                                    @endfor

                                    <div class="d-flex align-items-center justify-content-center">
                                        <button class="btn lower click_tooth_a" data-tooth_code_a="lower_jaw">
                                            <img src="{{ URL::asset('img/dental_chart/click_all.svg') }}"
                                                class="w-100" alt="">
                                        </button>
                                    </div>

                                </div>
                            </div>

                            <div class="d-flex align-items-center justify-content-center">
                                <button class="btn all click_tooth_a" data-tooth_code_a="all_teeth"><img
                                        src="{{ URL::asset('img/dental_chart/click_all.svg') }}"
                                        alt=""></button>
                            </div>
                        </div>

                        {{-- teeth info --}}
                        <table class="table table-borderless mt-4">
                            <thead>
                                <tr class="text-gray-300 text-xxs">
                                    <th scope="col">Tooth</th>
                                    <th scope="col">Surface</th>
                                    <th scope="col">Procedure</th>
                                    <th scope="col">Doctor</th>
                                    <th scope="col">Amount</th>
                                    <th scope="col">Date</th>
                                    <th scope="col">Manage</th>
                                </tr>
                            </thead>
                            <tbody id="table_basic_dental_action" class="table-light">
                                @foreach ($patient->sessions as $item)
                                    @if ($item->dent_main_cat)
                                        <tr id="dental_bas_a_{{ $item->id }}">

                                            <td class="text-uppercase">
                                                <i class="fas fa-tooth"></i> {{ $item->tooth }}
                                            </td>
                                            <td>
                                                @foreach (json_decode($item->surface, true) as $value)
                                                    {{ $value }},
                                                @endforeach
                                            </td>
                                            <td>
                                                {{ $item->service_item->name }}
                                            </td>
                                            <td>
                                                {{ $item->doctor->first_name }}
                                            </td>
                                            <td>
                                                {{ $item->invoice_item->sold_price }} <small
                                                    class="text-gray-300 text-xxxs">
                                                    {{ __('basic.egp') }}</small>
                                            </td>
                                            <td>
                                                {{ date('d M Y', strtotime($item->created_at)) }}
                                            </td>
                                            <td>
                                                @if ($item->status == 0)
                                                    @php
                                                        $text_color_dent = 'text-gray-300';
                                                        $status_dent = '1';
                                                    @endphp
                                                @else
                                                    @php
                                                        $text_color_dent = 'text-green';
                                                        $status_dent = '0';
                                                    @endphp
                                                @endif
                                                <span class="{{ $text_color_dent }} me-2 status_action_tooth"
                                                    data-id="{{ $item->id }}"><i
                                                        class="fas fa-check clickable-item-pointer"></i></span>
                                                <span class="text-red me-2 delete_action_tooth"
                                                    data-id="{{ $item->id }}" data-code="{{ $item->tooth }}"
                                                    data-main_cat="{{ $item->dent_main_cat->name }}"><i
                                                        class="fas fa-trash clickable-item-pointer"></i></span>
                                                <span
                                                    class="text-gray-300 clickable-item-pointer me-2 show_dental_note"
                                                    data-note="{{ $item->note }}"><i class="fas fa-pen"></i>
                                                    Note</span>
                                            </td>
                                        </tr>
                                    @endif
                                @endforeach

                            </tbody>
                        </table>


                    </div>

                    <!-- Card footer session -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#operations_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal dental insert data -->
    <div class="modal fade" id="myModaloneTooth" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form class="myform" action="#" method="post" style="display: contents">

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-x-ray me-1"></i>
                            {{ __('patientappo.new action') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">


                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('patientappo.main catagory') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-dental-insert select2-hidden-accessible @error('dental_min_cat_id') is-invalid @enderror"
                                    id="dental_min_cat_id" name="dental_min_cat_id" required>
                                    <option value="hover_tooth">- Not Selected -</option>
                                    @foreach ($dental_min_cat as $item)
                                        <option value="{{ $item->name }}">
                                            {{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>

                                <span class="text-danger" id="dental_min_cat_id-ErrorMsg"></span>

                                @error('dental_min_cat_id')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.service') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <select
                                    class="myselect2-dental-insert select2-hidden-accessible @error('dental_service_id') is-invalid @enderror"
                                    id="dental_service_id" name="dental_service_id">
                                    <option>
                                        - chose main cat first -
                                    </option>
                                </select>

                                <span class="text-danger" id="dental_service_id-ErrorMsg"></span>

                                @error('dental_service_id')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.surfaces') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <select
                                    class="myselect2-dental-insert select2-hidden-accessible @error('dental_surfaces') is-invalid @enderror"
                                    id="dental_surfaces" multiple name="dental_surfaces" required>
                                    <option value="all">
                                        All
                                    </option>
                                    <option value="buccal">
                                        Buccal
                                    </option>
                                    <option value="lingual">
                                        Lingual
                                    </option>
                                    <option value="mesial">
                                        Mesial
                                    </option>
                                    <option value="distal">
                                        Distal
                                    </option>
                                    <option value="chewing">
                                        Chewing
                                    </option>
                                </select>

                                <span id="dental_surfaces-error" class="error-msg-form"></span>

                                @error('dental_surfaces')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.note') }}
                                    <small>({{ __('basic.optional') }})</small></label>

                                <textarea name="note_dental" class="form-control @error('note_dental') is-invalid @enderror"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span class="text-danger" id="note_dental-ErrorMsg"></span>

                                @error('note_dental')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror

                            </div>

                            <input name="dental_code" type="hidden" id="dental_code">
                            <input name="patient_id" value="{{ $patient->id }}" type="hidden">
                        </div>

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link"
                                data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color"
                                id="submit_basic_dental">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal dental insert data for action -->
    <div class="modal fade" id="myModaloneTooth_action" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

            <form class="myform" action="#" method="post" style="display: contents">

                <div class="modal-content b-r-s-cont border-0">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-x-ray me-1"></i>
                            {{ __('patientappo.new action') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">


                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('patientappo.main catagory') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-dental-act-insert select2-hidden-accessible @error('dental_min_cat_id_action') is-invalid @enderror"
                                    id="dental_min_cat_id_action" name="dental_min_cat_id_action" required>
                                    <option value="hover_tooth">- Not Selected -</option>
                                    @foreach ($dental_min_cat as $item)
                                        <option value="{{ $item->name }}">
                                            {{ $item->name }}
                                        </option>
                                    @endforeach
                                </select>

                                <span class="text-danger" id="dental_min_cat_id_action-ErrorMsg"></span>

                                @error('dental_min_cat_id_action')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.service') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <select
                                    class="myselect2-dental-act-insert select2-hidden-accessible @error('dental_service_id_action') is-invalid @enderror"
                                    id="dental_service_id_action" name="dental_service_id_action" required>
                                    <option>
                                        - chose main cat first -
                                    </option>
                                </select>

                                <span class="text-danger" id="dental_service_id_action-ErrorMsg"></span>

                                @error('dental_service_id_action')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.surfaces') }}
                                    <small>({{ __('basic.requried') }})</small></label>
                                <select
                                    class="myselect2-dental-act-insert select2-hidden-accessible @error('dental_surfaces_action') is-invalid @enderror"
                                    id="dental_surfaces_action" multiple name="dental_surfaces_action" required>
                                    <option value="all">
                                        All
                                    </option>
                                    <option value="buccal">
                                        Buccal
                                    </option>
                                    <option value="lingual">
                                        Lingual
                                    </option>
                                    <option value="mesial">
                                        Mesial
                                    </option>
                                    <option value="distal">
                                        Distal
                                    </option>
                                    <option value="chewing">
                                        Chewing
                                    </option>
                                </select>

                                <span class="text-danger" id="dental_surfaces_action-ErrorMsg"></span>

                                @error('dental_surfaces')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.note') }}
                                    <small>({{ __('basic.optional') }})</small></label>

                                <textarea name="note_doctor_dental_action"
                                    class="form-control @error('note_doctor_dental_action') is-invalid @enderror"
                                    placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                                <span id="note_doctor_dental_action_error" class="error-msg-form"></span>

                                @error('note_doctor_dental_action')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>


                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.appointment') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-treatment-insert select2-hidden-accessible @error('last_appointment_id_dental') is-invalid @enderror"
                                    id="last_appointment_id_dental" name="last_appointment_id_dental" required>
                                    @foreach ($patient->appointments as $item)
                                        <option value="{{ $item->id }}">
                                            {{ $item->start_at }}
                                        </option>
                                    @endforeach
                                </select>

                                <span class="text-danger" id="last_appointment_id_dental-ErrorMsg"></span>

                                @error('last_appointment_id_dental')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror

                            </div>

                            <input name="dental_code_a" type="hidden" id="dental_code_a">
                            <span class="text-danger" id="dental_code_a-ErrorMsg"></span>

                            <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                            <hr class="my-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.amount') }}
                                    <small>({{ __('basic.required') }})</small></label>

                                <input name="dental_amount_sub" type="text"
                                    class="form-control @error('dental_amount_sub') is-invalid @enderror"
                                    placeholder="Total Session Amount.." required>

                                <span class="text-danger" id="dental_amount_sub-ErrorMsg"></span>

                                @error('dental_amount_sub')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.invoice') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-dental-act-insert-nosearch @error('dental_cat_invoice') is-invalid @enderror"
                                    id="dental_cat_invoice" name="dental_cat_invoice" required>
                                    <option value="new">New Invoice</option>
                                    @foreach ($patient->invoices as $item)
                                        @if ($item->status == 0)
                                            <option value="{{ $item->id }}">
                                                {{ $item->service_inv_cat->name . ' - ' . $item->final_price . 'EGP' }}
                                            </option>
                                        @endif
                                    @endforeach
                                </select>

                                <span class="text-danger" id="dental_cat_invoice-ErrorMsg"></span>

                                @error('dental_cat_invoice')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.invoice note') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <textarea name="inv_note_dental_act" class="form-control" placeholder="Write here your notes .." rows="4"
                                    spellcheck="false"></textarea>

                                <span id="inv_note_dental_act-error" class="error-msg-form"></span>

                                @error('inv_note_dental_act')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                @enderror

                            </div>

                        </div>

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link"
                                data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color"
                                id="submit_basic_dental_action">Add
                                New</button>
                        </div>
                    </div>
                </div>
            </form>

        </div>

    </div>

    <!-- Modal basic dental delete -->
    <div class="modal fade" id="dental_bas_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="#" method="post">

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                Item?</p><br>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link"
                                data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button id="submit_delete_dental_bas" type="submit"
                                class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>


    <!-- Modal basic dental delete -->
    <div class="modal fade" id="dental_action_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="#" method="post">

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                Item?</p><br>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link"
                                data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button id="submit_delete_dental_act" type="submit"
                                class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>


    <!-- Modal for dental note -->
    <div class="modal fade" id="dental_note" tabindex="-1" aria-labelledby="exampleModalLabel2"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2"><i class="fas fa-quote-left me-1"></i>
                        {{ __('basic.doctor note') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">
                    <div class="mb-3">
                        <label class="form-label">{{ __('basic.note') }}
                            <small></small></label>
                        <div name="note" class="form-control" placeholder="Write here your notes .."
                            rows="4" spellcheck="false" id="dental_note_cont"
                            date-text="Write here your notes .."></div>
                    </div>
                </div>

                <div class="modal-footer justify-content-center">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link"
                            data-bs-dismiss="modal">{{ __('basic.never mind') }}</button>
                    </div>
                </div>
            </div>
        </div>

    </div>
