<!-- Examination -->
<div class="col-12 col-lg-4">
    <div class="card shadow mb-4">

        <div id="examin-medc" class="carousel slide curr-treament-info-carousel" data-bs-ride="carousel"
            data-bs-interval="false">

            <div class="carousel-indicators dots-radius-carousel" style="bottom: 34px; margin-bottom: 0px;">
                <button type="button" data-bs-target="#examin-medc" data-bs-slide-to="0" class="active"
                    aria-current="true" aria-label="Slide 1"></button>
                <button type="button" data-bs-target="#examin-medc" data-bs-slide-to="1" aria-label="Slide 1"></button>
            </div>

            <div class="carousel-inner">

                <!-- Current examination -->
                <div class="carousel-item active">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">{{ __('basic.examination')
                                }}</span>
                            <span class="m-0 text-x link-cust-text text-s fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#examin-medc" data-bs-slide-to="1" aria-label="Slide 1">
                                {{ __('basic.investigation') }}</span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer add_exam_modal" data-type="ex">{{
                                    __('patientappo.new examination') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    @if (count($patient->diseases) > 0)
                    <div class="card-body pb-4">
                        <div class="row">
                            <div class="col align-self-center text-center">
                                <svg id="Capa_1" fill="#151515" height="141" width="141" viewBox="0 0 512 512"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="m410.109 441.591-5.948-20.515c-1.808-6.232-6.302-11.185-12.329-13.586-6.029-2.402-12.695-1.898-18.293 1.385-7.104 4.165-14.647 7.412-22.506 9.724-.365-3.277-1.648-6.416-3.785-9.055-2.48-3.064-5.856-5.152-9.602-6.025 1.499-2.772 3.268-8.014 3.256-13.37 0-5.168-1.435-10.007-3.925-14.142 2.389-1.115 4.525-2.765 6.232-4.886 3.339-4.147 4.602-9.511 3.464-14.712l-2.718-12.427 6.442-3.776c10.502-6.156 22.482-9.631 34.647-10.048 6.757-.231 12.907-3.503 16.874-8.978 3.967-5.474 5.162-12.337 3.279-18.829l-4.392-15.145c-1.883-6.493-6.564-11.651-12.845-14.153-6.278-2.502-13.226-1.977-19.058 1.441-6.938 4.067-14.328 7.075-22.049 9.022-.464-2.994-1.686-5.852-3.646-8.286-2.614-3.248-6.233-5.391-10.235-6.177 1.472-2.753 3.211-7.952 3.198-13.257 0-4.92-1.305-9.538-3.578-13.537 2.526-.966 4.788-2.575 6.536-4.751 2.957-3.679 4.072-8.432 3.059-13.04l-3.26-14.833c9.359-4.056 19.621-6.369 29.895-6.705 6.228-.202 11.837-3.166 15.39-8.131 3.393-4.741 4.369-10.636 2.681-16.172l-5.351-17.554c-1.678-5.499-5.771-9.915-11.229-12.115-5.653-2.275-11.933-1.886-17.234 1.069-3.655 2.037-7.459 3.816-11.373 5.343l.481-2.19c1.014-4.609-.102-9.362-3.059-13.041-1.586-1.973-3.597-3.477-5.841-4.464 1.712-2.91 3.746-8.472 3.742-14.23 0-5.946-1.903-11.453-5.124-15.956 1.008-.783 1.938-1.684 2.759-2.704 3.148-3.914 4.336-8.974 3.258-13.881l-4.317-19.649c8.486-3.755 17.488-5.835 26.814-6.155 5.82-.199 11.118-3.018 14.536-7.733 3.419-4.716 4.449-10.629 2.827-16.224l-5.002-17.253c-1.621-5.594-5.654-10.039-11.064-12.195-5.415-2.157-11.398-1.703-16.422 1.242-2.3 1.348-4.669 2.579-7.09 3.702-.345-3.065-1.546-6.001-3.538-8.478-3.148-3.916-7.834-6.161-12.857-6.161h-27.534c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h27.534c.594 0 .963.305 1.168.56.206.256.424.683.297 1.263l-4.854 22.094c-2.236 10.178-2.236 20.936 0 31.113l4.854 22.094c.127.58-.091 1.007-.297 1.263-.205.255-.574.56-1.168.56h-131.618c-.594 0-.963-.305-1.168-.56-.206-.256-.424-.683-.297-1.263l4.854-22.094c2.236-10.178 2.236-20.936 0-31.113l-4.854-22.094c-.127-.58.091-1.007.297-1.263.205-.255.574-.56 1.168-.56h69.02c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-69.02c-5.023 0-9.709 2.245-12.857 6.16-1.992 2.477-3.194 5.413-3.538 8.479-2.42-1.123-4.79-2.354-7.09-3.701-5.023-2.945-11.008-3.399-16.42-1.243-5.41 2.155-9.444 6.6-11.066 12.194l-5.004 17.255c-1.622 5.594-.592 11.507 2.827 16.223 3.418 4.716 8.716 7.534 14.535 7.733 9.326.321 18.329 2.401 26.815 6.156l-4.317 19.649c-1.078 4.907.109 9.967 3.258 13.881.821 1.021 1.75 1.921 2.759 2.704-3.221 4.503-5.124 10.01-5.124 15.956-.043 3.82.992 9.311 3.742 14.23-2.244.987-4.255 2.491-5.841 4.464-2.957 3.679-4.072 8.432-3.059 13.04l.482 2.191c-3.915-1.527-7.719-3.306-11.372-5.342-5.304-2.956-11.586-3.346-17.235-1.069-5.458 2.2-9.551 6.616-11.229 12.117l-5.351 17.55c-1.688 5.538-.712 11.433 2.681 16.173 3.553 4.966 9.163 7.93 15.39 8.132 10.276.336 20.539 2.649 29.895 6.706l-3.26 14.832c-1.014 4.609.102 9.362 3.059 13.041 1.749 2.175 4.01 3.784 6.536 4.751-2.272 4-3.578 8.618-3.578 13.537-.04 3.537.835 8.609 3.198 13.257-4.002.786-7.621 2.929-10.235 6.177-1.96 2.435-3.182 5.293-3.646 8.287-7.721-1.947-15.11-4.956-22.049-9.021-5.831-3.419-12.777-3.944-19.058-1.442s-10.962 7.66-12.845 14.153l-4.392 15.145c-1.883 6.492-.688 13.355 3.279 18.829 3.967 5.475 10.117 8.746 16.874 8.978 12.165.417 24.146 3.892 34.647 10.048l6.442 3.776-2.718 12.427c-1.138 5.201.125 10.564 3.464 14.712 1.707 2.121 3.843 3.771 6.232 4.886-2.49 4.135-3.925 8.973-3.925 14.142-.04 3.57.851 8.69 3.256 13.37-3.747.874-7.122 2.961-9.602 6.025-2.137 2.64-3.42 5.779-3.785 9.057-7.859-2.312-15.402-5.562-22.506-9.727-5.599-3.279-12.267-3.784-18.293-1.384-6.027 2.401-10.521 7.354-12.329 13.586l-5.948 20.515c-1.808 6.231-.661 12.818 3.146 18.072s9.71 8.396 16.196 8.618c14.521.498 28.822 4.645 41.356 11.993l.8.469-2.153 10.114c-1.104 5.189.177 10.531 3.516 14.655 3.338 4.123 8.295 6.488 13.601 6.488h31.329c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-31.329c-1.037 0-1.662-.581-1.942-.927-.28-.347-.719-1.079-.502-2.094l4.996-23.468c1.834-8.616 1.834-17.354 0-25.968l-4.996-23.469c-.217-1.015.222-1.747.502-2.094.28-.346.905-.927 1.942-.927h155.295c1.037 0 1.662.581 1.942.927.28.347.719 1.079.502 2.094l-4.996 23.468c-1.834 8.615-1.834 17.353 0 25.969l4.996 23.468c.217 1.015-.222 1.747-.502 2.094-.28.346-.905.927-1.942.927h-89.005c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h89.005c5.306 0 10.263-2.365 13.601-6.488 3.339-4.124 4.62-9.466 3.516-14.655l-2.153-10.114.801-.469c12.533-7.348 26.834-11.494 41.356-11.992 6.485-.223 12.388-3.364 16.195-8.618s4.954-11.846 3.146-18.077zm-211.51-38.536c-6.2.112-12.668-5.818-12.5-12.906 0-6.893 5.607-12.5 12.5-12.5h50.04c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-66.215c-1.041 0-1.667-.584-1.947-.933-.28-.348-.717-1.084-.494-2.102l4.188-19.148c2.474-11.312 2.474-23.269 0-34.58l-4.188-19.148c-.223-1.018.214-1.754.494-2.102.28-.349.906-.933 1.947-.933h147.152c1.041 0 1.667.584 1.947.933.28.348.717 1.084.494 2.102l-4.188 19.148c-2.474 11.312-2.474 23.269 0 34.58l4.188 19.148c.223 1.018-.214 1.754-.494 2.102-.28.349-.906.933-1.947.933h-45.896c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h29.721c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906zm-7.77-146.852c-.294-6.059 5.26-12.85 12.5-12.906h105.342c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906h-105.342c-6.892 0-12.5-5.607-12.5-12.5zm-5.879-27.906c-.071 0-.239 0-.39-.187s-.114-.351-.099-.421l3.28-14.922c3.444-15.664 3.444-32.223 0-47.886l-3.28-14.924c-.016-.069-.052-.233.099-.42s.318-.187.39-.187h48.433c4.143 0 7.5-3.357 7.5-7.5s-3.357-7.5-7.5-7.5h-30.914c-6.2.112-12.668-5.818-12.5-12.906 0-6.893 5.607-12.5 12.5-12.5h107.063c6.893 0 12.5 5.607 12.5 12.5.294 6.059-5.26 12.85-12.5 12.906h-41.042c-4.143 0-7.5 3.357-7.5 7.5s3.357 7.5 7.5 7.5h58.561c.071 0 .239 0 .39.187s.114.351.099.421l-3.28 14.922c-3.444 15.664-3.444 32.223 0 47.886l3.28 14.924c.016.069.052.233-.099.42s-.318.187-.39.187zm191.538 59.139c1.811-1.061 3.97-1.225 5.92-.447 1.951.777 3.405 2.38 3.99 4.396l4.392 15.145c.585 2.017.214 4.148-1.019 5.85-1.232 1.7-3.144 2.717-5.242 2.788-14.647.503-29.074 4.686-41.72 12.098l-1.624.952c-.485-6.399-.068-12.882 1.298-19.126l2.124-9.708c11.248-2.12 21.952-6.128 31.881-11.948zm-16.104-124.306c1.324-.737 2.9-.829 4.324-.258.724.292 2.011 1.016 2.487 2.577l5.351 17.554c.411 1.347-.062 2.411-.531 3.067-.814 1.138-2.155 1.818-3.682 1.868-10.749.351-21.494 2.535-31.504 6.36-.41-7.307.006-14.668 1.24-21.863 7.784-2.265 15.281-5.384 22.315-9.305zm-7.504-139.253c1.376-.808 2.647-.502 3.283-.248.635.253 1.767.906 2.211 2.438l5.004 17.253c.443 1.531-.164 2.689-.565 3.244-.401.554-1.313 1.491-2.905 1.546-9.723.333-19.158 2.244-28.15 5.678.046-3.922.474-7.839 1.312-11.653l2.232-10.157c6.104-2.116 12.006-4.834 17.578-8.101zm-203.692 22.686c-.401-.555-1.009-1.713-.565-3.243l5.004-17.254c.444-1.531 1.576-2.185 2.212-2.438s1.907-.56 3.282.249c5.571 3.266 11.472 5.979 17.578 8.096l2.233 10.161c.838 3.813 1.266 7.73 1.312 11.653-8.992-3.434-18.427-5.345-28.15-5.679-1.594-.053-2.505-.991-2.906-1.545zm-9.203 139.507c-.47-.656-.942-1.721-.531-3.069l5.351-17.55c.477-1.563 1.764-2.287 2.487-2.579 1.427-.573 3.002-.479 4.325.258 7.031 3.92 14.527 7.039 22.314 9.305 1.234 7.195 1.65 14.556 1.24 21.863-10.01-3.824-20.756-6.008-31.506-6.359-1.524-.05-2.865-.731-3.68-1.869zm-12.514 129.098c-2.099-.072-4.01-1.089-5.242-2.789-1.232-1.701-1.604-3.833-1.019-5.85l4.392-15.145c.585-2.017 2.039-3.619 3.99-4.396 1.95-.778 4.107-.614 5.921.448 9.928 5.819 20.632 9.827 31.88 11.946l2.124 9.709c1.366 6.244 1.783 12.727 1.298 19.126l-1.624-.952c-12.646-7.412-27.073-11.595-41.72-12.097zm-5.723 138.123c-1.828-.063-3.491-.948-4.564-2.43-1.073-1.48-1.396-3.336-.887-5.093l5.948-20.515c.51-1.756 1.776-3.152 3.475-3.829 1.7-.677 3.579-.534 5.155.391 10.177 5.965 21.135 10.294 32.607 12.931l2.751 12.922c1.249 5.864 1.369 11.802.379 17.683-13.798-7.362-29.219-11.524-44.864-12.06zm273.068-2.43c-1.073 1.481-2.736 2.366-4.563 2.43-15.646.536-31.068 4.698-44.865 12.06-.99-5.881-.87-11.819.379-17.684l2.75-12.918c11.474-2.637 22.432-6.968 32.607-12.933 1.576-.925 3.455-1.067 5.155-.391 1.698.677 2.965 2.073 3.475 3.829l5.948 20.515c.511 1.756.188 3.612-.886 5.092z" />
                                </svg>
                            </div>

                            <div class="col">

                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.examination') }}
                                    </h6>
                                    <p class="text-gray-700 text-xs fw-bold">
                                        {{ $patient->diseases[0]->diseasecats->name }}</p>
                                </div>
                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1">
                                        {{ __('patientappo.started on') }}</h6>
                                    <p class="text-gray-700 text-xs fw-bold">
                                        {{ date('d M Y', strtotime($patient->diseases[0]->start)) }}</p>
                                </div>

                                @if ($patient->diseases[0]->status == 0)
                                @php
                                $msg = __('patientappo.still');
                                @endphp
                                @elseif ($patient->diseases[0]->status == 1)
                                @php
                                $msg = __('patientappo.healed');
                                @endphp
                                @endif

                                <div class="col">
                                    <h6 class="text-gray-300 text-xs mb-1">{{ __('basic.status') }}
                                    </h6>
                                    <p class="text-gray-700 text-xs fw-bold">{{ $msg }}</p>
                                </div>

                            </div>
                        </div>
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400 clickable-item-pointer add_exam_modal"
                            data-type="ex">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">You can put your Examination</p>
                        </a>
                    </div>
                    @endif

                    <!-- Card footer -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300 clickable-item-pointer" data-bs-toggle="modal"
                            data-bs-target="#disease_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>

                </div> <!-- end of exmenation item crousel -->


                <!-- Current investigation -->
                <div class="carousel-item">

                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <span class="m-0 fs-6 me-2 fw-bold clickable-item-pointer">
                                {{ __('basic.investigation')
                                }}</span>
                            <span
                                class="m-0 text-x link-cust-text text-s me-2 fw-bold clickable-item-pointer text-gray-200"
                                data-bs-target="#examin-medc" data-bs-slide-to="0" aria-label="Slide 1">
                                {{ __('basic.examination') }}</span>
                        </div>
                        <div class="dropdown no-arrow">
                            <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in"
                                aria-labelledby="dropdownMenuLink">
                                <div class="dropdown-header">Dropdown Header:</div>
                                <a class="dropdown-item clickable-item-pointer" data-bs-toggle="modal"
                                    data-bs-target="#add_investigation">{{ __('basic.add new') }}</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->

                    @if (!$patient->all_investigation->isEmpty())
                    <div id="medicine_card_home" class="card-body align-items-center">

                        @foreach ($patient->all_investigation as $item)
                        {{-- blade-formatter-disable-next-line --}}
                        @break($loop->index === 3)

                        <div class="d-flex justify-content-between align-items-center mb-3">

                            <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                                <i class="fas fa-search me-2 fs-4 mb-0"></i>
                                <div class="text-truncate">
                                    @if($item->cat == 1)
                                    @php
                                    $invest_cat = __('basic.radiology');
                                    @endphp
                                    @else
                                    @php
                                    $invest_cat = __('basic.lab');
                                    @endphp
                                    @endif
                                    <span class="text-gray-400 text-xs">{{ $invest_cat }}</span>
                                    <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                        {{ $item->date }}
                                    </p>
                                </div>
                            </div>
                            <a href="{{ route('sett.investigation_print', [$patient->id, $item->cat ,$item->id]) }}"
                                target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l">{{
                                    __('basic.download')
                                    }}</span>
                            </a>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="card-body align-items-center text-center position-relative">
                        <a class="add-new-item stretched-link link-cust-text text-gray-400" href="#"
                            data-bs-toggle="modal" data-bs-target="#add_investigation">
                            <i class="fas fa-plus-circle fa-sm fa-fw fs-4"></i>
                            <p class="fw-light mb-0">{{ __('basic.new investigation') }}</p>
                        </a>
                    </div>
                    @endif

                    <!-- Card footer medicine -->
                    <div class="card-footer text-center ">
                        <a class="text-xs link-cust-text text-gray-300" href="#" data-bs-toggle="modal"
                            data-bs-target="#investigation_show">
                            <i class="fas fa-chevron-down"></i> {{ __('basic.more') }}
                        </a>
                    </div>

                </div><!-- end of medicens crousel -->

            </div>
        </div> <!-- end of exmeination and medicens col -->

    </div> <!-- end of row -->

    <!----------------- exmeination and medciens modals ----------------->

    <!---------------------------------->

    <!----------------- show all exmeniation ----------------->

    <!-- Modal show all examination -->
    <div class="modal fade" id="disease_show" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                        {{ __('basic.examination') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    <h5 class="mb-3 text-gray-400"><i class="far fa-question-circle"></i>
                        Initial Examination</h5>

                    <div class="d-flex justify-content-center mb-3 flex-wrap">

                        <div class="d-flex justify-content-center flex-wrap me-0 me-md-5 mb-3 mb-xl-0">

                            <div class="mb-3 mb-md-0"
                                style="background-image: url('{{ asset('img/dashboard/system/human_front.jpg') }}'); width:255px; height:457px; position: relative;">
                                @if (!empty($patient->disease_draws[0]->front))
                                <img src="{{ URL::asset('img/diseasedraw/' . $patient->disease_draws[0]->front) }}"
                                    width="255" height="457" style=" solid;position: absolute;top:0;left:0;">
                                @else
                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                    {{ __('patientappo.no back draw') }}
                                </div>
                                @endif
                            </div>

                            <div class="mb-3 mb-md-0"
                                style="background-image: url('{{ asset('img/dashboard/system/human_back.jpg') }}'); width:255px; height:457px; position: relative;">

                                @if (!empty($patient->disease_draws[0]->back))
                                <img src="{{ URL::asset('img/diseasedraw/' . $patient->disease_draws[0]->back) }}"
                                    width="255" height="457" style=" solid;position: absolute;top:0;left:0;">
                                @else
                                <div class="ms-4 text-center main-color-bg text-white p-2 b-r-s-cont"
                                    style=" solid;position: absolute;top:13rem;left:3rem;">
                                    {{ __('patientappo.no front draw') }}
                                </div>
                                @endif
                            </div>

                        </div>

                        <div class="d-flex d-xl-block p-4 main-color-bg b-r-s-cont flex-wrap justify-content-center">
                            <h5 class="mb-3 text-white me-2 me-xl-0"><i class="far fa-question-circle"></i>
                                {{ __('patientappo.last examination info') }}</h5>

                            <div class="">
                                <div class="mb-2 me-3 me-xl-5">
                                    <label class="form-label text-blue-300 mb-1">{{ __('patientappo.examination note')
                                        }}:</label>
                                    <div class="form-control-textarea overflow-auto text-white"
                                        style="width: 241px; border-radius: 13px !important; border: 1px solid #6fa2ea;">
                                        @if (!empty($patient->disease_draws[0]->note))
                                        {{ $patient->disease_draws[0]->note }}
                                        @else
                                        No Note
                                        @endif
                                    </div>
                                </div>
                                <div class="mb-2 me-3 me-xl-5">
                                    <label class="form-label text-blue-300 mb-1">
                                        {{ __('patientappo.appointment date') }}:</label>
                                    <div class="text-white">
                                        @if (!empty($patient->disease_draws[0]->appointment->start_at))
                                        {{ $patient->disease_draws[0]->appointment->start_at }}
                                        @else
                                        {{ __('basic.not selected') }}
                                        @endif
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label class="form-label text-blue-300 mb-1">{{ __('basic.doctor') }}:</label>
                                    <div class="text-white">
                                        @if (!empty($patient->disease_draws[0]->appointment->doctor->name))
                                        {{ $patient->disease_draws[0]->appointment->doctor->name }}
                                        @else
                                        {{ __('basic.not selected') }}
                                        @endif

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if (count($patient->examinations) > 0)

                    @if ($patient->examinations[0]->type == 3)

                    <div class="mx-0 mx-md-5 px-0 px-md-5">
                        <div class="table-responsive">
                            <table class="table display datatable-modal" id="table-examination" width="100%"
                                cellspacing="0">
                                <thead>
                                    <tr>
                                        <th class="text-xs">Name</th>
                                        <th class="text-xs">OD</th>
                                        <th class="text-xs">OS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="fw-bold">LID</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->lid_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->lid_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Surface</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->surface_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->surface_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">A.C</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->ac_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->ac_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Pupil</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->pupil_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->pupil_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Lens</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->lens_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->lens_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Iris</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->iris_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->iris_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Angle</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->angle_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->angle_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Fundus</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->fundus_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->fundus_os }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">Motility</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->motility_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->motility_od }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-bold">IOP</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->iop_od }}</td>
                                        <td class="fw-bold text-uppercase fw-bold text-dark">{{
                                            $patient->examinations[0]->iop_od }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    @endif

                    <hr class="mx-0 mx-md-5 px-0 px-md-5">
                    @endif

                    <div class="mx-0 mx-md-5 px-0 px-md-5">

                        <div class="table-responsive">
                            <table class="table display datatable-modal" id="table-disease" width="100%"
                                cellspacing="0">
                                <thead>
                                    <tr>
                                        <th class="text-xs w-25">{{ __('basic.name') }}
                                        </th>
                                        <th class="text-xs text-center">
                                            {{ __('basic.start') }}</th>
                                        <th class="text-xs text-center">
                                            {{ __('basic.end') }}</th>
                                        <th class="text-xs text-center">
                                            {{ __('basic.status') }}</th>
                                        <th class="text-xs text-center">
                                            {{ __('basic.handle') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($patient->diseases as $item)
                                    @if ($item->status == 0)
                                    @php
                                    $text_color = 'active-color-btn';
                                    $msg = __('patientappo.still');
                                    @endphp
                                    @elseif ($item->status == 1)
                                    @php
                                    $text_color = 'done-color-btn';
                                    $msg = __('patientappo.healed');
                                    @endphp
                                    @endif

                                    <tr>
                                        <td class="w-25">
                                            {{ $item->diseasecats->name }}</td>
                                        <td>{{ $item->start }}</td>
                                        <td class="text-center">{{ $item->end }}
                                        </td>
                                        <td class="text-center"> <span
                                                class="badge rounded-pill {{ $text_color }} badge-padd-l">{{ $msg
                                                }}</span>
                                        </td>

                                        <td class="text-center">
                                            <a data-disease_id="{{ $item->id }}"
                                                data-diseasecats_id="{{ $item->diseasecats->id }}"
                                                data-status_disease="{{ $item->status }}"
                                                data-start="{{ $item->start }}" data-end="{{ $item->end }}"
                                                class="btn btn-sm status-col-link active-color-btn b-r-xs mb-1 disease_edit_click"
                                                title="edit"><i class="fas fa-pencil-alt"></i>
                                                {{ __('basic.edit') }} </a>

                                            <a data-disease_id="{{ $item->id }}"
                                                class="btn btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 disease_delete_click"
                                                title="delete" data-effect="effect-scale"><i class="fas fa-trash"></i>
                                                {{ __('basic.delete') }}
                                            </a>

                                        </td>

                                    </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                            __('basic.never mind') }}</button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="button" class="btn btn-default btn-link main-color">Add
                            New</button>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <!-- Modal examination insert data -->
    <div class="modal fade" id="adddisease" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
            <div class="modal-content b-r-s-cont border-0">

                <form action="{{ route('sett.disease.store') }}" method="post" style="display: contents;">
                    {{ method_field('POST') }}
                    {{ csrf_field() }}

                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><i class="fas fas fa-x-ray me-1"></i>
                            {{ __('patientappo.new examination') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <!-- Modal content -->
                    <div class="modal-body px-4 py-3">

                        <div class="row mb-2 justify-content-center">

                            <div class="col-12 mb-4">
                                <div class="d-flex justify-content-center flex-wrap">

                                    <div class="mb-3 mb-md-0"
                                        style="background-image: url('{{ asset('img/dashboard/system/human_front.jpg') }}'); width:255px; height:457px; position: relative;">

                                        <canvas class="canvas" id="canvas" width="255" height="457"
                                            style=" solid;position: absolute;top:0;left:0;"></canvas>

                                        <div id="canvas-clear" class="btn btn-primary"
                                            style="position: absolute; bottom:40px; left:0px;"><i
                                                class="fas fa-eraser"></i>
                                        </div>

                                        <div id="imgsave" class="btn btn-danger"
                                            style="position: absolute; bottom:0px; left:0px;"><i id="icon_save"
                                                class="fas fa-check"></i>
                                        </div>

                                        <div style="position: absolute; bottom:10px; right:0px;">
                                            <div class="d-flex mb-1">
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#000000"
                                                    style="width:15px;height:15px;background:#000000;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#0cb6ed"
                                                    style="width:15px;height:15px;background:#0cb6ed;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#17c34e"
                                                    style="width:15px;height:15px;background:#17c34e;">
                                                </div>
                                            </div>
                                            <div class="d-flex">
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#dc3545"
                                                    style="width:15px;height:15px;background:#dc3545;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ffd807"
                                                    style="width:15px;height:15px;background:#ffd807;">
                                                </div>
                                                <div class="color-selector-draw me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ff6d00"
                                                    style="width:15px;height:15px;background:#ff6d00;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div
                                        style="background-image: url('{{ asset('img/dashboard/system/human_back.jpg') }}'); width:255px; height:457px; position: relative;">
                                        <canvas class="canvas" id="canvas_b" width="255" height="457"
                                            style=" solid;position: absolute;top:0;left:0;"></canvas>

                                        <div id="canvas-clear_b" class="btn btn-primary"
                                            style="position: absolute; bottom:40px; left:0px;"><i
                                                class="fas fa-eraser"></i>
                                        </div>

                                        <div id="imgsave_b" class="btn btn-danger"
                                            style="position: absolute; bottom:0px; left:0px;"><i id="icon_save_b"
                                                class="fas fa-check"></i>
                                        </div>


                                        <div style="position: absolute; bottom:10px; right:0px;">
                                            <div class="d-flex mb-1">
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#000000"
                                                    style="width:15px;height:15px;background:#000000;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#0cb6ed"
                                                    style="width:15px;height:15px;background:#0cb6ed;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#17c34e"
                                                    style="width:15px;height:15px;background:#17c34e;">
                                                </div>
                                            </div>
                                            <div class="d-flex">
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#dc3545"
                                                    style="width:15px;height:15px;background:#dc3545;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ffd807"
                                                    style="width:15px;height:15px;background:#ffd807;">
                                                </div>
                                                <div class="color-selector-draw_b me-1 clickable-item-pointer rounded-circle"
                                                    data-color="#ff6d00"
                                                    style="width:15px;height:15px;background:#ff6d00;">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <input name="front" id="front_input" type="hidden">
                                <input name="back" id="back_input" type="hidden">
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <label class="form-label">{{ __('basic.disease') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <select
                                    class="myselect2-disease-insert select2-hidden-accessible @error('disease_cat') is-invalid @enderror"
                                    id="disease_cat" multiple="" name="disease_cat[]" style="position: relative">
                                    @foreach ($disease_cat as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->name }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="disease_cat_error" class="error-msg-form"></span>

                                @error('disease_cat')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <input name="examination_type" type="hidden" value="3">

                            <div class="row justify-content-center">

                                <div class="table-responsive">
                                    <table class="table table_border display" width="100%" cellspacing="0">
                                        <thead>
                                            <tr style="background-color: #f7fbff;">
                                                <td class=""></td>
                                                <th class="text-xs text-center">OD</th>
                                                <th class="text-xs text-center">OS</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="fw-bold text-center">Lid</td>
                                                <td class=""><textarea type="text" name="lid_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="lid_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Surface</td>
                                                <td class=""><textarea type="text" name="surface_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="surface_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">A.C</td>
                                                <td class=""><textarea type="text" name="ac_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="ac_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Pupil</td>
                                                <td class=""><textarea type="text" name="pupil_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="pupil_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Lens</td>
                                                <td class=""><textarea type="text" name="lens_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="lens_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Iris</td>
                                                <td class=""><textarea type="text" name="iris_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="iris_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Angle</td>
                                                <td class=""><textarea type="text" name="angle_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="angle_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Fundus</td>
                                                <td class=""><textarea type="text" name="fundus_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="fundus_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Motility</td>
                                                <td class=""><textarea type="text" name="motility_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="motility_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="fw-bold text-center">Iop</td>
                                                <td class=""><textarea type="text" name="iop_od"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                                <td class=""><textarea type="text" name="iop_os"
                                                        class="border-0 w-100"></textarea>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                            </div>

                            <div class="row justify-content-center">

                                <div class="col-12 col-md-8 mb-2">
                                    <label class="form-label">{{ __('basic.start') }}
                                        <small>({{ __('basic.required') }})</small></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                            </div>
                                        </div>
                                        <input name="disease_start" value="{{ date('Y-m-d') }}" type="text"
                                            class="form-control hasdatetimepicker @error('disease_start') is-invalid @enderror"
                                            placeholder="YYYY/MM/DD" required>
                                    </div>
                                    <span id="disease_start_error" class="error-msg-form"></span>

                                    @error('disease_start')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>

                                <div class="col-12 col-md-8 mb-2" id="exam-op-appointment">
                                    <label class="form-label">{{ __('basic.appointment') }}
                                        <small>({{ __('basic.required') }})</small></label>
                                    <select
                                        class="myselect2-disease-insert select2-hidden-accessible @error('last_appointment_id') is-invalid @enderror"
                                        id="last_appointment_id_op_app" name="last_appointment_id">
                                        @foreach ($patient->appointments as $item)
                                        <option value="{{ $item->id }}">
                                            {{ $item->start_at }}
                                        </option>
                                        @endforeach
                                    </select>

                                    <span id="last_appointment_id_error" class="error-msg-form"></span>

                                    @error('last_appointment_id')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror

                                </div>

                                <div class="col-12 col-md-8 mb-2">
                                    <label class="form-label">{{ __('basic.note') }}
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <textarea name="note_diseases" class="form-control "
                                        placeholder="Write here your note .." rows="4" spellcheck="false"></textarea>
                                    <span id="note_diseases_lab_error" class="error-msg-form"></span>
                                </div>

                                <input name="patient_id" value="{{ $patient->id }}" type="hidden">
                                <input name="exam-op-id" value="" type="hidden">
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                New</button>
                        </div>
                    </div>

                </form>

            </div>
        </div>

    </div>

    <!-- Modal examination update data -->
    <div class="modal fade" id="disease_edit" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                        Update Examination</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.disease.update', '21') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <!-- Modal content -->
                    <div class="modal-body px-5 py-3">

                        <div class="row mb-2">

                            <div class="col-12 mb-2">
                                <label class="form-label">Disease
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2-disease-update select2-hidden-accessible @error('disease_cat_update') is-invalid @enderror"
                                    id="disease_cat_update" name="disease_cat_update" required>
                                    @foreach ($disease_cat as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->name }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="disease_cat_update_error" class="error-msg-form"></span>

                                @error('disease_cat_update')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>


                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.status') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <select
                                    class="myselect2_disease select2-hidden-accessible select2-no-search-disease @error('status_medicine_update') is-invalid @enderror"
                                    id="status_disease_update" name="status_disease_update" required>
                                    <option value="0">
                                        {{ __('patientappo.still') }}
                                    </option>
                                    <option value="1">
                                        {{ __('patientappo.healed') }}
                                    </option>
                                </select>

                                <span id="status_disease_update_error" class="error-msg-form"></span>

                                @error('status_disease_update')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.start') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="disease_start_update" type="text"
                                        class="form-control hasdatetimepicker @error('disease_start_update') is-invalid @enderror"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="disease_start_update_error" class="error-msg-form"></span>

                                @error('disease_start_update')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 mb-2">
                                <label class="form-label">{{ __('basic.end') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="disease_end_update" type="text"
                                        class="form-control hasdatetimepicker @error('disease_end_update') is-invalid @enderror"
                                        placeholder="YYYY/MM/DD">
                                </div>

                                @error('disease_end_update')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror

                                <span id="medicine_end_update_error" class="error-msg-form"></span>
                            </div>


                        </div>

                        <input name="disease_id_update" value="" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">{{ __('basic.update')
                                }}</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

    </div>

    <!-- examination Modal delete -->
    <div class="modal fade" id="disease_delete" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        Disease delete</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form action="{{ route('sett.disease.destroy', 'test') }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre
                                you sure you want to delete
                                this
                                examination?</p><br>
                            <input type="hidden" name="disease_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{ __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

    <!---------------------------------->

    <!----------------- show all investigation ----------------->
    <!-- Modal investigation insert data -->
    <div class="modal fade" id="add_investigation" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-search me-1"></i>
                        {{ __('basic.new investigation') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form id="add_new_investigation_modal" class="mb-0" action="{{ route('sett.pat_investigation.store') }}"
                    method="post" style="display: contents">
                    {{ method_field('POST') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4 py-3">

                        <input type="hidden" name="pat_investigation_type" value="3">

                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <span class="text-truncate fw-normal">Radiology Investigation</span>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="radiology_investigation_status" type="checkbox"
                                        value="1" id="radiology_investigation_status"><label
                                        for="radiology_investigation_status" class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                            @error('radiology_investigation_status')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror
                        </div>

                        <div class="row justify-content-center mb-2" id="radiology_investigation_status_cont"
                            style="display: none">


                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">Colored Photo
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_colored_photo"
                                                name="colored_photo_ramad" value="">
                                            <label for="empty_colored_photo">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_colored_photo" name="colored_photo_ramad"
                                                value="od">
                                            <label for="od_colored_photo">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_colored_photo" name="colored_photo_ramad"
                                                value="os">
                                            <label for="os_colored_photo">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_colored_photo" name="colored_photo_ramad"
                                                value="ou">
                                            <label for="ou_colored_photo">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_colored_photo_empty"
                                                name="colored_photo_type_ramad" value="">
                                            <label for="empty_colored_photo_empty">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="fundus_photography" name="colored_photo_type_ramad"
                                                value="fundus photography">
                                            <label for="fundus_photography">Fundus Photography</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="anterior_segment" name="colored_photo_type_ramad"
                                                value="anterior segment">
                                            <label for="anterior_segment">Anterior Segment</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="cd_ratio" name="colored_photo_type_ramad"
                                                value="c/d ratio">
                                            <label for="cd_ratio">C/D Ratio</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">Sonar
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_sonar_ramad" name="sonar_ramad"
                                                value="">
                                            <label for="empty_sonar_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_sonar" name="sonar_ramad" value="od">
                                            <label for="od_sonar">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_sonar" name="sonar_ramad" value="os">
                                            <label for="os_sonar">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_sonar" name="sonar_ramad" value="ou">
                                            <label for="ou_sonar">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">UBM
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_ubm_ramad" name="ubm_ramad" value="">
                                            <label for="empty_ubm_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_ubm" name="ubm_ramad" value="od">
                                            <label for="od_ubm">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_ubm" name="ubm_ramad" value="os">
                                            <label for="os_ubm">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_ubm" name="ubm_ramad" value="ou">
                                            <label for="ou_ubm">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">Biometry (IOL MASTER OPTICAL Biometry)
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_biometry_ramad" name="biometry_ramad"
                                                value="">
                                            <label for="empty_biometry_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_biometry" name="biometry_ramad" value="od">
                                            <label for="od_biometry">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_biometry" name="biometry_ramad" value="os">
                                            <label for="os_biometry">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_biometry" name="biometry_ramad" value="ou">
                                            <label for="ou_biometry">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">Visual Field
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_visual_field_ramad"
                                                name="visual_field_ramad" value="">
                                            <label for="empty_visual_field_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_visual_field" name="visual_field_ramad"
                                                value="od">
                                            <label for="od_visual_field">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_visual_field" name="visual_field_ramad"
                                                value="os">
                                            <label for="os_visual_field">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_visual_field" name="visual_field_ramad"
                                                value="ou">
                                            <label for="ou_visual_field">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">FFA
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_ffa_ramad" name="ffa_ramad" value="">
                                            <label for="empty_ffa_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_ffa" name="ffa_ramad" value="od">
                                            <label for="od_ffa">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_ffa" name="ffa_ramad" value="os">
                                            <label for="os_ffa">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_ffa" name="ffa_ramad" value="ou">
                                            <label for="ou_ffa">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">OCT
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_oct_ramad" name="oct_ramad" value="">
                                            <label for="empty_oct_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_oct" name="oct_ramad" value="od">
                                            <label for="od_oct">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_oct" name="oct_ramad" value="os">
                                            <label for="os_oct">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_oct" name="oct_ramad" value="ou">
                                            <label for="ou_oct">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-3">
                                <hr>
                                <div class="mb-2">
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_oct_type_ramad" name="oct_type_ramad"
                                                value="">
                                            <label for="empty_oct_type_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="macula_swept_souce_oct" name="oct_type_ramad"
                                                value="macula swept souce oct">
                                            <label for="macula_swept_souce_oct">macula swept souce oct</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="anterior_segment_oct" name="oct_type_ramad"
                                                value="anterior segment">
                                            <label for="anterior_segment_oct">Anterior Segment</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="optic_nerve_analysis" name="oct_type_ramad"
                                                value="optic nerve analysis">
                                            <label for="optic_nerve_analysis">Optic Nerve Analysis</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="oct_angiogram" name="oct_type_ramad"
                                                value="oct angiogram">
                                            <label for="oct_angiogram">oct angiogram</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">Pentacam
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_pentacam_ramad" name="pentacam_ramad"
                                                value="">
                                            <label for="empty_pentacam_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_pentacam" name="pentacam_ramad" value="od">
                                            <label for="od_pentacam">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_pentacam" name="pentacam_ramad" value="os">
                                            <label for="os_pentacam">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_pentacam" name="pentacam_ramad" value="ou">
                                            <label for="ou_pentacam">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>

                                <div class="mb-2">
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_pentacam_type_ramad"
                                                name="pentacam_type_ramad" value="">
                                            <label for="empty_pentacam_type_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="corneal_refractive_screening"
                                                name="pentacam_type_ramad" value="corneal refractive screening">
                                            <label for="corneal_refractive_screening">Corneal refractive
                                                screening</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="glaucoma_study" name="pentacam_type_ramad"
                                                value="glaucoma study">
                                            <label for="glaucoma_study">Glaucoma Study</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>


                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">Electro Physiology
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_electro_physiology_ramad"
                                                name="electro_physiology_ramad" value="">
                                            <label for="empty_electro_physiology_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_electro_physiology"
                                                name="electro_physiology_ramad" value="od">
                                            <label for="od_electro_physiology">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_electro_physiology"
                                                name="electro_physiology_ramad" value="os">
                                            <label for="os_electro_physiology">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_electro_physiology"
                                                name="electro_physiology_ramad" value="ou">
                                            <label for="ou_electro_physiology">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_erg_electro_physiology"
                                                name="erg_electro_physiology" value="">
                                            <label for="empty_erg_electro_physiology">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="erg_electro_physiology"
                                                name="erg_electro_physiology" value="erg">
                                            <label for="erg_electro_physiology">ERG</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="vep_electro_physiology"
                                                name="electro_physiology_type_ramad" value="vep">
                                            <label for="vep_electro_physiology">VEP</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="multi_focal_erg"
                                                name="electro_physiology_type_ramad" value="multi-focal erg">
                                            <label for="multi_focal_erg">Multi-focal ERG</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <hr>
                                <div class="mb-2">
                                    <label class="form-label fw-bold">Specular Microscopy
                                        <small>({{ __('basic.optional') }})</small></label>
                                    <div class="d-flex justify-content-between">
                                        <div class="check_custom_index me-3">
                                            <input type="radio" checked id="empty_specular_microscopy_ramad"
                                                name="specular_microscopy_ramad" value="">
                                            <label for="empty_specular_microscopy_ramad">Not Selected</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="od_specular_microscopy"
                                                name="specular_microscopy_ramad" value="od">
                                            <label for="od_specular_microscopy">OD</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="os_specular_microscopy"
                                                name="specular_microscopy_ramad" value="os">
                                            <label for="os_specular_microscopy">OS</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                        <div class="check_custom_index me-3">
                                            <input type="radio" id="ou_specular_microscopy"
                                                name="specular_microscopy_ramad" value="ou">
                                            <label for="ou_specular_microscopy">OU</label>
                                            <div class="check">
                                                <div class="inside"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row mb-0 mx-0">
                            <div class="col-9 fw-bold text-truncate">
                                <span class="text-truncate fw-normal">Lab Investigation</span>
                            </div>
                            <div class="col-3 col-md-3 text-center">
                                <div class="switch-checkbox">
                                    <input class="done_btn" name="lab_investigation_status" type="checkbox" value="1"
                                        id="lab_investigation_status"><label for="lab_investigation_status"
                                        class="ms-auto me-auto">Toggle</label>
                                </div>
                            </div>
                            @error('lab_investigation_status')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror
                        </div>

                        <div class="row justify-content-center mb-2" id="lab_investigation_status_cont"
                            style="display: none">
                            {{-- lab section --}}
                            <div class="col-12 col-md-8 mb-2 mx-0 px-0">
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Complete Blood Count (CBC)</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="cbc_ramad" type="checkbox" value="1"
                                                id="cbc_ramad"><label for="cbc_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('cbc_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Prothrombin Time And Conc
                                            (PT-PC-INR)</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="pt_pc_inr_ramad" type="checkbox" value="1"
                                                id="pt_pc_inr_ramad"><label for="pt_pc_inr_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('pt_pc_inr_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Partial Thromboplastin Time (PTT)</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="ptt_ramad" type="checkbox" value="1"
                                                id="ptt_ramad"><label for="ptt_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('ptt_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Cholesterol / HDL / LDL /
                                            Triglycerides</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="hdlldl_ramad" type="checkbox" value="1"
                                                id="hdlldl_ramad"><label for="hdlldl_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('hdlldl_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Blood Urea</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="blood_urea_ramad" type="checkbox" value="1"
                                                id="blood_urea_ramad"><label for="blood_urea_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('blood_urea_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Serum Creatinine</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="serum_creatinine_ramad" type="checkbox"
                                                value="1" id="serum_creatinine_ramad"><label
                                                for="serum_creatinine_ramad" class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('serum_creatinine_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">SGPT (ALT)</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="sgpt_ramad" type="checkbox" value="1"
                                                id="sgpt_ramad"><label for="sgpt_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('sgpt_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">SGOT (AST)</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="sgot_ramad" type="checkbox" value="1"
                                                id="sgot_ramad"><label for="sgot_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('sgot_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Blood Glucose (Random)</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="blood_glucose_ramad" type="checkbox" value="1"
                                                id="blood_glucose_ramad"><label for="blood_glucose_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('blood_glucose_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">C-Reactive Protein (CRP) Titre</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="c_reactive_ramad" type="checkbox" value="1"
                                                id="c_reactive_ramad"><label for="c_reactive_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('c_reactive_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">HCV Antibody 3rd Generation</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="hcv_antibody_ramad" type="checkbox" value="1"
                                                id="hcv_antibody_ramad"><label for="hcv_antibody_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('hcv_antibody_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">HBs Antigen</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="hbs_ramad" type="checkbox" value="1"
                                                id="hbs_ramad"><label for="hbs_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('hbs_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Aids Test (HIV 1And 2) 3rd
                                            Generation</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="aids_test_ramad" type="checkbox" value="1"
                                                id="aids_test_ramad"><label for="aids_test_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('aids_test_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">HBA1c</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="hba1c_ramad" type="checkbox" value="1"
                                                id="hba1c_ramad"><label for="hba1c_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('hba1c_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                                <div class="row mb-0 mx-0">
                                    <div class="col-9 fw-bold text-truncate">
                                        <span class="text-truncate fw-normal">Urine Analysis</span>
                                    </div>
                                    <div class="col-3 col-md-3 text-center">
                                        <div class="switch-checkbox">
                                            <input class="done_btn" name="urine_analysis_ramad" type="checkbox"
                                                value="1" id="urine_analysis_ramad"><label for="urine_analysis_ramad"
                                                class="ms-auto me-auto">Toggle</label>
                                        </div>
                                    </div>
                                    @error('urine_analysis_ramad')
                                    <span class="error-msg-form">
                                        {{ $message }}
                                    </span>
                                    @enderror
                                </div>
                            </div>
                        </div>


                        <div class="row justify-content-center mb-2">

                            <div class="col-12 col-md-8 mb-2">
                                <label class="form-label">{{ __('basic.date') }}
                                    <small>({{ __('basic.required') }})</small></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text"><i class="bi bi-calendar2-week-fill"></i>
                                        </div>
                                    </div>
                                    <input name="investigation_date" value="{{ date('Y-m-d') }}" type="text"
                                        class="form-control hasdatetimepicker @error('investigation_date') is-invalid @enderror"
                                        placeholder="YYYY/MM/DD" required>
                                </div>
                                <span id="investigation_date" class="error-msg-form"></span>
                                @error('investigation_date')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                            <div class="col-12 col-md-8 mb-2">
                                <label class="form-label">{{ __('basic.note') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <textarea name="note_investigation" class="form-control "
                                    placeholder="Write here your note .." rows="4" spellcheck="false"></textarea>
                                <span id="note_investigation_error" class="error-msg-form"></span>
                            </div>

                            <div class="col-12 col-md-8 mb-4">
                                <label class="form-label">{{ __('basic.appointment') }}
                                    <small>({{ __('basic.optional') }})</small></label>
                                <select
                                    class="myselect2-medicine-insert-nosearch select2-hidden-accessible @error('last_appointment_id_investigation') is-invalid @enderror"
                                    id="last_appointment_id_investigation" name="last_appointment_id_investigation">
                                    @foreach ($patient->appointments as $item)
                                    <option value="{{ $item->id }}">
                                        {{ $item->start_at }}
                                    </option>
                                    @endforeach
                                </select>

                                <span id="last_appointment_id_error" class="error-msg-form"></span>

                                @error('last_appointment_id_investigation')
                                <span class="error-msg-form">
                                    {{ $message }}
                                </span>
                                @enderror
                            </div>

                        </div>

                        <input name="patient_id" value="{{ $patient->id }}" type="hidden">

                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link main-color">Add New</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>

    </div>

    <!-- Modal show all  eyeglasses prescriptions -->
    <div class="modal fade" id="investigation_show" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-search me-1"></i>
                        {{ __('basic.investigations') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-4">

                    @foreach ($patient->all_investigation as $item)
                    <div class="d-flex justify-content-between align-items-center mb-3">

                        <div class="me-1 d-flex align-self-center align-items-center me-2 text-truncate">
                            <i class="fas fa-search me-2 fs-4 mb-0 "></i>

                            <div class="text-truncate">
                                @if($item->cat == 1)
                                @php
                                $invest_cat = __('basic.radiology');
                                @endphp
                                @else
                                @php
                                $invest_cat = __('basic.lab');
                                @endphp
                                @endif
                                <span class="text-gray-400 text-xs">{{ $invest_cat }}</span>
                                <p class="text-s text-truncate text-gray-700 mb-0 fw-bold">
                                    {{ $item->date }}
                                </p>
                            </div>
                        </div>
                        <div>
                            <a data-id="{{ $item->id }}"
                                class="btn rounded-pill btn-sm modal-effect status-col-link cancel-color-btn b-r-xs mb-1 investigation_delete_click"
                                title="delete"><i class="fas fa-trash"></i>
                            </a>
                            <a href="{{ route('sett.investigation_print', [$patient->id, $item->cat,$item->id]) }}"
                                target="_blank">
                                <span class="badge rounded-pill status-col-link main-color-btn badge-padd-l">
                                    {{ __('basic.download') }}</span>
                            </a>
                        </div>

                    </div>
                    @endforeach

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                            __('basic.never mind') }}</button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button id="new_attachment_modal" type="button" class="btn btn-default btn-link main-color">{{
                            __('basic.new attachment')
                            }}</button>
                    </div>
                </div>

            </div>
        </div>

    </div>

    <!-- Modal investatuin delete -->
    <div class="modal fade" id="investigation_delete" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog  modal-dialog-centered modal-dialog-scrollable ">

            <div class="modal-content shadow-lgg b-r-s-cont border-0">

                <div class="modal-header">
                    <div class="modal-title" id="exampleModalLabel"><i class="fas fa-trash me-1"></i>
                        {{ __('basic.delete') }}</div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form class="mb-0" action="{{ route('sett.pat_investigation.destroy', " 123") }}" method="post">
                    {{ method_field('delete') }}
                    {{ csrf_field() }}

                    <!-- Modal content -->
                    <div class="modal-body px-4">

                        <div class="modal-body delete-conf-input text-center py-0">
                            <p class="mb-0">ِAre you sure you want to delete it?</p><br>
                            <input type="hidden" name="investigation_id_delete" value="">
                        </div>
                    </div>

                    <div class="modal-footer">
                        <div class="left-side">
                            <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                        </div>
                        <div class="divider"></div>
                        <div class="right-side">
                            <button type="submit" class="btn btn-default btn-link text-red">{{
                                __('basic.delete') }}
                            </button>
                        </div>

                    </div>
                </form>

            </div>
        </div>
    </div>

</div>