<?php

namespace App\Models\Patient;

use App\Models\Branch\Branch;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pulses_machine_rec extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'pulses_machine_id',
        'doctor_id',
        'beginning',
        'ending',
        'date'
    ];
    
    public $timestamps = false;

    
    public function machine()
    {
        return $this->belongsTo(Pulses_machine::class, 'pulses_machine_id', 'id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id', 'id');
    }
    
}