@extends('layouts.master')

@section('title', 'Statistics | Proxima - Medical Management app')

@section('title-topbar', 'Statistics')


<!-- css insert -->
@section('css')
<link rel="stylesheet" href="https://fastly.jsdelivr.net/npm/swiper/swiper-bundle.min.css" />

<!-- Demo styles -->
<style>
    .swiper-slide {
        text-align: center;
        font-size: 18px;
        background: #fff;

        /* Center slide text vertically */
        display: -webkit-box;
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-box-pack: center;
        -ms-flex-pack: center;
        -webkit-justify-content: center;
        justify-content: center;
        -webkit-box-align: center;
        -ms-flex-align: center;
        -webkit-align-items: center;
        align-items: center;
    }

    .swiper-slide img {
        display: block;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .swiper {
        width: 100%;
        height: 300px;
        margin-left: auto;
        margin-right: auto;
    }

    .swiper-slide {
        background-size: cover;
        background-position: center;
    }

    .mySwiper2,
    .mySwiper_during2,
    .mySwiper_after2 {
        height: 500px;
        width: 100%;
    }

    .mySwiper,
    .mySwiper_during,
    .mySwiper_after {
        height: 20%;
        box-sizing: border-box;
        padding: 10px 0;
    }

    .mySwiper .swiper-slide,
    .mySwiper_during .swiper-slide,
    .mySwiper_after .swiper-slide {
        width: 25%;
        height: 100%;
        opacity: 0.4;
    }

    .mySwiper .swiper-slide-thumb-active,
    .mySwiper_during .swiper-slide-thumb-active,
    .mySwiper_after .swiper-slide-thumb-active {
        opacity: 1;
    }

    .swiper-slide img {
        display: block;
        width: 345px;
        object-fit: contain;
    }
</style>
@endsection

<!-- content insert -->
@section('content')

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-flex align-items-center justify-content-between mb-3">
        <span class="mb-0 me-1">
            <a class="link-cust-text text-gray-200 fw-light" href="{{ url()->previous() }}">Go Back</a>
        </span>
        <div class="d-flex justify-content-center mt-2 mt-md-0">
        </div>
    </div>

    <div class="row">

        <div class="col-12">
            <div class="card card-input shadow mb-3 pb-3">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold text-gray-500"><i class="fas fa-images me-1"></i>
                        {{ __('basic.gallery') }}</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body">

                    <ul class="nav nav-tabs mb-2" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="patient-tab" data-bs-toggle="tab"
                                data-bs-target="#patient" type="button" role="tab" aria-controls="patient"
                                aria-selected="true" class="text-gray-500"><i class="fas fa-x-ray me-1"></i>
                                {{ __('patientappo.pre op') }}</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="country-tab" data-bs-toggle="tab" data-bs-target="#country"
                                type="button" role="tab" aria-controls="country" aria-selected="false"
                                class="main-color"><i class="fas fa-pager me-1"></i>
                                {{ __('patientappo.during op') }}</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                                type="button" role="tab" aria-controls="branches" aria-selected="false"
                                class="main-color"><i class="fas fa-comment-alt me-1"></i>
                                {{ __('patientappo.after op') }}</button>
                        </li>
                    </ul>

                    <div class="tab-content" id="myTabContent">


                        <div class="tab-pane fade show active" id="patient" role="tabpanel" aria-labelledby="patient">

                            <div style="--swiper-navigation-color: #000; --swiper-pagination-color: #fff"
                                class="swiper mySwiper2">
                                <div class="swiper-wrapper">

                                    @foreach ($gallery->gallery as $item)
                                    @if ($item->type == 1)
                                    <div class="swiper-slide">
                                        <img src="{{ URL::asset('img/opgallery/' . $item->img) }}" />
                                    </div>
                                    @endif
                                    @endforeach
                                </div>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                            <div thumbsSlider="" class="swiper mySwiper">
                                <div class="swiper-wrapper">
                                    @foreach ($gallery->gallery as $item)
                                    @if ($item->type == 1)
                                    <div class="swiper-slide">
                                        <img style="width:50px;"
                                            src="{{ URL::asset('img/opgallery/' . $item->img) }}" />
                                    </div>
                                    @endif
                                    @endforeach
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade show" id="country" role="tabpanel" aria-labelledby="country">

                            <div style="--swiper-navigation-color: #000; --swiper-pagination-color: #fff"
                                class="swiper mySwiper_during2">
                                <div class="swiper-wrapper">

                                    @foreach ($gallery->gallery as $item)
                                    @if ($item->type == 2)
                                    <div class="swiper-slide">
                                        <img src="{{ URL::asset('img/opgallery/' . $item->img) }}" />
                                    </div>
                                    @endif
                                    @endforeach
                                </div>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                            <div thumbsSlider="" class="swiper mySwiper_during">
                                <div class="swiper-wrapper">
                                    @foreach ($gallery->gallery as $item)
                                    @if ($item->type == 2)
                                    <div class="swiper-slide">
                                        <img style="width:50px;"
                                            src="{{ URL::asset('img/opgallery/' . $item->img) }}" />
                                    </div>
                                    @endif
                                    @endforeach
                                </div>
                            </div>

                        </div>

                        <div class="tab-pane fade show" id="branches" role="tabpanel" aria-labelledby="branches">

                            <div style="--swiper-navigation-color: #000; --swiper-pagination-color: #fff"
                                class="swiper mySwiper_after2">
                                <div class="swiper-wrapper">

                                    @foreach ($gallery->gallery as $item)
                                    @if ($item->type == 3)
                                    <div class="swiper-slide">
                                        <img src="{{ URL::asset('img/opgallery/' . $item->img) }}" />
                                    </div>
                                    @endif
                                    @endforeach
                                </div>
                                <div class="swiper-button-next"></div>
                                <div class="swiper-button-prev"></div>
                            </div>
                            <div thumbsSlider="" class="swiper mySwiper_after">
                                <div class="swiper-wrapper">
                                    @foreach ($gallery->gallery as $item)
                                    @if ($item->type == 3)
                                    <div class="swiper-slide">
                                        <img style="width:50px;"
                                            src="{{ URL::asset('img/opgallery/' . $item->img) }}" />
                                    </div>
                                    @endif
                                    @endforeach
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>

    @endsection

    <!-- js insert -->
    @section('js')
    <script src="https://fastly.jsdelivr.net/npm/swiper/swiper-bundle.min.js"></script>

    <!-- Initialize Swiper -->
    <script>
        var swiper = new Swiper(".mySwiper", {
                spaceBetween: 10,
                slidesPerView: 4,
                freeMode: true,
                watchSlidesProgress: true,
            });
            var swiper2 = new Swiper(".mySwiper2", {
                spaceBetween: 10,
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                thumbs: {
                    swiper: swiper,
                },
            });

            var swiper_during = new Swiper(".mySwiper_during", {
                spaceBetween: 10,
                slidesPerView: 4,
                freeMode: true,
                watchSlidesProgress: true,
            });
            var swiper2 = new Swiper(".mySwiper_during2", {
                spaceBetween: 10,
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                thumbs: {
                    swiper: swiper_during,
                },
            });

            var swiper_after = new Swiper(".mySwiper_after", {
                spaceBetween: 10,
                slidesPerView: 4,
                freeMode: true,
                watchSlidesProgress: true,
            });
            var swiper2 = new Swiper(".mySwiper_after2", {
                spaceBetween: 10,
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                thumbs: {
                    swiper: swiper_after,
                },
            });
    </script>
    @endsection