<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Controller;
use App\Models\Branch\Appointment;
use App\Models\Branch\Branch;
use App\Models\Branch\Inventory\Inventory_item;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\Invoice_cost_material;
use App\Models\Invoice\Invoice_item;
use App\Models\Invoice\Patient_wallet;
use App\Models\Patient\Medicine;
use App\Models\Patient\Patient;
use App\Models\Patient\Pulse;
use App\Models\Patient\Pulses_machine;
use App\Models\Patient\Pulses_machine_rec;
use App\Models\Patient\Service_item;
use App\Models\Patient\Service_package;
use App\Models\Patient\Session_pat;
use App\Models\Patient\Treatment;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\Rule;

class PulseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $this->validate($request, [
            'pulses_type' => ['required', Rule::in(['0', '1', '2', '3', '4'])],
            'last_appointment_id' => ['required', 'exists:appointments,id'],
            'patient_id' => ['required', 'exists:patients,id'],
            'responsible_doc_pulses' => ['required', 'exists:users,id'],
        ]);

        //sessions
        $appo_branch = Appointment::select('branch_id')->find($request->input('last_appointment_id'));


        //if it is session puleses or session per money
        if ($request->input('pulses_type') == 0 or $request->input('pulses_type') == 1) {

            if ($request->input('pulses_type') == 0) {
                $this->validate($request, [
                    'pulses_serv_item_sess' => ['required', 'exists:service_items,id'],
                ]);

                $service_id = $request->input('pulses_serv_item_sess');
                $service_inv_cat = Service_item::select('id', 'service_inv_cat_id', 'price', 'doctor_comm')->where('id', $service_id)->where('deactivate', 0)->first();
                $price = $service_inv_cat->price;
            } else {
                $service_id = 2;
                $service_inv_cat = Service_item::select('id', 'service_inv_cat_id', 'price', 'doctor_comm')->where('id', 2)
                    ->where('deactivate', 0)->first();
                $price = $service_inv_cat->price * $request->input('used_pulses');
            }

            //if the record has invoice
            if ($request->input('pulses_record') == 0) {
                $status_pulses = 0;
                if ($request->input('pulses_cat_invoice') === 'new') {
                    $invoice = Invoice::create([
                        'code' => "IN" . $this->generateRandomString(6),
                        'service_inv_cat_id' => $service_inv_cat->service_inv_cat_id,
                        'specialty_id' => Auth::user()->specialty_id,
                        'receivable_id' => $request->input('patient_id'),
                        'receivable_type' => "App\Models\Patient\Patient",
                        'branch_id' => $appo_branch->branch_id,
                        'items_price' => $price,
                        'final_price' => $price,
                        'note' => $request->input('invoice_note'),
                    ]);
                    $invoice_id = $invoice->id;
                } elseif ($request->input('pulses_cat_invoice') === 'wallet') {
                } else {
                    $invoice_id = $request->input('pulses_cat_invoice');

                    $invoice = Invoice::find($invoice_id);
                    $invoice->increment('items_price', $price);
                    $invoice->increment('final_price', $price);
                    $invoice->note = $invoice->note . ' ' . $request->input('invoice_note');
                    $invoice->save();
                }
            } else {
                $status_pulses = 1;
            }

            //create pulses for patient
            $pulses = Pulse::create([
                'services_cat_id' => $service_id,
                'pulses_machine_id' => $request->input('machine_id'),
                'appointment_id' => $request->input('last_appointment_id'),
                'patient_id' => $request->input('patient_id'),
                'doctor_id' => $request->input('responsible_doc_pulses'),
                'branch_id' => $appo_branch->branch_id,
                'type' => 0,
                'status' => $status_pulses,
                'fluence' => $request->input('fluence'),
                'spot_size' => $request->input('spot_size'),
                'used_pulses' => $request->input('used_pulses'),
                'date' => $request->input('pulses_date'),
            ]);
            $pulses->pulse_area()->attach($request->input('pulse_area_id'));

            //if the record has invoice
            if ($request->input('pulses_cat_invoice') === 'wallet') {
                $patient = Patient::select('wallet')->find($request->input('patient_id'));
                $wallet_reco = Patient_wallet::create([
                    'type' => 1,
                    'branch_id' => $appo_branch->branch_id,
                    'patient_id' => $request->input('patient_id'),
                    'service_item_id' => $service_id,
                    'balance_before_tran' =>  $patient->wallet,
                    'amount' => $price,
                    'date' => $request->input('pulses_date'),
                    'note' => $request->input('invoice_note'),
                ]);

                $wallet = Patient::find($request->input('patient_id'));
                $wallet->decrement('wallet', $price);
                $wallet->save();
            } else {
                if ($request->input('pulses_record') == 0) {

                    $doctor_comm = $service_inv_cat->doctor_comm / 100 * $service_inv_cat->price;

                    $invoice_item = Invoice_item::create([
                        'invoice_id' => $invoice_id,
                        'itemable_id' => $pulses->id,
                        'itemable_type' => "App\Models\Patient\Pulse",
                        'categorizable_id' => $service_id,
                        'categorizable_type' => "App\Models\Patient\Service_item",
                        'price' => $price,
                        'sold_price' => $price,
                        'doctor_comm' => $doctor_comm,
                    ]);

                    $total_cost = $doctor_comm;

                    //for insert costs to invoice
                    if (count($service_inv_cat->costs) > 0) {
                        foreach ($service_inv_cat->costs as $item) {
                            $invoice_cost = Invoice_cost_material::create([
                                'type' => 1,
                                'invoice_id' => $invoice_id,
                                'invoice_item_id' => $invoice_item->id,
                                'cost_cat_id' => $item->cost_cat_id,
                                'price' => $item->price,
                            ]);
                            $total_cost += $item->price;
                        }
                    }

                    //for insert materials to invoice
                    if (count($service_inv_cat->materials) > 0) {
                        foreach ($service_inv_cat->materials as $item) {
                            $inventory = Inventory_item::select('price')->find($item->inventory_id);
                            $inventory_price = $item->qty * $inventory->price;
                            $invoice_material = Invoice_cost_material::create([
                                'type' => 2,
                                'invoice_id' => $invoice_id,
                                'invoice_item_id' => $invoice_item->id,
                                'inventory_id' => $item->inventory_id,
                                'qty' => $item->qty,
                                'price' => $inventory->price,
                            ]);

                            $total_cost += $inventory_price;
                        }
                    }

                    $invoice = Invoice::find($invoice_id);
                    $invoice->total_cost = $total_cost;
                    $invoice->save();
                }
            }
        }
        //to add session package
        elseif ($request->input('pulses_type') == 2) {

            $this->validate($request, [
                'session_serv_item_package' => ['required', 'exists:service_packages,id'],
            ]);

            $package_id = $request->input('session_serv_item_package');

            $service_inv_cat = Service_package::where('id', $package_id)->first();
            $service_inv_cat->decrement('items_number_left', 1);
            $service_inv_cat->save();

            $patient = Patient::select('id', 'balance')->find($request->input('patient_id'));

            //create sessions for patient
            $pulses = Pulse::create([
                'appointment_id' => $request->input('last_appointment_id'),
                'pulses_machine_id' => $request->input('machine_id'),
                'patient_id' => $request->input('patient_id'),
                'doctor_id' => $request->input('responsible_doc_pulses'),
                'branch_id' => $appo_branch->branch_id,
                'type' => 2,
                'fluence' => $request->input('fluence'),
                'spot_size' => $request->input('spot_size'),
                'balance_before_session' => $patient->balance,
                'used_pulses' => $request->input('used_pulses'),
                'package_id' => $package_id,
                'date' => $request->input('pulses_date'),
            ]);
            $pulses->pulse_area()->attach($request->input('pulse_area_id'));

        }
        //for used pulses from package
        elseif ($request->input('pulses_type') == 3) {
            $patient = Patient::select('id', 'balance')->find($request->input('patient_id'));

            $pulses = Pulse::create([
                'appointment_id' => $request->input('last_appointment_id'),
                'pulses_machine_id' => $request->input('machine_id'),
                'patient_id' => $request->input('patient_id'),
                'doctor_id' => $request->input('responsible_doc_pulses'),
                'branch_id' => $appo_branch->branch_id,
                'type' => 3,
                'fluence' => $request->input('fluence'),
                'spot_size' => $request->input('spot_size'),
                'balance_before_session' => $patient->balance,
                'used_pulses' => $request->input('used_pulses'),
                'date' => $request->input('pulses_date'),
            ]);
            $pulses->pulse_area()->attach($request->input('pulse_area_id'));


            $patient->decrement('balance', $request->input('used_pulses'));
            $patient->save();
        }
        //free session
        elseif ($request->input('pulses_type') == 4) {
            $service_id = 3;
            $service_inv_cat = Service_item::select('id', 'service_inv_cat_id', 'price')->where('id', 3)->where('deactivate', 0)->first();
            $price = $request->input('free_session_price');

            //if the record has invoice
            if ($request->input('pulses_record') == 0) {
                $status_pulses = 0;
                if ($request->input('pulses_cat_invoice') === 'new') {
                    $invoice = Invoice::create([
                        'code' => "IN" . $this->generateRandomString(6),
                        'service_inv_cat_id' => $service_inv_cat->service_inv_cat_id,
                        'specialty_id' => Auth::user()->specialty_id,
                        'receivable_id' => $request->input('patient_id'),
                        'receivable_type' => "App\Models\Patient\Patient",
                        'branch_id' => $appo_branch->branch_id,
                        'items_price' => $price,
                        'final_price' => $price,
                        'note' => $request->input('invoice_note'),
                    ]);
                    $invoice_id = $invoice->id;
                } elseif ($request->input('pulses_cat_invoice') === 'wallet') {
                } else {
                    $invoice_id = $request->input('pulses_cat_invoice');

                    $invoice = Invoice::find($invoice_id);
                    $invoice->increment('items_price', $price);
                    $invoice->increment('final_price', $price);
                    $invoice->note = $invoice->note . ' ' . $request->input('invoice_note');
                    $invoice->save();
                }
            } else {
                $status_pulses = 1;
            }

            //create pulses for patient
            $pulses = Pulse::create([
                'services_cat_id' => $service_id,
                'pulses_machine_id' => $request->input('machine_id'),
                'appointment_id' => $request->input('last_appointment_id'),
                'patient_id' => $request->input('patient_id'),
                'doctor_id' => $request->input('responsible_doc_pulses'),
                'branch_id' => $appo_branch->branch_id,
                'type' => 4,
                'status' => $status_pulses,
                'fluence' => $request->input('fluence'),
                'spot_size' => $request->input('spot_size'),
                'used_pulses' => $request->input('used_pulses'),
                'date' => $request->input('pulses_date'),
            ]);
            $pulses->pulse_area()->attach($request->input('pulse_area_id'));


            if ($request->input('pulses_cat_invoice') === 'wallet') {
                $patient = Patient::select('wallet')->find($request->input('patient_id'));
                $wallet_reco = Patient_wallet::create([
                    'type' => 1,
                    'branch_id' => $appo_branch->branch_id,
                    'patient_id' => $request->input('patient_id'),
                    'service_item_id' => $service_id,
                    'balance_before_tran' =>  $patient->wallet,
                    'amount' => $price,
                    'date' => $request->input('pulses_date'),
                    'note' => $request->input('invoice_note'),
                ]);

                $wallet = Patient::find($request->input('patient_id'));
                $wallet->decrement('wallet', $price);
                $wallet->save();
            } else {
                //if the record has invoice
                if ($request->input('pulses_record') == 0) {
                    $invoice_item = Invoice_item::create([
                        'invoice_id' => $invoice_id,
                        'itemable_id' => $pulses->id,
                        'itemable_type' => "App\Models\Patient\Pulse",
                        'categorizable_id' => $service_id,
                        'categorizable_type' => "App\Models\Patient\Service_item",
                        'price' => $price,
                        'sold_price' => $price,
                    ]);
                }
            }
        }

        session()->flash('success', 'The pulses has been created successfully');
        return redirect()->back();
    }


    public function machine_rec_insert(Request $request)
    {

        $this->validate($request, [
            'machine_id' => ['required', 'exists:pulses_machines,id'],
            'beginning' => ['required'],
            'ending' => ['required'],
        ]);

        $check = Pulses_machine_rec::where('pulses_machine_id', $request->input('machine_id'))->whereDate('date', date('Y-m-d'))->first();

        if ($check) {
            session()->flash('error_delete', 'The machine has been found in the day');
            return redirect()->back();
        } else {
            $pulses = Pulses_machine_rec::create([
                'pulses_machine_id' => $request->input('machine_id'),
                'doctor_id' => Auth::user()->id,
                'beginning' => $request->input('beginning'),
                'ending' => $request->input('ending'),
                'date' => date('Y-m-d'),
            ]);
        }



        session()->flash('success', 'The record has been created successfully');
        return redirect()->back();
    }

    public function machine_rec_edit(Request $request, $id)
    {

        $this->validate($request, [
            'beginning' => ['required'],
            'ending' => ['required'],
        ]);


        $pulses = Pulses_machine_rec::find($id);
        $pulses->beginning = $request->input('beginning');
        $pulses->ending = $request->input('ending');
        $pulses->save();

        session()->flash('success', 'The Record has been updated');
        return redirect()->back();
    }

    public function pulses_machines_ajax($branch_id)
    {
        $machines = Pulses_machine::where('branch_id', $branch_id)->get();
        return $machines;
    }

    public function generateRandomString($length = 20)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    public function pulses_day_st($date = null, $branch = "all")
    {

        if ($date) {
            $date = $date;
        } else {
            $date = date('Y-m-d');
        }

        $branches = Branch::all();

        $machines = Pulses_machine::all();

        $all_pulses = Pulse::whereDate('date', $date)
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with('pulse_area')
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status');
                    }]);
            }])
            ->with(['machine' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['package' => function ($q) {
                $q->with(['service_item' => function ($q) {
                    $q->select('id', 'name');
                }]);
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['patient' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }]);


        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $all_pulses = $all_pulses->where('branch_id', $branch);
            }
        } else {
            $all_pulses = $all_pulses->where('branch_id', Auth::user()->branch_id);
        }

        $all_pulses = $all_pulses->get();


        $branch_pulses = Pulse::select('id', 'branch_id', DB::raw('sum(used_pulses) as total'))
            ->whereDate('date', $date)
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('branch_id')
            ->get();

        $doctor_pulses = Pulse::select('id', 'doctor_id', DB::raw('sum(used_pulses) as total'))
            ->whereDate('date', $date)
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->where('type', '!=', 1)
            ->groupBy('doctor_id');

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $doctor_pulses = $doctor_pulses->where('branch_id', $branch);
            }
        } else {
            $doctor_pulses = $doctor_pulses->where('branch_id', Auth::user()->branch_id);
        }

        $doctor_pulses = $doctor_pulses->get();


        //------
        $machine_recs = Pulses_machine_rec::where('date', $date)
            ->with(['machine' => function ($q) {
                $q->select('id', 'branch_id', 'name')
                    ->with(['branch' => function ($q) {
                        $q->select('id', 'name');
                    }]);;
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }]);


        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $machine_recs = $machine_recs->whereHas('machine', function ($q) use ($branch) {
                    $q->where('branch_id', $branch);
                });
            }
        } else {
            $machine_recs = $machine_recs->whereHas('machine', function ($q) use ($branch) {
                $q->where('branch_id', Auth::user()->branch_id);
            });
        }

        $machine_recs = $machine_recs->get();

        $machine_recs_total_pulses = new Collection();

        foreach ($machine_recs as $item) {

            $machine_pulses = Pulse::select('id', 'pulses_machine_id', DB::raw('sum(used_pulses) as total'))
                ->whereDate('date', $date)
                ->where('pulses_machine_id', $item->pulses_machine_id)
                ->first();

            $machine_recs_total_pulses->push((object)[
                'record' => $item,
                'used' => $machine_pulses->total,
            ]);
        }

        //-----

        $machine_pulses = Pulse::select('id', 'pulses_machine_id', DB::raw('sum(used_pulses) as total'))
            ->whereDate('date', $date)
            ->with(['machine' => function ($q) {
                $q->select('id', 'name');
            }])
            ->where('type', '!=', 1)
            ->groupBy('pulses_machine_id');

        if (Auth::user()->branch_id == 0) {
            if ($branch !== "all") {
                $machine_pulses = $machine_pulses->where('branch_id', $branch);
            }
        } else {
            $machine_pulses = $machine_pulses->where('branch_id', Auth::user()->branch_id);
        }

        $machine_pulses = $machine_pulses->get();

        return view('patient/pulses/daypulses', compact('branches', 'machines', 'date', 'branch', 'all_pulses', 'branch_pulses', 'doctor_pulses', 'machine_recs', 'machine_pulses', 'machine_recs_total_pulses'));
    }

    public function pulses_month_st($date = null, $branch = "all")
    {

        if ($date) {
            $month_year = $date;
            $month_year_explode = explode('-', $month_year);
            $year = $month_year_explode[1];
            $month = $month_year_explode[0];
        } else {
            $year = Carbon::now()->year;
            $month = Carbon::now()->month;
        }

        $branches = Branch::all();

        $all_pulses = Pulse::whereYear('date', $year)
            ->whereMonth('date', $month)
            ->with(['service_item' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->with('pulse_area')
            ->with(['invoice_item' => function ($q) {
                $q->select('id', 'invoice_id', 'itemable_id', 'itemable_type')
                    ->with(['invoice' => function ($q) {
                        $q->select('id', 'code', 'status');
                    }]);
            }])
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->with(['patient' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }]);

        if ($branch !== "all") {
            $all_pulses = $all_pulses->where('branch_id', $branch);
        }

        $all_pulses = $all_pulses->get();


        $branch_pulses = Pulse::select('id', 'branch_id', DB::raw('sum(used_pulses) as total'))
            ->whereYear('date', $year)
            ->whereMonth('date', $month)
            ->with(['branch' => function ($q) {
                $q->select('id', 'name');
            }])
            ->groupBy('branch_id')
            ->get();

        $doctor_pulses = Pulse::select('id', 'doctor_id', DB::raw('sum(used_pulses) as total'))
            ->whereYear('date', $year)
            ->whereMonth('date', $month)
            ->with(['doctor' => function ($q) {
                $q->select('id', DB::raw('CONCAT(first_Name, " ", second_Name) AS name'));
            }])
            ->where('type', '!=', 1)
            ->groupBy('doctor_id');

        if ($branch !== "all") {
            $doctor_pulses = $doctor_pulses->where('branch_id', $branch);
        }

        $doctor_pulses = $doctor_pulses->get();

        return view('patient/pulses/monthpulses', compact('branches', 'date', 'branch', 'all_pulses', 'branch_pulses', 'doctor_pulses'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'pulses_id_update' => ['required', 'exists:pulses,id'],
            'fluence_update' => ['required'],
            'pulse_area_id_update' => ['required', 'exists:pulse_area_cats,id'],
            'spot_size_update' => ['required'],
            'used_pulses_update' => ['required'],
        ]);

        $pulses = Pulse::find($request->input('pulses_id_update'));

        $patient = Patient::select('id', 'balance')->find($pulses->patient_id);
        $patient->increment('balance', $pulses->used_pulses);
        $patient->save();

        $pulses->fluence = $request->input('fluence_update');
        $pulses->spot_size = $request->input('spot_size_update');
        $pulses->used_pulses = $request->input('used_pulses_update');
        $pulses->save();
        $pulses->pulse_area()->sync($request->input('pulse_area_id_update'));


        $patient = Patient::select('id', 'balance')->find($pulses->patient_id);
        $patient->decrement('balance', $request->input('used_pulses_update'));
        $patient->save();

        session()->flash('success', 'The session has been updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $id = $request->input('pulses_id_delete');
        $pulses = Pulse::find($id);

        //if it is pulses from package
        if (in_array($pulses->type, [2, 3])) {
            Pulse::find($id)->delete();
            $patient = Patient::select('id', 'balance')->find($pulses->patient_id);
            //to withdraw pulses balance to the patient balance
            $patient->increment('balance', $pulses->used_pulses);
            $patient->save();
        } else {
            $status = Pulse::whereHas('invoice_item', function ($q) {
                $q->whereHas('invoice', function ($q) {
                    $q->where('status', 0);
                });
            })
                ->find($id);


            $invoice_items = Invoice_item::where('invoice_id', $status->invoice_item->invoice->id)->count();

            //if there is only pulses in the invoice (no other items)
            if ($invoice_items == 1) {
                if (!empty($status)) {
                    Invoice_item::find($status->invoice_item->id)->delete();
                    Invoice::find($status->invoice_item->invoice->id)->delete();
                    Pulse::find($id)->delete();
                    session()->flash('success', 'The session has been deleted');
                    return redirect()->back();
                } else {
                    session()->flash('error_delete', 'The session can not before, it is paid');
                    return redirect()->back();
                }
            } else {
                session()->flash('error_delete', 'there are other items in invoice');
                return redirect()->back();
            }
        }

        session()->flash('success', 'The session has been deleted');
        return redirect()->back();
    }
}
