<?php

namespace App\Http\Controllers\Branch\Cats;

use App\Http\Controllers\Controller;
use App\Models\Patient\Specialty_cat as PatientSpecialty_cat;
use Illuminate\Http\Request;

class Specialty_cat extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $specialty = PatientSpecialty_cat::select('id', 'name')->get();
        return view('cats/specialtycat.index', compact('specialty'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('cats/specialtycat.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:specialty_cats,name',
        ]);
        
        $specialty = PatientSpecialty_cat::create([  
            'name' => $request->input('name'),
        ]);

        return redirect()->route('sett.specialtycat.index')
            ->with('success', 'Specialty has created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $specialty = PatientSpecialty_cat::find($id);
        return view('cats/specialtycat.edit', compact('specialty'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
        ]);

        $specialty = PatientSpecialty_cat::find($id);
        $specialty->name = $request->input('name');
        $specialty->save();

        return redirect()->route('sett.specialtycat.index')
            ->with('success', 'Specialty has updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}