<?php $__env->startSection('title', 'Statistics | Proxima - Medical Management app'); ?>

<?php $__env->startSection('title-topbar', 'Statistics'); ?>

<!-- css insert -->
<?php $__env->startSection('css'); ?>
<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

<!-- tables -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.0.1/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.2/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/autofill/2.3.9/css/autoFill.bootstrap5.min.css">
<link rel="stylesheet"
    href="https://nightly.datatables.net/fixedheader/css/fixedHeader.dataTables.css?_=f0de745b101295e88f1504c17177ff49.css"
    type="text/css" />
<?php $__env->stopSection(); ?>


<?php $__env->startSection('fixedcontent'); ?>

<!-- session successful message -->
<?php if(Session::has('success')): ?>
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300"><?php echo e(Session::get('success')); ?></p>
</div>
<?php endif; ?>

<!-- session successful message -->
<?php if(Session::has('error_delete')): ?>
<div id="flash-msg" class="shadow pt-3" style="background-color:#ff4152;">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-times"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"
                style="color:#ffb4bc"></i></a>
    </div>
    <h3>Can not be deleted</h3>
    <p style="color:#ffb4bc"><?php echo e(Session::get('error_delete')); ?></p>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>


<!-- content insert -->
<?php $__env->startSection('content'); ?>

<div class="container-fluid px-2 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-3">

        <span class="mb-0">
            <a class="link-cust-text text-gray-200 fw-light" href="<?php echo e(route('sett.home')); ?>">Dashboard | </a>
            <a class="text-gray-300">Day pulses</a>
        </span>

        <div class="d-flex justify-content-center mt-2 mt-md-0">

            <?php if(Auth::user()->branch_id == 0): ?>
            <div class="cont-branch-calendar me-2">
                <select id="select-branch-calendar"
                    class="js-example-basic-single select2-no-search select2-hidden-accessible">
                    <?php if(Auth::user()->branch_id == 0): ?>
                    <option value="all">
                        All
                    </option>
                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($item->id); ?>" <?php if($branch==$item->id): ?> selected <?php endif; ?>>
                        <?php echo e($item->name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <option value="<?php echo e(Auth::user()->branch_id); ?>">
                        <?php echo e(Auth::user()->branch->name); ?>

                    </option>
                    <?php endif; ?>
                </select>
            </div>
            <?php endif; ?>

            <div class="calendar-datepicker">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                    </div>
                    <input id="calendar-date-input" type="text" value="<?php echo e($date); ?>"
                        class="form-control hasdatetimepicker " placeholder="YYYY/MM/DD">
                </div>
            </div>
        </div>

    </div>

    <div class="row mb-3">
        <?php if(request()->live_report): ?>
        <ul class="nav nav-tabs nav-tabs-nobg mb-3 justify-content-center border-bottom-0 pe-0" id="myTab"
            role="tablist">
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.livereport')); ?>">
                    <button class="nav-link" id="year_invoice-tab" data-bs-toggle="tab" data-bs-target="#year_invoice"
                        type="button" role="tab" aria-controls="year_invoice" aria-selected="true"
                        class="text-gray-500"><i class="fas fa-cog me-1"></i>
                        Operations</button>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.livereport')); ?>">
                    <button class="nav-link" id="specialty-tab" data-bs-toggle="tab" data-bs-target="#specialty_stat"
                        type="button" role="tab" aria-controls="home" aria-selected="true" class="text-gray-500"><i
                            class="fas fa-users me-1"></i>
                        Workers</button>
                </a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.invo_day_search', '?live_report=true')); ?>">
                    <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                        type="button" role="tab" aria-controls="operation_tab" aria-selected="true"
                        class="text-gray-500"><i class="fas fa-money-check me-1"></i>
                        Accounting</button>
                </a>
            </li>
            <li class="nav-item active" role="presentation">
                <a href="<?php echo e(route('sett.pulses_day_st', '?live_report=true')); ?>">
                    <button class="nav-link" id="branches-tab" data-bs-toggle="tab" data-bs-target="#branches"
                        type="button" role="tab" aria-controls="operation_tab" aria-selected="true"
                        class="text-gray-500"><i class="fas fa-thermometer me-1"></i>
                        Pulses</button>
                </a>
            </li>
        </ul>
        <?php else: ?>
        <ul class="nav nav-tabs nav-tabs-nobg nav-tabs-cat justify-content-center pe-0" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.pulses_day_st')); ?>" class="nav-link active" id="year_invoice-tab">
                    <?php echo e(__('basic.daily st')); ?></a>
            </li>
            <li class="nav-item" role="presentation">
                <a href="<?php echo e(route('sett.pulses_month_st')); ?>" class="nav-link" id="specialty-tab">
                    <?php echo e(__('basic.monthly st')); ?></a>
            </li>
        </ul>
        <?php endif; ?>
    </div>
    <div class="position-relative">
            <div class="dt-buttons btn-group flex-wrap printBtns">
                        <button class="btn btn-table-export no-print me-0 buttons-print buttons-html5 rpt1" tabindex="0"
                        aria-controls="p-lab-table" type="button" onclick="print('totalP')"><span>Print</span></button>
                        <button class="btn btn-table-export no-print me-0 buttons-pdf buttons-html5" tabindex="0"
                        aria-controls="p-lab-table" type="button" onclick="exportPdf('totalP')"><span>PDF</span></button>
            </div>
            <div class="row" id="totalP">

                <div class="col-12 px-0 px-md-2">
                    <div class="card card-input shadow mb-4">
                        <!-- Card Body -->
                        <div class="card-body">
                            <div class="row">

                                <div class="col-12 col-md-6 mb-3 mb-md-0 border-flex">
                                    <div class="chart-pie pt-4 pb-2">
                                        <canvas id="myChart">
                                            <!-- the code and its style is printed from js -->
                                        </canvas>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 text-center align-self-center">
                                    <h6 class="text-gray-400"><?php echo e(__('basic.total pulses')); ?></h6>
                                    <?php
                                    //$profit = $all_pulses->sum('total_paid') - $all_pulses->sum('total_paid');
                                    ?>
                                    <span class="fs-1"><?php echo e($all_pulses->sum('used_pulses')); ?><small
                                            class="text-gray-300 text-xxxs">
                                            ps</small></span>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
    <div class="row">
        <div class="col-12 px-0 px-md-2 mb-4">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-layer-group"></i> Machine records</h6>
                    <h6 data-bs-toggle="modal" data-bs-target="#new_machine_reco"
                        class="m-0 fw-bold main-color clickable-item-pointer"><i class="fas fa-plus"></i> New Record
                    </h6>

                    <!-- Modal for inserting the machines reco -->
                    <div class="modal fade" id="new_machine_reco" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content b-r-s-cont border-0">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-capsules me-1"></i>
                                        <?php echo e(__('basic.add new')); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>

                                <form class="mb-0" action="<?php echo e(route('sett.pul_machine_rec_insert')); ?>" method="post">
                                    <?php echo e(method_field('POST')); ?>

                                    <?php echo e(csrf_field()); ?>


                                    <!-- Modal content -->
                                    <div class="modal-body px-5 py-3">

                                        <div class="row mb-2">
                                            <div class="col-12 mb-2">
                                                <label class="form-label"><?php echo e(__('basic.branch')); ?>

                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>
                                                <select
                                                    class="myselect2-machine-insert select2-hidden-accessible <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="branch_id" name="branch_id" required>

                                                    <?php if(Auth::user()->branch_id == 0): ?>
                                                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($item->id); ?>">
                                                        <?php echo e($item->name); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>
                                                    <option value="<?php echo e(Auth::user()->branch_id); ?>">
                                                        <?php echo e(Auth::user()->branch->name); ?>

                                                    </option>
                                                    <?php endif; ?>

                                                </select>

                                                <span id="branch_appo_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"><?php echo e(__('basic.machine')); ?>

                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                <select
                                                    class="myselect2-machine-insert select2-hidden-accessible <?php $__errorArgs = ['responsible_doc_app'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    id="machine_id" name="machine_id" required>
                                                    <option disabled selected>
                                                        Chose Branch first
                                                    </option>
                                                </select>

                                                <span id="machine_id_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['machine_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"> <?php echo e(__('basic.beginning')); ?>

                                                    <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                <input name="beginning" type="number"
                                                    class="form-control <?php $__errorArgs = ['beginning'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    placeholder="Machine beginning number.." required>

                                                <span id="beginning_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['beginning'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="col-12 mb-2">
                                                <label class="form-label"> <?php echo e(__('basic.ending')); ?>

                                                    <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                                <input name="ending" type="number"
                                                    class="form-control <?php $__errorArgs = ['ending'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    placeholder="Machine ending number.." required>

                                                <span id="ending_error" class="error-msg-form"></span>

                                                <?php $__errorArgs = ['ending'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error-msg-form">
                                                    <?php echo e($message); ?>

                                                </span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="modal-footer">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-default btn-link"
                                                data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit" class="btn btn-default btn-link main-color">Add
                                                New</button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>

                    </div>

                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">
                    <?php if(count($machine_recs_total_pulses) > 0): ?>
                    <?php $__currentLoopData = $machine_recs_total_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row px-0 justify-content-center my-4 border-bottom-gray pb-3">
                        <div class="col-12">
                            <h6 class="text-gray-500 fw-bold text-s2 mb-3 text-center"><i
                                    class="fas fa-pen me-1 link-cust-text text-gray-400 clickable-item-pointer"
                                    data-bs-toggle="modal"
                                    data-bs-target="#edit_machine_reco<?php echo e($item->record->id); ?>"></i>
                                <?php echo e($item->record->machine->name); ?></h6>
                        </div>

                        <!-- Modal for edting the machines reco -->
                        <div class="modal fade" id="edit_machine_reco<?php echo e($item->record->id); ?>" tabindex="-1"
                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                                <div class="modal-content b-r-s-cont border-0">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><i
                                                class="fas fa-capsules me-1"></i>
                                            <?php echo e(__('basic.edit record')); ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                                            aria-label="Close"></button>
                                    </div>

                                    <form class="mb-0"
                                        action="<?php echo e(route('sett.pul_machine_rec_edit', $item->record->id)); ?>"
                                        method="post">
                                        <?php echo e(method_field('PATCH')); ?>

                                        <?php echo e(csrf_field()); ?>


                                        <!-- Modal content -->
                                        <div class="modal-body px-5 py-3">

                                            <div class="row mb-2">

                                                <div class="col-12 mb-2">
                                                    <label class="form-label">
                                                        <?php echo e(__('basic.beginning')); ?>

                                                        <small>(<?php echo e(__('basic.required')); ?>)</small></label>

                                                    <input name="beginning" type="number"
                                                        class="form-control <?php $__errorArgs = ['beginning'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Machine beginning number.."
                                                        value="<?php echo e($item->record->beginning); ?>" required>

                                                    <span id="beginning_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['beginning'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>

                                                <div class="col-12 mb-2">
                                                    <label class="form-label"> <?php echo e(__('basic.ending')); ?>

                                                        <small>(<?php echo e(__('basic.optional')); ?>)</small></label>

                                                    <input name="ending" type="number"
                                                        class="form-control <?php $__errorArgs = ['ending'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        placeholder="Machine ending number.."
                                                        value="<?php echo e($item->record->ending); ?>" required>

                                                    <span id="ending_error" class="error-msg-form"></span>

                                                    <?php $__errorArgs = ['ending'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="error-msg-form">
                                                        <?php echo e($message); ?>

                                                    </span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>

                                        </div>

                                        <div class="modal-footer">
                                            <div class="left-side">
                                                <button type="button" class="btn btn-default btn-link"
                                                    data-bs-dismiss="modal"><?php echo e(__('basic.never mind')); ?></button>
                                            </div>
                                            <div class="divider"></div>
                                            <div class="right-side">
                                                <button type="submit" class="btn btn-default btn-link main-color">Add
                                                    New</button>
                                            </div>
                                        </div>
                                    </form>

                                </div>
                            </div>

                        </div>

                        <div class="col-4 col-md-2 align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">branch</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center">
                                <?php echo e($item->record->machine->branch->name); ?>

                            </p>
                        </div>

                        <div class="col-4 col-md-2 align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">Doctor</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center text-truncate">
                                <?php echo e($item->record->doctor->name); ?></p>
                        </div>

                        <div class="col-4 col-md-1 align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">Beginning</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center text-truncate">
                                <?php echo e($item->record->beginning); ?> <small class="text-gray-300 text-xxxs">ps</small>
                            </p>
                        </div>

                        <div class="col-4 col-md-1 text-center align-self-center">
                            <h6 class="text-gray-300 text-xs mb-1 text-center">Ending</h6>
                            <p id="branch_final_info" class="text-gray-600 text-s text-center text-truncate">
                                <?php echo e($item->record->ending); ?> <small class="text-gray-300 text-xxxs">ps</small>
                            </p>
                            </a>
                        </div>

                        <div class="col-4 col-md-2 text-center align-self-center">
                            <div class="main-color-bg text-center text-white b-r-s-cont p-2"> Total</h6>
                                <p id="addre_final_info" class="text-white fs-5 fw-bold mb-0">
                                    <?php
                                    $total_machin = $item->record->ending - $item->record->beginning;
                                    ?>
                                    <?php echo e($total_machin); ?> <small class="text-xxxs text-blue-300"> ps</small>
                                </p>
                            </div>
                        </div>

                        <div class="col-4 col-md-2 text-center align-self-center">
                            <div class="main-color-bg text-center text-white b-r-s-cont p-2"> Used</h6>
                                <p id="addre_final_info" class="text-white fs-5 fw-bold mb-0">
                                    <?php echo e($item->used); ?> <small class="text-xxxs text-blue-300"> ps</small>
                                </p>
                            </div>
                        </div>

                        <?php if($item->used == $total_machin): ?>
                        <?php
                        $total_machin_color = 'done-color-btn';
                        ?>
                        <?php else: ?>
                        <?php
                        $total_machin_color = 'cancel-color-btn';
                        ?>
                        <?php endif; ?>

                        <div class="col-4 col-md-2 text-center align-self-center">
                            <div class="<?php echo e($total_machin_color); ?> text-center b-r-s-cont p-2"> Difference
                                </h6>
                                <p id="addre_final_info" class="fs-5 fw-bold mb-0">
                                    <?php echo e($item->used - $total_machin); ?> <small class="text-xxxs">
                                        ps</small>
                                </p>
                            </div>
                        </div>

                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                    <div class="text-center">
                        <i class="bi bi-brightness-alt-high-fill fa-sm fa-fw fs-2"></i>
                        <p class="fw-light mb-0">Nothing to show</p>
                    </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>


    <div class="row mb-4">

        <div class="col-12 col-md-12 mb-4 mb-md-0">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All machine pulses today
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-machine-totals-cat" width="100%"
                            cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs text-center">Name</th>
                                    <th class="text-xs text-center">Total</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                    <th width="50%" class="text-center fw-bold text-s2">
                                        <?php echo e($all_pulses->sum('used_pulses')); ?> <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                <?php $__currentLoopData = $machine_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center text-truncate">
                                        <?php echo e($item->machine->name); ?>

                                    </td>

                                    <td class="text-center">
                                        <?php echo e($item->total); ?> <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
        <div class="position-relative">
            <div class="dt-buttons btn-group flex-wrap printBtns">
                        <button class="btn btn-table-export no-print me-0 buttons-print buttons-html5 rpt1" tabindex="0"
                        aria-controls="p-lab-table" type="button" onclick="print('totalM')"><span>Print</span></button>
                        <button class="btn btn-table-export no-print me-0 buttons-pdf buttons-html5" tabindex="0"
                        aria-controls="p-lab-table" type="button" onclick="exportPdf('totalM')"><span>PDF</span></button>
            </div>
            <div class="col-12 col-md-12" id="totalM">
                <div class="card card-input shadow h-100">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All Machine pulses today
                            chart
                        </h6>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body overflow-scroll">
                        <h5 class="text-center text-gray-300"> Machine pulses chart</h5>
                        <div class="chart-pie px-1">
                            <canvas id="myChart-machine">
                                <!-- the code and its style is printed from js -->
                            </canvas>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12 px-0 px-md-2 mb-4">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All Pulses</h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-income-all" width="100%" cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs"><?php echo e(__('basic.date')); ?></th>
                                    <th class="text-xs text-center">
                                        <?php echo e(__('basic.type')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.name')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.patient')); ?></th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.machine')); ?>

                                    </th>
                                    <th class="text-xs text-center"><?php echo e(__('basic.doctor')); ?>

                                    </th>
                                    <th class="text-xs text-center"><?php echo e(__('patientappo.pay status')); ?>

                                    </th>
                                    <th class="text-xs"><?php echo e(__('basic.fluence')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.pulse area')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.spot size')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.balance before session')); ?>

                                    </th>
                                    <th class="text-xs"><?php echo e(__('basic.used pulses')); ?></th>
                                    <th class="text-xs"><?php echo e(__('basic.package')); ?></th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th class="text-center fw-bold text-s">TOTAL</th>
                                    <th class="text-center fw-bold text-s2">
                                        <?php echo e($all_pulses->sum('used_pulses')); ?> <small
                                            class="text-gray-300 text-xxxs">ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                <?php $__currentLoopData = $all_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($item->type == 0): ?>
                                <?php
                                $text_color = 'active-color-btn';
                                $msg = __('patientappo.session');
                                ?>
                                <?php elseif($item->type == 1): ?>
                                <?php
                                $text_color = 'done-color-btn';
                                $msg = __('basic.money per pulse');
                                ?>
                                <?php elseif($item->type == 2): ?>
                                <?php
                                $text_color = 'prog-color-btn';
                                $msg = __('basic.session package');
                                ?>
                                <?php elseif($item->type == 3): ?>
                                <?php
                                $text_color = 'not_accepted-color-btn';
                                $msg = __('basic.pulses package');
                                ?>
                                <?php elseif($item->type == 4): ?>
                                <?php
                                $text_color = 'pend-color-btn';
                                $msg = __('basic.free session');
                                ?>
                                <?php endif; ?>

                                <?php if($item->invoice_item): ?>
                                <?php if($item->invoice_item->invoice->status == 0): ?>
                                <?php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.not paid');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 1): ?>
                                <?php
                                $text_color_invoice = 'pend-color-btn';
                                $msg_invoice = __('basic.pending');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 2): ?>
                                <?php
                                $text_color_invoice = 'prog-color-btn';
                                $msg_invoice = __('basic.installment');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 3): ?>
                                <?php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.paid');
                                ?>
                                <?php elseif($item->invoice_item->invoice->status == 4): ?>
                                <?php
                                $text_color_invoice = 'cancel-color-btn';
                                $msg_invoice = __('basic.refund');
                                ?>
                                <?php endif; ?>
                                <?php
                                $invoice_url = 'href=' . route("sett.invoice.show", $item->invoice_item->invoice->id);
                                ?>
                                <?php else: ?>
                                <?php
                                $text_color_invoice = 'done-color-btn';
                                $msg_invoice = __('basic.from package');
                                $invoice_url = '';
                                ?>
                                <?php endif; ?>

                                <tr>
                                    <td><?php echo e(date('d M Y', strtotime($item->date))); ?></td>
                                    <td class="text-center"> <span
                                            class="badge rounded-pill <?php echo e($text_color); ?> badge-padd-l"><?php echo e($msg); ?></span>
                                    </td>
                                    <td>
                                        <?php if($item->service_item): ?>
                                        <?php echo e($item->service_item->name); ?>

                                        <?php else: ?>
                                        Taken from package
                                        <?php endif; ?>
                                    </td>

                                    <td><a class="text-center text-gray-500"
                                            href="<?php echo e(route('sett.patient.show', $item->patient->id)); ?>">
                                            <?php echo e($item->patient->name); ?></a></td>

                                    <td class="text-center">
                                        <?php echo e($item->machine->name); ?>

                                    </td>


                                    <td class="text-center">
                                        <?php echo e($item->doctor->name); ?>

                                    </td>

                                    <td class="text-center"> <a <?php echo e($invoice_url); ?>><span
                                                class="badge rounded-pill <?php echo e($text_color_invoice); ?> badge-padd-l"><?php echo e($msg_invoice); ?></span></a>
                                    </td>

                                    <td class="text-center">
                                        <?php echo e($item->fluence); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php if($item->pulse_area): ?>
                                            <?php $__currentLoopData = $item->pulse_area; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pulse_area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($pulse_area->name .','); ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->spot_size); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->balance_before_session); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php echo e($item->used_pulses); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php if($item->package): ?>
                                        <?php echo e($item->package->service_item->name); ?>

                                        <?php echo e($item->package->date); ?>

                                        <?php else: ?>
                                        No package
                                        <?php endif; ?>
                                    </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>


                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">

        <div class="col-12 col-md-12 mb-4 mb-md-0">
            <div class="card card-input shadow h-100">
                <!-- Card Header - Dropdown -->
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All doctor pulses today
                    </h6>
                </div>

                <!-- Card Body -->
                <div class="card-body overflow-scroll">

                    <div class="table-responsive">
                        <table class="table display datatable-modal" id="table-income-totals-cat" width="100%"
                            cellspacing="0">
                            <thead>
                                <tr>
                                    <th class="text-xs text-center">Name</th>
                                    <th class="text-xs text-center">Total</th>
                                </tr>
                            </thead>

                            <tfoot>
                                <tr>
                                    <th width="50%" class="text-center fw-bold text-s">TOTAL</th>
                                    <th width="50%" class="text-center fw-bold text-s2">
                                        <?php echo e($all_pulses->sum('used_pulses')); ?> <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </th>
                                </tr>
                            </tfoot>

                            <tbody>
                                <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center text-truncate">
                                        <?php echo e($item->doctor->name); ?>

                                    </td>

                                    <td class="text-center">
                                        <?php echo e($item->total); ?> <small class="text-gray-300 text-xxxs">
                                            ps</small>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
        <div class="position-relative">
            <div class="dt-buttons btn-group flex-wrap printBtns">
                        <button class="btn btn-table-export no-print me-0 buttons-print buttons-html5 rpt1" tabindex="0"
                        aria-controls="p-lab-table" type="button" onclick="print('totalDP')"><span>Print</span></button>
                        <button class="btn btn-table-export no-print me-0 buttons-pdf buttons-html5" tabindex="0"
                        aria-controls="p-lab-table" type="button" onclick="exportPdf('totalDP')"><span>PDF</span></button>
            </div>
            <div class="col-12 col-md-12" id="totalDP">
                <div class="card card-input shadow h-100">
                    <!-- Card Header - Dropdown -->
                    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                        <h6 class="m-0 fw-bold"><i class="fas fa-money-check"></i> All doctor pulses today
                            chart
                        </h6>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body overflow-scroll">
                        <h5 class="text-center text-gray-300"> Doctor pulses chart</h5>
                        <div class="chart-pie px-1">
                            <canvas id="myChart-doctor">
                                <!-- the code and its style is printed from js -->
                            </canvas>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php $__env->stopSection(); ?>

    <!-- js insert -->
    <?php $__env->startSection('js'); ?>
    <script>
        function print(element) {
            printJS( element , 'html')
        }
        function exportPdf(element) {
            var Pelement = document.getElementById(element);
                    var opt = {
                    margin:       1,
                    filename:     'report.pdf',
                    image:        { type: 'jpeg', quality: 0.98 },
                    html2canvas:  { scale: 2 ,scrollY: 0,scrollX: 0},
                    jsPDF:        { unit: 'in', format: 'a1', orientation: 'p' }
                    };
                    html2pdf().set(opt).from(Pelement).save();
        }
    </script>

    <!-- select 2 -->
    <script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.js-example-basic-single').select2();
            //hide search
            $('.select2-no-search').select2({
                minimumResultsForSearch: -1
            });
        });
        $(".myselect2-machine-insert").select2({
            dropdownParent: $("#new_machine_reco")
        });

        //hide search
        $('.myselect2-machine-insert-nosearch').select2({
            dropdownParent: $("#new_machine_reco")
            , minimumResultsForSearch: -1
        });

    </script>

    <script>
        $(document).ready(function() {

            fetchMachine();

            function fetchMachine(branch_id = $('select[name="branch_id"]').val()) {
                var url = "<?php echo e(route('sett.pulses_machines_ajax', ':id')); ?>";
                url = url.replace(':id', branch_id);

                $.ajax({
                    url: url
                    , type: "GET"
                    , dataType: "json"
                    , success: function(data) {
                        $('select[name="machine_id"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="machine_id"]').append(
                                '<option value="' +
                                value.id + '">' + value.name + '</option>');
                        });
                    }
                });
            }

            //for gettomg machines depnds on branch ajax
            $('select[name="branch_id"]').on('change', function(e) {
                e.preventDefault();
                var branch_id = $(this).val();

                fetchMachine(branch_id)
            });

            //--------------------- selectors -------------------
            $(document).on('change', '#select-specialty-calendar, #select-branch-calendar', function() {
                var date_input = $('#calendar-date-input').val();
                var date = $('#select-branch-calendar').val();

                var url = "<?php echo e(route('sett.pulses_day_st', [':date_input', ':date'])); ?>";

                url = url.replace(':date_input', date_input).replace(':date', date);

                var url = url;
                window.location.href = url;
            });
            $(document).on('change', '#calendar-date-input', function() {
                var date_input = $('#calendar-date-input').val();
                var date = $('#select-branch-calendar').val();

                var url = "<?php echo e(route('sett.pulses_day_st', [':date_input', ':date'])); ?>";

                url = url.replace(':date_input', date_input).replace(':date', date)

                window.location.href = url;
            });
        });

    </script>

    <!-- jquery ui datepicker -->
    <script type="text/javascript"
        src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>

    <script>
        $(function() {
            $('.hasdatetimepicker').datepicker({
                todayHighlight: true
                , format: "yyyy-mm-dd"
            , });
        });

    </script>

    <!-- -- Chart.js plugin -- -->
    <script src="https://fastly.jsdelivr.net/npm/chart.js"></script>

    <?php
    $chart_color = ['#1a78f1', '#38dfa8', '#d13c62', '#12c7d9', '#03c2c3', '#5035df', '#17a673', '#2e59d9', '#9aeded',
    '#f3d56a', '#7c859d', '#a4adc5', '#80142f', '#33d293', '#bed233', '#3958e9', '#10c86f', '#654fb6', '#a44fb6',
    '#89728e', '#c85110', '#6d769d', '#1b6954', '#204494', '#94206b', '#948320', '#209493', '#292094', '#203a65',
    '#4e6fa5', '#e29031', '#e23168', '#31e0e2', '#e29131', '#319fe2', '#8131e2', '#31a8e2', '#31e2c0', '#31c3e2',
    '#e2a931', '#3157e2'];
    ?>

    <script>
        // --------- credit chart ---------
        var ctx_recourse = document.getElementById("myChart");
        var myPieChart2 = new Chart(ctx_recourse, {
            type: 'doughnut'
            , data: {
                labels: [
                    <?php $__currentLoopData = $branch_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    "<?php echo e($item->branch->name); ?>"
                    , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
                , datasets: [{
                    data: [
                        <?php $__currentLoopData = $branch_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> {
                            {
                                $item - > total.
                                ','
                            }
                        }
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                    , <?php
                    $i = 0;
                    ?>
                    backgroundColor: [
                        <?php $__currentLoopData = $branch_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($chart_color[$i]); ?>'
                        , <?php
                        $i++;
                        ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                , }]
            , }
            , options: {
                maintainAspectRatio: false
                , tooltips: {
                    backgroundColor: "rgb(255,255,255)"
                    , bodyFontColor: "#858796"
                    , borderColor: '#dddfeb'
                    , borderWidth: 1
                    , xPadding: 15
                    , yPadding: 15
                    , displayColors: false
                    , caretPadding: 10
                    , callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.yLabel;
                        }
                    }
                }
                , plugins: {
                    legend: {
                        display: true
                    }
                    , colorschemes: {
                        scheme: 'brewer.Paired12'
                    }
                }
                , cutoutPercentage: 80
            , }
        , });

        // --------- doctor chart ---------
        var ctx_recourse = document.getElementById("myChart-doctor");
        var myPieChart2 = new Chart(ctx_recourse, {
            type: 'doughnut'
            , data: {
                labels: [
                    <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    "<?php echo e($item->doctor->name); ?>"
                    , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
                , datasets: [{
                    data: [
                        <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> {
                            {
                                $item - > total.
                                ','
                            }
                        }
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                    , <?php
                    $i = 0;
                    ?>
                    backgroundColor: [
                        <?php $__currentLoopData = $doctor_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($chart_color[$i]); ?>'
                        , <?php
                        $i++;
                        ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                , }]
            , }
            , options: {
                maintainAspectRatio: false
                , tooltips: {
                    backgroundColor: "rgb(255,255,255)"
                    , bodyFontColor: "#858796"
                    , borderColor: '#dddfeb'
                    , borderWidth: 1
                    , xPadding: 15
                    , yPadding: 15
                    , displayColors: false
                    , caretPadding: 10
                    , callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.yLabel;
                        }
                    }
                }
                , plugins: {
                    legend: {
                        display: true
                    }
                    , colorschemes: {
                        scheme: 'brewer.Paired12'
                    }
                }
                , cutoutPercentage: 80
            , }
        , });

        // --------- doctor chart ---------
        var ctx_recourse = document.getElementById("myChart-machine");
        var myPieChart2 = new Chart(ctx_recourse, {
            type: 'doughnut'
            , data: {
                labels: [
                    <?php $__currentLoopData = $machine_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    "<?php echo e($item->machine->name); ?>"
                    , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
                , datasets: [{
                    data: [
                        <?php $__currentLoopData = $machine_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> {
                            {
                                $item - > total.
                                ','
                            }
                        }
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                    , <?php
                    $i = 0;
                    ?>
                    backgroundColor: [
                        <?php $__currentLoopData = $machine_pulses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        '<?php echo e($chart_color[$i]); ?>'
                        , <?php
                        $i++;
                        ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    ]
                , }]
            , }
            , options: {
                maintainAspectRatio: false
                , tooltips: {
                    backgroundColor: "rgb(255,255,255)"
                    , bodyFontColor: "#858796"
                    , borderColor: '#dddfeb'
                    , borderWidth: 1
                    , xPadding: 15
                    , yPadding: 15
                    , displayColors: false
                    , caretPadding: 10
                    , callbacks: {
                        label: function(tooltipItem) {
                            return tooltipItem.yLabel;
                        }
                    }
                }
                , plugins: {
                    legend: {
                        display: true
                    }
                    , colorschemes: {
                        scheme: 'brewer.Paired12'
                    }
                }
                , cutoutPercentage: 80
            , }
        , });

    </script>

    <!-- -- datatables plugin -- -->
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/1.11.3/js/dataTables.bootstrap5.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.bootstrap5.min.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>

    <script type="text/javascript" language="javascript"
        src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.colVis.min.js"></script>
    <script
        src="https://nightly.datatables.net/fixedheader/js/dataTables.fixedHeader.js?_=f0de745b101295e88f1504c17177ff49">
    </script>

    <script>
        $(document).ready(function() {

            var table = $('#table-income-all').DataTable({
                    lengthChange: false
                    , "pageLength": 10
                    , "order": [
                        [0, "ASC"]
                    ]
                    , buttons: {
                        dom: {
                            button: {
                                className: 'btn btn-table-export me-0' //Primary class for all buttons
                            }
                        }
                        , buttons: [{
                                extend: 'copyHtml5'
                                , footer: true
                            }
                            , {
                                extend: 'excelHtml5'
                                , footer: true
                            }
                            , {
                                extend: 'pdfHtml5'
                                , footer: true
                            }
                            , {
                                extend: 'print'
                                , footer: true
                            }
                        ]
                    }
                }

            );
            table.buttons().container()
                .appendTo('#table-income-all_wrapper .col-md-6:eq(0)');

            var table = $('#table-expenses-all').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-expenses-all_wrapper .col-md-6:eq(0)');

            var table = $('#table-income-totals-cat').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-income-totals-cat_wrapper .col-md-6:eq(0)');


            var table = $('#table-machine-totals-cat').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-machine-totals-cat_wrapper .col-md-6:eq(0)');

            var table = $('#table-expenses-totals-cat').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-expenses-totals-cat_wrapper .col-md-6:eq(0)');

            var table = $('#table-income-totals').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-income-totals_wrapper .col-md-6:eq(0)');

            var table = $('#table-expenses-totals').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-expenses-totals_wrapper .col-md-6:eq(0)');

            var table = $('#table-operation-income-all').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-operation-income-all_wrapper .col-md-6:eq(0)');

            var table = $('#table-operation-expenses-all').DataTable({
                lengthChange: false
                , "pageLength": 10
                , "order": [
                    [0, "ASC"]
                ]
                , buttons: {
                    dom: {
                        button: {
                            className: 'btn btn-table-export me-0' //Primary class for all buttons
                        }
                    }
                    , buttons: [{
                            extend: 'copyHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'excelHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'pdfHtml5'
                            , footer: true
                        }
                        , {
                            extend: 'print'
                            , footer: true
                        }
                    ]
                }
            });
            table.buttons().container()
                .appendTo('#table-operation-expenses-all_wrapper .col-md-6:eq(0)');

        });

    </script>

    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digiflydev/public_html/dev.mdex/resources/views/patient/pulses/daypulses.blade.php ENDPATH**/ ?>