<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\Patient\Patient;
use App\Models\Branch\Branch;
class CodeRule implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct($code,$branch_id)
    {
        $this->code = $code;
        $this->branch = Branch::select('id', 'code')->find($branch_id);
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {

        $code = $this->branch->code . "-" . $this->code;
        if(Patient::where("code", "=", $code)->first()){
            return false;

        }else{
            return true;
        }
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'This code exists before';
    }
}
