<?php

namespace App\Models\Patient;

use App\Models\Branch\Appointment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Disease extends Model
{
    use HasFactory;

    protected $fillable = [
        'id',
        'pat_examination_id',
        'disease_cats',
        'calendable_id',
        'calendable_type',
        'patient_id',
        'start',
        'end',
        'status',
    ];

    public function diseasecats()
    {
        return $this->belongsTo(Disease_cat::class, 'disease_cats', 'id');
    }

    public function appointment()
    {
        return $this->belongsTo(Appointment::class, 'appointment_id', 'id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id', 'id');
    }

    public function calendable()
    {
        return $this->morphTo();
    }
}
